;***************************************
;*  WhoAmI by Tom Marshall - 08/16/94
;*   Released into the public domain
;***************************************
;* Prints path/file name in environment
;* tail two ways:
;*  - As passed by DOS
;*  - After canonicalization
;* To see function 21/60 in action,
;* type ".\whoami" using COMMAND.COM.
;***************************************
                MODEL   TINY
                CODESEG
                ORG     0100h

Start:          mov     ah,30h                  ;Get DOS version
                int     21h
                cmp     al,3                    ;Ensure 3.0 or higher
                mov     al,80h
                jb      Error

                mov     dx,OFFSET AsPassed$
                call    PrintString
                jc      Error

                mov     es,[ds:002Ch]           ;Get environment segment
                xor     di,di                   ;ES:DI = Start of env.
                xor     al,al                   ;Look for a null
                cld                             ;Ensure DF = +

NextString:     mov     cx,0FFFFh               ;Setup search length
                repne scasb                     ;Find end of current string
                cmp     [es:di],al              ;Double-null is end of env.
                jne     NextString              ;Keep going till end

                cmp     WORD PTR [es:di+1],1    ;Should be 1
                mov     al,81h
                jnz     Error
                add     di,3                    ;Index pathname

                mov     si,OFFSET PathName1$    ;Copy string
CopyLoop:       mov     al,[es:di]
                inc     di
                mov     [si],al
                inc     si
                or      al,al
                jnz     CopyLoop
                push    ds                      ;Reset ES
                pop     es

                mov     dx,OFFSET PathName1$
                call    PrintString             ;Print name as found
                jc      Error

                mov     dx,OFFSET CRLF$
                call    PrintString
                jc      Error
                mov     dx,OFFSET AfterCanon$
                call    PrintString
                jc      Error

                mov     si,OFFSET PathName1$    ;Original path in DS:SI
                mov     di,OFFSET PathName2$    ;Buffer for result in ES:DI
                mov     ah,60h                  ;Resolve (canonicalize)
                int     21h
                jc      Error

                mov     dx,OFFSET PathName2$
                call    PrintString             ;Print canonicalized name
                jc      Error

                mov     dx,OFFSET CRLF$
                call    PrintString
                jc      Error

                mov     ax,4C00h                ;That's it.. bye!
                int     21h

Error:          push    ax                      ;Save error code
                mov     si,OFFSET ErrorTable    ;Index error table

NextErr:        inc     si                      ;Point to string
                cmp     [si-1],al               ;Check error code
                jz      DispErr
                cmp     BYTE PTR [si-1],-1      ;Check for end of table
                jz      DispErr

LoopErr:        inc     si                      ;Find next string
                cmp     BYTE PTR [si],0
                jne     LoopErr
                inc     si
                jmp     NextErr

DispErr:        mov     dx,si                   ;Print the error
                call    PrintString
                mov     dx,OFFSET CRLF$
                call    PrintString

                pop     ax                      ;Exit with errorlevel
                mov     ah,4Ch                  ;  equal to error code
                int     21h

;***************************************
;* Print ASCIIZ string to STDOUT
;* Entry: DS:DX = Address of string
;* Exit : CF, AX as set by 21/40
;* Regs : All general regs destroyed
;*        except DX
;***************************************
PrintString     PROC
                push    dx
                push    es

                push    ds                      ;Setup ES:DI
                pop     es
                mov     di,dx
                mov     cx,0FFFFh               ;Find length of string
                xor     al,al
                cld
                repne scasb
                neg     cx
                sub     cx,2
                mov     bx,1                    ;Write string to STDOUT
                mov     ah,40h
                int     21h

                pop     es
                pop     dx
                ret
PrintString     ENDP

ErrorTable      DB      02h,"DOS Error: Invalid source name",0
                DB      03h,"DOS Error: Invalid drive or path",0
                DB      05h,"DOS Error: Access denied",0
                DB      06h,"DOS Error: Invalid handle",0
                DB      80h,"DOS 3.0 or higher required",0
                DB      81h,"Unrecognized environment tail",0
                DB      -1 ,"Unrecognized error from DOS",0

AsPassed$       DB      'Name from environment   : ',0
AfterCanon$     DB      'Name after canonicalize : ',0
CRLF$           DB      13,10,0

PathName1$      DB      128 dup (?)
PathName2$      DB      128 dup (?)

                END     Start
