;----------------------------------
; TSRTEMPL.ASM -  A TSR template from Mitch Ames

.radix  16
.model  tiny
.code
org     0100

start:  jmp     init

; Resident code

int_xx: resident code (Int xx handler) goes here

end_tsr_code    equ     $

; Resident data

org_xx  dd      ?                       ;original vector


; Non resident code

init:   mov     si,80                   ;pointer to command line
init1:  inc     si
        cmp     word ptr [si],"u/"      ;check for unload
        je      unload
        cmp     word ptr [si],"U/"
        je      unload
        cmp     byte ptr [si],cr
        jne     init1

Installation pre-processing goes here

; Install TSR

        mov     ax,35xx                 ;save current interrupt vector
        int     21
        mov     word ptr org_xx,bx
        mov     word ptr org_xx+2,es
        mov     dx,offset int_xx        ;point vector to new routine
        mov     ax,25xx
        int     21

        mov     dx,offset loaded        ;display message
        mov     ah,9
        int     21
        mov     ax,3100                 ;terminate and stay resident
        mov     dx,(init-start+10F)/10  ;number of paragraphs to reserve
        int     21

; Unload TSR

unload:

; Repeat this bit for each vector

        mov     ax,35xx                 ;get interrupt vector
        int     21
        mov     di,bx                   ;point ES:DI to interrupt routine
        mov     si,offset int_xx        ;point DS:SI to this program's TSR code
        mov     cx,end_tsr_code-int_xx  ;length of code
        repe    cmpsb                   ;compare them
        jne     fail                    ;quit if they're not the same
        push    ds                      ;save program DS
        lds     dx,es:org_xx            ;restore original interrupt
        mov     ax,25xx
        int     21
        pop     ds                      ;restore program DS

; End of repeatable bit

        push    es                      ;save TSR program segment
        mov     bx,es                   ;and copy to BX
        mov     ax,es:2C                ;get TSR's environment segment to AX
        push    ax                      ;save it
        dec     ax                      ;get memory control block's segment
        mov     es,ax                   ;to ES
        cmp     bx,es:[1]               ;check that environment block is still
                                        ;owned by TSR program block
        jne     fail                    ;quit if not
        pop     es                      ;restore TSR's environment segment
        mov     ah,49                   ;release memory
        int     21
        jc      fail                    ;quit if it fails
        pop     es                      ;restore TSR program segment
        mov     ah,49                   ;release memory
        int     21
        mov     dx,offset unloded       ;message if successful
        mov     al,0                    ;errorlevel = 0
        jnc     quit                    ;quit if succeeded
fail:   mov     dx,offset no_unld       ;message if failed
        mov     al,1                    ;errorlevel = 1

; Quit with message at DS:DX and errorlevel in AL

quit:   push    ax
        mov     ah,9                    ;write message in DS:DX
        int     21
        pop     ax
        mov     ah,4C                   ;terminate with exit code
        int     21

loaded  db      ??filename," loaded.",cr,lf,"$"
unloded db      ??filename," unloaded.",cr,lf,"$"
no_unld db      "Can't unload ",??filename,cr,lf,"$"

end     start


