;TOADTSR.ASM
;Hook into INT 21H.
;Block all 0FE02H services.
;Fiddle all INT 2 (display character) services
;
;Using bits and pieces of TBONES07.ZIP's TSRINT.ASM for
;the environment-tweaking stuff.

;Given to the Public Domain, 30 Apr 94
;David Kirschbaum, Toad Hall
;kirschd@sesi.com, toadhall@ljl.com
;
;TOADTSR version 1.20
;repaired and tweaked on Saturday, 7 May 94 (v. 1.20)
;by Ed Beroset (Fidonet:   1:3641/1.250)
;and returned to the pulic domain
; added a few handy constants
; modified environment tweak.  I'm not sure about Kim Kokkonen's
;   MAPMEM, but mine is able to fetch the name from the last 8 bytes of
;   the arena block if no environment exists.  Maybe somebody should
;   suggest this to Kim if it's not already implemented?  Most of the
;   time the command processor will set up this area, but some TSRs
;   (notably Novell's NETX) block this behavior, so the TSR explicitly
;   copies the name.  This mechanism also allows self-recognition in
;   memory, even if the executable file's name has been changed.
; added "slider" code to move the resident code down deep into the PSP,
;   thereby saving a couple of paragraphs.  This also means that the
;   code no longer needs to be paragraph aligned.
; changed old interrupt chaining so that minimal space is required
; altered blocked service return to use iret and only alter the flag(s)
;   we need to modify.

CR      EQU     0DH
LF      EQU     0AH

BADSVC          EQU     0FE02H  ;check out Ralf Brown's INTERRUP.E
BADCHAR1        EQU     's'
BADCHAR2        EQU     'S'
NEWCHAR1        EQU     'z'
NEWCHAR2        EQU     'Z'

HOOKEDINT       = 21h           ;make it easier to troubleshoot
PSPBOTTOM       = 3ch           ;offset within PSP to which TSR code will
                                ; be copied
FARJUMP         = 0eah          ; opcode for far jump

        CSEG    SEGMENT PUBLIC WORD 'CODE'
        ASSUME  CS:CSEG,DS:CSEG
BeginDump       EQU     $

                org     2CH             ;ORG in PSP to pick up env. segment.
envseg          label   word            ;environment segment

                org     100h            ;ORG for all COM programs.

Toadchar PROC   NEAR
        jmp     Install                 ;skip over the TSR
Toadchar ENDP


New_Int21       PROC    FAR

;First, the dark side of the Force...

        cmp     ax,BADSVC               ;this service?
        jnz     Chk_Others              ;nope
        mov     ax,bp                   ;save current bp
        mov     bp,sp                   ;point to stack
        or      byte ptr [bp+4],01h     ;set the carry bit in saved flags
        mov     bp,ax                   ;recover old bp
        mov     ax,01FDH                ;check out Brown's INTERRUP.E
        iret                            ;We don' do no feelthy BADSVC

Chk_Others:

;Let's show a little finesse.

        cmp     ah,2                    ;display char function?
        jnz     On_On
         cmp    dl,BADCHAR1             ;the target character?
         jz     Got1                    ;yep
         cmp    dl,BADCHAR2             ;this one?
         jnz    On_On                   ;nope
          mov   dl,NEWCHAR2
          jmp   short On_On

Got1:   mov     dl,NEWCHAR1

On_On:
        db      FARJUMP                 ;far jmp opcode
old_21  dd      0                       ;saved vector

New_Int21       ENDP


Install PROC    NEAR
EndDump         EQU     $

        push    ES                      ;save to be neat

;from TBONES
;       To conserve memory, release from memory the copy of the DOS
;       Environment passed to this TSR (this, of course, assumes that
;       your Interrupt handler will not be written to reference this
;       de-allocated Environment. If you are going to need it, don't
;       de-allocate it.):

        mov     ES,envseg               ;get environment segment v0.11
                                        ;from Program Segment Prefix.
        mov     ah,49h                  ;DOS Fcn 49h = Release Memory
        int     21h                     ;Release it via DOS interrupt.

        mov     ax,3500H + HOOKEDINT    ;get old interrupt vector
        int     21H
        mov     word ptr old_21,bx      ;save offset
        mov     word ptr old_21+2,ES    ;and segment

; move the TSR name into the 2nd half of MCB structure (v. 1.20)

        mov     si,ds                   ;point to our code segment
        dec     si                      ;point our own MCB area
        mov     es,si                   ;which is the destination
        mov     si,OFFSET tsrname       ;copy from tsrname (the source)
        mov     di,8                    ;copy to second half of MCB area
        mov     cx,di                   ;copy exactly 8 bytes
        cld                             ;move forward
        rep     movsb                   ;move 'em

; slide the TSR code down into the PSP to save memory (v. 1.20)

        pop     es                      ;just to be neat
        mov     si,OFFSET New_Int21     ;now point to current location
        mov     di,PSPBOTTOM            ;point to destination location
        mov     cx,(Install - New_Int21);move this many bytes
        rep     movsb                   ;move 'em (dir flag already clr)

; assign the new (moved) vector

        mov     dx,PSPBOTTOM            ;new service
        mov     ax,2500H + HOOKEDINT    ;set new INT 21H vector
        int     21H

        mov     si,offset InstallMsg
        mov     cx,MSGLEN               ;chars to display
        mov     ah,2                    ;display char function
DisplayLup:
        lodsb                           ;snarf char
        mov     dl,al                   ;char into DL
        int     21H                     ;display it
        loop    DisplayLup
                            
; calculate number of paragraphs to keep and exit as TSR (v. 1.20)

        mov     dx,((Install - New_Int21) + PSPBOTTOM + 0fh)/16
        mov     ah,31h                  ;go TSR
        int     21h

TsrName:
        db      "TOADTSR",0    ; must be EXACTLY 8 characters long --
                               ; omit terminating NUL if the name
                               ; is exactly 8 chars long. (v. 1.20)
InstallMsg:
        db      CR,LF
        db      'YOUR HOOKED INTERRUPT TSR IS NOW INSTALLED.',CR,LF
        db      'Hooked Interrupt => Int 21H)',CR,LF
        db      'And now for something completely different.'
        db      CR,LF
MSGLEN  EQU     $-InstallMsg

Install ENDP

CSEG    ENDS
        END     Toadchar

