;----------------------
; drl.asm - Puts a drive activity light in the upper right
; corner of your screen. Source listing by James Vahn.
; Disassembled from a program written by Tim Zerabaldi.

cseg segment
assume cs:cseg,ds:cseg
org 100h

Begin:
        JMP     Init

 sto1   db 0
 sto2   db 0                ; Color byte. Red for HD, green for FD
 screen dw 0
 tmp    dw 0                      ; Video controller Port.
 tmp2   dw 0                      ; Old vector.
 tmp3   dw 0

New_ISR:
        CMP     DL,80h            ;Is it the hard drive?
        JNB     Skip1
        MOV     cs:sto2,20h       ;Nope, set color to green.
        JMP     Skip2
 Skip1:
        MOV     cs:sto2,40h       ;Yup, set color to red.
 Skip2:
        PUSH    AX
        push    bx
        PUSH    DX
        PUSH    DS
        MOV     DS,cs:screen
        MOV     DX,cs:tmp
        MOV     AH,cs:sto2
 lo1:
        IN      AL,DX
        TEST    AL,01h            ;Wait for video enable.
        JNZ     lo1
        CLI
 lo2:
        IN      AL,DX
        TEST    AL,01h            ;Wait for disable.
        JZ      lo2
        CMP     cs:sto2,40h
        JNZ     Skip3
        mov     bx,09Fh           ;Set color for hard drive.
        XCHG    AH,byte ptr[bx]
        JMP     Skip4
 Skip3:
        mov     bx,09Dh           ;Set color for floppy disk.
        XCHG    AH,byte ptr[bx]
 Skip4:
        STI
        MOV     cs:sto1,AH
        POP     DS
        POP     DX
        pop     bx
        POP     AX
        PUSHF
        CALL    dword ptr cs:tmp2       ;Call old INT 13
        PUSHF
        PUSH    AX
        push    bx
        PUSH    DX
        PUSH    DS
        MOV     DS,cs:screen
        MOV     DX,cs:tmp
        MOV     AH,cs:sto1
 lo3:
        IN      AL,DX             ;Test for enable.
        TEST    AL,01h
        JNZ     lo3
        CLI
 lo4:
        IN      AL,DX             ;Test for disable.
        TEST    AL,01h
        JZ      lo4
        CMP     cs:sto2,40h
        JNZ     Skip5

        mov     bx,09Fh           ;Turn HD color off.
        MOV     [bx],AH
        JMP     Skip6
 Skip5:
        mov     bx,09Dh           ;Turn FD color off.
        MOV     [bx],AH
 Skip6:
        STI
        POP     DS
        POP     DX
        pop     bx
        POP     AX
        POPF
        RETF    0002

Init:

        mov     dx,offset msg     ;Hello!
        mov     ah,09h
        int     21h

        mov     bx,02Ch           ;Free environment space.
        mov     es,[bx]
        mov     ah,49h
        int     21h

        INT     11h               ;Get equipment list
        AND     AL,30h
        MOV     screen,0B000h     ;Our screen addresses
        CMP     AL,30h
        JZ      Skip7
        MOV     screen,0B800h
 Skip7:
        PUSH    ES
        SUB     AX,AX
        MOV     ES,AX
        MOV     AX,es:[0463h]     ;Get port address for Video
        ADD     AX,0006h
        MOV     tmp,AX
        MOV     AX,3513h          ;Save old INT 13 vector
        INT     21h
        MOV     tmp2,BX
        MOV     tmp3,ES
        LEA     DX,New_ISR        ;Install new INT 13 vector
        MOV     AX,2513h
        INT     21h
        POP     ES
        LEA     DX,Init
        INT     27h               ;Go TSR

msg db 'On-screen drive activity light installed',13,10,36

cseg ends
end Begin


