;---------------------------
;CHECK_ANSI - check if ANSI active by Jeff Owens
;
; inputs:    none
; 
; output:    CF = 1 if no ANSI driver active
;            CF = 0 if ANSI active
;* * * * * * * * * * * * * *

	public	CHECK_ANSI
CHECK_ANSI		PROC	FAR
     APUSH   AX,DX,DS
     call    is_stdout_console
     test    al,al
     jz      no_ansi		;jmp if output redirected (force no ansi)
     MOV     AX,CS
     MOV     DS,AX
     CALL    console_input
     CALL    CHECK_ANSI_cont1

     DB	     1BH,'[6n$'
;
CHECK_ANSI_cont1:
     POP     DX
     CALL    console_output
     MOV     AH,0Bh		;check STDIN status, al=ff if input
     INT     21h
     CMP     AL,0FFh
     JZ      IA_1		;jmp if char. is ready from ansi call
     CALL    isansi_cont2

     db	     0dH,'    ',0dH,'$'

isansi_cont2:
     POP	DX
     CALL    console_output
     STC
     JMP     IA_2
IA_1:
     CALL    console_input
     CLC
IA_2:
     APOP    DS,DX,AX
     JB      NO_ANSI
     CLC
     RETF
NO_ANSI:
     STC
     RETF
CHECK_ANSI	ENDP
;------------------------------
console_output:
     MOV     AH,09
     INT     21h
     RET

console_input:
     MOV     AH,06
     MOV     DL,0FFh
     INT     21h
     JNZ     console_input
     RET

;---------------------------
;is_stdout_console - check if stdout redirected to file.
;
; inputs:    none
; 
; output:    al =  2  stdout is console
;                  0  stdout is file, printer, or other
;* * * * * * * * * * * * * *

	PUBLIC	is_stdout_console
is_stdout_console		PROC	FAR
	apush	bx,dx
	mov	bx,1		;handle 0=stdin 1=stdout 2=con 3=aux 4=prn
	mov	ax,4400h	;ioctrl (get device data)
	int	21h		;dx is returned with device/file info
	mov	al,0
	test	dh,80h		;check if file or device
	jz	stdout_file	;jmp if file (redirected)
	mov	al,dl
	and	al,02h		;isolate stdout bit
stdout_file:
	apop	dx,bx
	retf	
is_stdout_console ENDP


