;-------------------------
;    From: david nugent
;    Origin: Unique Computing Pty Ltd (3:632/348)

    .386
    .model flat,syscall

    .data

crctab  LABEL DWORD

    DWORD 000000000H,077073096H,0ee0e612cH,0990951baH
    DWORD 0076dc419H,0706af48fH,0e963a535H,09e6495a3H
    DWORD 00edb8832H,079dcb8a4H,0e0d5e91eH,097d2d988H
    DWORD 009b64c2bH,07eb17cbdH,0e7b82d07H,090bf1d91H
    DWORD 01db71064H,06ab020f2H,0f3b97148H,084be41deH
    DWORD 01adad47dH,06ddde4ebH,0f4d4b551H,083d385c7H
    DWORD 0136c9856H,0646ba8c0H,0fd62f97aH,08a65c9ecH
    DWORD 014015c4fH,063066cd9H,0fa0f3d63H,08d080df5H
    DWORD 03b6e20c8H,04c69105eH,0d56041e4H,0a2677172H
    DWORD 03c03e4d1H,04b04d447H,0d20d85fdH,0a50ab56bH
    DWORD 035b5a8faH,042b2986cH,0dbbbc9d6H,0acbcf940H
    DWORD 032d86ce3H,045df5c75H,0dcd60dcfH,0abd13d59H
    DWORD 026d930acH,051de003aH,0c8d75180H,0bfd06116H
    DWORD 021b4f4b5H,056b3c423H,0cfba9599H,0b8bda50fH
    DWORD 02802b89eH,05f058808H,0c60cd9b2H,0b10be924H
    DWORD 02f6f7c87H,058684c11H,0c1611dabH,0b6662d3dH
    DWORD 076dc4190H,001db7106H,098d220bcH,0efd5102aH
    DWORD 071b18589H,006b6b51fH,09fbfe4a5H,0e8b8d433H
    DWORD 07807c9a2H,00f00f934H,09609a88eH,0e10e9818H
    DWORD 07f6a0dbbH,0086d3d2dH,091646c97H,0e6635c01H
    DWORD 06b6b51f4H,01c6c6162H,0856530d8H,0f262004eH
    DWORD 06c0695edH,01b01a57bH,08208f4c1H,0f50fc457H
    DWORD 065b0d9c6H,012b7e950H,08bbeb8eaH,0fcb9887cH
    DWORD 062dd1ddfH,015da2d49H,08cd37cf3H,0fbd44c65H
    DWORD 04db26158H,03ab551ceH,0a3bc0074H,0d4bb30e2H
    DWORD 04adfa541H,03dd895d7H,0a4d1c46dH,0d3d6f4fbH
    DWORD 04369e96aH,0346ed9fcH,0ad678846H,0da60b8d0H
    DWORD 044042d73H,033031de5H,0aa0a4c5fH,0dd0d7cc9H
    DWORD 05005713cH,0270241aaH,0be0b1010H,0c90c2086H
    DWORD 05768b525H,0206f85b3H,0b966d409H,0ce61e49fH
    DWORD 05edef90eH,029d9c998H,0b0d09822H,0c7d7a8b4H
    DWORD 059b33d17H,02eb40d81H,0b7bd5c3bH,0c0ba6cadH
    DWORD 0edb88320H,09abfb3b6H,003b6e20cH,074b1d29aH
    DWORD 0ead54739H,09dd277afH,004db2615H,073dc1683H
    DWORD 0e3630b12H,094643b84H,00d6d6a3eH,07a6a5aa8H
    DWORD 0e40ecf0bH,09309ff9dH,00a00ae27H,07d079eb1H
    DWORD 0f00f9344H,08708a3d2H,01e01f268H,06906c2feH
    DWORD 0f762575dH,0806567cbH,0196c3671H,06e6b06e7H
    DWORD 0fed41b76H,089d32be0H,010da7a5aH,067dd4accH
    DWORD 0f9b9df6fH,08ebeeff9H,017b7be43H,060b08ed5H
    DWORD 0d6d6a3e8H,0a1d1937eH,038d8c2c4H,04fdff252H
    DWORD 0d1bb67f1H,0a6bc5767H,03fb506ddH,048b2364bH
    DWORD 0d80d2bdaH,0af0a1b4cH,036034af6H,041047a60H
    DWORD 0df60efc3H,0a867df55H,0316e8eefH,04669be79H
    DWORD 0cb61b38cH,0bc66831aH,0256fd2a0H,05268e236H
    DWORD 0cc0c7795H,0bb0b4703H,0220216b9H,05505262fH
    DWORD 0c5ba3bbeH,0b2bd0b28H,02bb45a92H,05cb36a04H
    DWORD 0c2d7ffa7H,0b5d0cf31H,02cd99e8bH,05bdeae1dH
    DWORD 09b64c2b0H,0ec63f226H,0756aa39cH,0026d930aH
    DWORD 09c0906a9H,0eb0e363fH,072076785H,005005713H
    DWORD 095bf4a82H,0e2b87a14H,07bb12baeH,00cb61b38H
    DWORD 092d28e9bH,0e5d5be0dH,07cdcefb7H,00bdbdf21H
    DWORD 086d3d2d4H,0f1d4e242H,068ddb3f8H,01fda836eH
    DWORD 081be16cdH,0f6b9265bH,06fb077e1H,018b74777H
    DWORD 088085ae6H,0ff0f6a70H,066063bcaH,011010b5cH
    DWORD 08f659effH,0f862ae69H,0616bffd3H,0166ccf45H
    DWORD 0a00ae278H,0d70dd2eeH,04e048354H,03903b3c2H
    DWORD 0a7672661H,0d06016f7H,04969474dH,03e6e77dbH
    DWORD 0aed16a4aH,0d9d65adcH,040df0b66H,037d83bf0H
    DWORD 0a9bcae53H,0debb9ec5H,047b2cf7fH,030b5ffe9H
    DWORD 0bdbdf21cH,0cabac28aH,053b39330H,024b4a3a6H
    DWORD 0bad03605H,0cdd70693H,054de5729H,023d967bfH
    DWORD 0b3667a2eH,0c4614ab8H,05d681b02H,02a6f2b94H
    DWORD 0b40bbe37H,0c30c8ea1H,05a05df1bH,02d02ef8dH

    .code


    ; CCITT 32-bit CRC generator
    ;
    ; unsigned long crc32c (void * buf, unsigned long inival, int leng)
    ;
    ; return CRC-32 of a given block
    ;
    ; Use -1L for start value - to CRC multiple blocks, pass the
    ; output CRC-32 of each block as the 'inival' for the next
    ;


crc32c  PROC USES esi, buf:PTR, inival:DWORD, leng:DWORD

    mov     eax,[inival]
    mov     ecx,[leng]
    jcxz short @e0
    mov     esi,[buf]

  @l0:

    movzx   ebx,Byte Ptr [esi]
    inc     esi
    xor     bl,al
    shl     ebx,2
    shr     eax,8
    xor     eax,crctab[ebx]
    dec     ecx                 ; loop @l0
    jnz short @l0

  @e0:

    ret

crc32c  ENDP

END

