/* globber.c - wildcard file globbing, original by John Kercheval, */
/* buf_upper() by Robert Jung */

/*/////////////////////////// History /////////////////////////////////////*/
/* 05/07/92 McCombs    - replaced call to toupper() in find_firstfile()    */
/*          Jung         with call to buf_upper() by Robert Jung           */
/* 05/05/92 McCombs    - combined WILDFILE.C and FILMATCH.C into GLOBBER.C */
/*                     - removed most portability #ifdef's, main(), and    */
/*                       attribute constants                               */
/*                     - removed extensive comments by Kercheval - added   */
/*                       reference to WILDF113.[archive] as credits        */
/* 03/31/91 Kercheval  - change '/' to '\\' in path                        */
/*                     - rename time and date defines                      */
/* 03/28/91 Kercheval  - move DOT_LAST to find_firstfile()                 */
/*                     - add in PATTERN_ESC & MATCH_LITERAL                */
/*                     - include filmatch.h                                */
/* 03/16/91 Kercheval  - add and use FileInfo struct                       */
/*                     - add status byte and '.' checking                  */
/*                     - _FA_NORMAL files unique, similar to _FA_READONLY  */
/*                       behavior                                          */
/* 03/14/91 Kercheval  - remove '\' for DOS file parsing                   */
/*                     - ifdef attribute constants                         */
/* 03/12/91 Kercheval  - Released as V1.1 to Public Domain                 */
/* 03/10/91 Kercheval  - add error return to matche()                      */
/*                     - add error_type in is_valid_pattern                */
/*                     - add is_valid_pattern code                         */
/*                     - beef up main()                                    */
/* 02/22/91 Kercheval  - fix '\' bugs (two :( of them)                     */
/* 02/20/91 Kercheval  - Released to Public Domain                         */
/*/////////////////////////////////////////////////////////////////////////*/

#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include "globber.h"

BOOLEAN find_firstfile( FileInfo *ff )
{
   char path[MAXPATH+1];        /* found file and path */
   char *c;                     /* temporary pointer variable */

   int error_return;            /* error return from is_valid_pattern */

   BOOLEAN found;               /* looping flag */
   BOOLEAN dot_found;           /* '.' character checking */

   /* empty strings are bummers, aren't they? */
   if ( !*(ff->file_pattern) ) {
       return FALSE;
   }

    /* convert to upper case */
    c = ff->file_pattern;
    while ( *c ) {
          /**c = (char) toupper(*c);*/
          buf_upper(c, strlen(c));
    
          /* if the last pattern char is '.' then set status byte correctly */
          if ( *c == '.' )
                ff->status |= DOT_LAST;
          else
                ff->status &= ~DOT_LAST;
          c++;
    }

    /* check for valid pattern string */
    if ( !is_valid_pattern(ff->file_pattern,&error_return) ) {
          return FALSE;
    }

    /* copy the path portion of the pattern to file_path */
    splitpath( ff );

    /* create the search path */
    strcpy(path,ff->file_path);
          strcat(path,"*.*");

    /* check that the search path will not be too long */
    if ( strlen(path) > MAXPATH ) {
          return FALSE;
    }

    /* obtain the first file conforming to path */
    if ( findfirst(path, &(ff->file), (ff->file_attributes) & ~FA_NORMAL) ) {
          return(FALSE);
    }

    /* if the file name is empty we want it not */
    if ( !*(ff->file.name) ) {
          return(FALSE);
    }

    /* init looping variable */
    found = FALSE;

    /* Build path and file name needed for validation */
    strcpy(path,ff->file_path);
    strcat(path,ff->file.name);

    /* Check for '.' if required */
    if ( ff->status & DOT_LAST ) {

           /* init looping variables */
           dot_found = FALSE;
           c = ff->file.name;

           /* see if file has extension and give it '.' if not */
           while ( *c ) {
                   if ( *c == '.' )
                          dot_found = TRUE;
                   c++;
           }
           if ( !dot_found )
                   strcat(path,".");
    }

    /* Verify name and attribute wanted for files */
    if ( match(ff->file_pattern,path) ) {
           if ( !ff->file.attributes ) {
                   if ( ff->file_attributes & 0x40 ) {
                            found = TRUE;
                   }
           }
           else {
                   if ( ff->file_attributes & ff->file.attributes ) {
                            found = TRUE;
                   }
           }
    }

    while ( !found ) {

           /* obtain the next file comforming to path */
           if ( findnext(&(ff->file)) ) {
                    return(FALSE);
           }
           /* if the file name is empty we want it not */
           if ( !*(ff->file.name) ) {
                    return(FALSE);
           }

           /* Build path and file name needed for validation */
           strcpy(path,ff->file_path);
			  strcat(path,ff->file.name);

           /* Check for '.' if required */
           if ( ff->status & DOT_LAST ) {
                    /* init looping variables */
                    dot_found = FALSE;
                    c = ff->file.name;

                    /* see if file has extension and give it '.' if not */
                    while ( *c ) {
                            if ( *c == '.' )
                                    dot_found = TRUE;
                            c++;
                    }
                    if ( !dot_found )
                            strcat(path,".");
           }

           /* Verify name and attribute wanted for files */
			  if ( match(ff->file_pattern, path) ) {
                    if ( !ff->file.attributes ) {
                            if ( ff->file_attributes & 0x40 ) {
                                     found = TRUE;
                            }
                    }
                    else {
                            if ( ff->file_attributes & ff->file.attributes ) {
                                     found = TRUE;
                            }
                    }
           }
    }
    return(TRUE);
}

/* This is a helper function to isolate the pattern from the path. */
void splitpath( FileInfo *ff )
{
	 char *last_slash, *c, oldchar;

    /* init last_slash and c */
    c = last_slash = ff->file_pattern;
           last_slash--;

    /* loop through and find the beginning of the pattern or end of string */
    while ( *c && *c != '[' && *c != '*' && *c != '?' ) {
           /* change '/' to '\' */
           if ( *c == '/' ) {
                   *c = '\\';
           }

           /* if c is a '\' then remember where it is */
           if ( *c == '\\' ) {
                   last_slash = c;
           }

           /* move to next char in pattern */
			  c++;
    }
    /* move to next char beyond '\' or to beginning of string*/
    last_slash++;

    /* store character and make it end of string for now */
    oldchar = *last_slash;
    *last_slash = '\0';

    /* copy the beginning of the path to return value */
    strcpy(ff->file_path, ff->file_pattern);

    /* restore character */
    *last_slash = oldchar;
}

BOOLEAN find_nextfile( FileInfo *ff )
{
    char path[MAXPATH+1];/* full filename and path for pattern checking */
	 char *c;             /* tempory pointer variable */

    BOOLEAN found;       /* looping flag */
    BOOLEAN dot_found;   /* '.' character checking */
    
    found = FALSE;

    while ( !found ) {
         /* obtain the next file comforming to path */
         if ( findnext(&(ff->file)) ) {
                 return(FALSE);
         }

         /* if the file name is empty we want it not */
         if ( !*(ff->file.name) ) {
                 return(FALSE);
         }

         /* Build path and file name needed for validation */
			strcpy(path,ff->file_path);
         strcat(path,ff->file.name);

         /* Check for '.' if required */
         if ( ff->status & DOT_LAST ) {
         
         /* init looping variables */
         dot_found = FALSE;
         c = ff->file.name;

         /* see if file has extension and give it '.' if not */
         while ( *c ) {
                 if ( *c == '.' )
                         dot_found = TRUE;
                 c++;
         }
         if ( !dot_found )
                 strcat(path,".");
    }

    /* Verify name and attribute wanted for files */
    if ( match(ff->file_pattern, path) ) {
         if ( !ff->file.attributes ) {
                 if ( ff->file_attributes & 0x40 ) {
                          found = TRUE;
                 }
         }
         else {
                 if ( ff->file_attributes & ff->file.attributes ) {
                          found = TRUE;
                 }
         }
    }
}
return(TRUE);
}

/* return TRUE if PATTERN has any special wildcard characters */
BOOLEAN is_pattern (char *p)
{
    while ( *p ) {
         switch ( *p++ ) {
                 case '?':
                 case '*':
                 case '[':
                         return TRUE;
         }
    }
    return FALSE;
}

/* Return TRUE if PATTERN has is a well formed regular expression according
   to the above syntax  */
BOOLEAN is_valid_pattern (char *p, int *error_type)
{

     /* init error_type */
	  *error_type = PATTERN_VALID;

     /* loop through pattern to EOS */
     while( *p ) {
           /* determine pattern type */
           switch( *p ) {
                 /* the [..] construct must be well formed */
                 case '[':
                           p++;
                           /* if the next character is ']' then bad pattern */
                           if ( *p == ']' ) {
                                    *error_type = PATTERN_EMPTY;
                                    return FALSE;
                           }
                           /* if end of pattern here then bad pattern */
                           if ( !*p ) {
                                     *error_type = PATTERN_CLOSE;
                                     return FALSE;
                           }

                           /* loop to end of [..] construct */
                           while( *p != ']' ) {
                                     /* check for literal escape */
                                     if( *p == '\\' ) {
                                           p++;

                                 /* if end of pattern here then bad pattern */
                                           if ( !*p++ ) {
                                                *error_type = PATTERN_ESC;
                                                return FALSE;
                                           }
                                     }
                                     else
                                           p++;

                              /* if end of pattern here then bad pattern */
                                     if ( !*p ) {
                                           *error_type = PATTERN_CLOSE;
														 return FALSE;
                                     }
                                     /* if this a range */
                                     if( *p == '-' ) {
                                           /* we must have an end of range */
                                           if ( !*++p || *p == ']' ) {
                                                  *error_type = PATTERN_RANGE;
                                                  return FALSE;
                                           }
                                           else {
                                           /* check for literal escape */
                                                  if( *p == '\\' )
                                                          p++;
                               /* if end of pattern here then bad pattern */
                                                         if ( !*p++ ) {
                                                    *error_type = PATTERN_ESC;
                                                               return FALSE;
                                                         }
                                                  }
												 }
                            }
                break;

            /* all other characters are valid pattern elements */
            case '*':
            case '?':
            default:
                   p++;           /* "normal" character */
                   break;
         }
     }
     return TRUE;
}

int matche ( register char *p, register char *t )
{
    register char range_start, range_end;  /* start and end in range */

	 BOOLEAN invert;             /* is this [..] or [!..] */
    BOOLEAN member_match;       /* have I matched the [..] construct? */
    BOOLEAN loop;               /* should I terminate? */

    for ( ; *p; p++, t++ ) {

        /* if this is the end of the text then this is the end of the match */
        if (!*t) {
            return ( *p == '*' && *++p == '\0' ) ? MATCH_VALID : MATCH_ABORT;
        }
        /* determine and react to pattern type */
        switch ( *p ) {

            /* single any character match */
            case '?':
                break;

            /* multiple any character match */
            case '*':
					 return matche_after_star (p, t);

            /* [..] construct, single member/exclusion character match */
            case '[': {

                /* move to beginning of range */
                p++;

                /* check if this is a member match or exclusion match */
                invert = FALSE;
                if ( *p == '!' || *p == '^') {
                    invert = TRUE;
                    p++;
                }

                /* if closing bracket here or at range start then we have a
                   malformed pattern */
                if ( *p == ']' ) {
                    return MATCH_PATTERN;
													  }

                member_match = FALSE;
                loop = TRUE;

                while ( loop ) {

                    /* if end of construct then loop is done */
                    if (*p == ']') {
                        loop = FALSE;
                        continue;
                    }

                    /* matching a '!', '^', '-', '\' or a ']' */
                    if ( *p == '\\' ) {
                        range_start = range_end = *++p;
                    }
                    else {
                        range_start = range_end = *p;
																  }

                    /* if end of pattern then bad pattern (Missing ']') */
                    if (!*p)
                        return MATCH_PATTERN;

                    /* check for range bar */
                    if (*++p == '-') {

                    /* get the range end */
                         range_end = *++p;

                        /* if end of pattern or construct then bad pattern */
                         if (range_end == '\0' || range_end == ']')
                            return MATCH_PATTERN;

                        /* special character range end */
                         if (range_end == '\\') {
                            range_end = *++p;

                            /* if end of text then we have a bad pattern */
                            if (!range_end)
                                return MATCH_PATTERN;
                         }

                        /* move just beyond this range */
                         p++;
                    }

                    /* if the text character is in range then match found.
                       make sure the range letters have the proper
                       relationship to one another before comparison */
                    if ( range_start < range_end  ) {
                         if (*t >= range_start && *t <= range_end) {
                            member_match = TRUE;
                            loop = FALSE;
                         }
                    }
																  else {
                         if (*t >= range_end && *t <= range_start) {
                            member_match = TRUE;
                            loop = FALSE;
                         }
                    }
                }

                /* if there was a match in an exclusion set then no match */
                /* if there was no match in a member set then no match */
                if ((invert && member_match) ||
                   !(invert || member_match))
                    return MATCH_RANGE;

                /* if this is not an exclusion then skip the rest of the [...]
                   construct that already matched. */
                if (member_match) {
                    while (*p != ']') {

						 /* bad pattern (Missing ']') */
                        if (!*p)
                            return MATCH_PATTERN;

                        /* skip exact match */
                        if (*p == '\\') {
                            p++;

                            /* if end of text then we have a bad pattern */
                            if (!*p)
                                 return MATCH_PATTERN;
                        }

                        /* move to next pattern char */
                        p++;
                     }
                  }

                break;
										  }

                                /* must match this character exactly */
            default:
                if (*p != *t)
                    return MATCH_LITERAL;
        }
    }

    /* if end of text not reached then the pattern fails */
	 if ( *t )
		  return MATCH_END;
	 else
		  return MATCH_VALID;
}

/* recursively call matche() with final segment of PATTERN and of TEXT. */
int matche_after_star (register char *p, register char *t)
{
	 register int match = 0;
	 register nextp;

	 /* pass over existing ? and * in pattern */
	 while ( *p == '?' || *p == '*' ) {

		  /* take one char for each ? and + */
		  if ( *p == '?' ) {

				/* if end of text then no match */
				if ( !*t++ ) {
					 return MATCH_ABORT;
				}
		  }

		  /* move to next char in pattern */
		  p++;
	 }

	 /* if end of pattern we have matched regardless of text left */
	 if ( !*p ) {
						return MATCH_VALID;
	 }

	 /* get the next character to match which must be a literal or '[' */
	 nextp = *p;

	 /* Continue until we run out of text or definite result seen */
    do {

        /* a precondition for matching is that the next character
           in the pattern match the next character in the text or that
           the next pattern char is the beginning of a range.  Increment
           text pointer as we go here */
        if ( nextp == *t || nextp == '[' ) {
            match = matche(p, t);
        }

		  /* if the end of text is reached then no match */
		  if ( !*t++ ) match = MATCH_ABORT;

	 } while ( match != MATCH_VALID &&
				  match != MATCH_ABORT &&
				  match != MATCH_PATTERN);

	 /* return result */
	 return match;
}

/* match() is a shell to matche() to return only BOOLEAN values. */
BOOLEAN match( char *p, char *t )
{
         int error_type;
         error_type = matche(p,t);
         return (error_type == MATCH_VALID ) ? TRUE : FALSE;
}

void buf_upper(char *s, unsigned n) /* string and length */
{             /* upper-casing with reference to language character set */
	 static void far (*case_map)(void);
    static int init_flag = 0;
    struct COUNTRY cp;
    char *t;
    unsigned i;

    if (!init_flag)
    {
        init_flag = -1;
        if (_osmajor >= 3 && country(0, &cp) != NULL)
        {
            init_flag = 1;
            case_map =
                MK_FP((unsigned) ((unsigned long) cp.co_case >> 16), (unsigned) cp.co_case);
        }
    }

    /* Modify the following code with extreme care */

	 if (init_flag > 0)
    {
        for (i = n, t = s; i > 0; i--, t++)
        {
            _AL = *t;
            if (_AL >= 'a' && _AL <= 'z')
                *t = _toupper(_AL);
            else if (_AL >= 0x80)
            {
                (*case_map)();
                *t = _AL;
            }
        }
    }
    else
    {
        for (i = n, t = s; i > 0; i--, t++)
        {
            _AL = *t;
				if (_AL >= 'a' && _AL <= 'z')
                *t = _toupper(_AL);
        }
    }
}

