#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys\stat.h>

#define MAXPAT	256

char curDir[MAXPAT] ;
char tDrv[3], tDir[MAXPAT], tName[9], tExt[5] ;
char *loc ;

int halt = 0, recur = 0 ;

struct fcb tag ;
struct REGPACK regs ;

void error( char *fname, char *cau ) {

	fprintf( stderr, "%s error : %s ", cau, fname ) ;
	switch ( errno ) {
		case ENOENT :
			fputs( "path or file not found.\n", stderr ) ;
			break ;
		case EACCES :
			fputs( "permission denied.\n", stderr ) ;
			break ;
		default :
			fprintf( stderr, "error no - %d\n", errno ) ;
	}
}

void usage( void ) {

	fprintf( stderr, "Usage: XD [Dir]\n\te.g. XD F:\\TEMP\\ or XD TEMP\\\n" ) ;
	exit( - 1 ) ;
}

attachTarget( char *loc ) {

	int c ;
	char d ;

	c = fnsplit( loc, tDrv, tDir, tName, tExt ) ;

	if ( c & DRIVE ) {
		d = toupper( tDrv[0] ) - 'A' ;
		setdisk( d ) ;
		if ( getdisk() != d )
			return 0 ;
	}
	if ( c & DIRECTORY )
		if ( chdir( tDir ) ) {
			tDir[strlen( tDir ) - 1] = 0 ;
			if ( chdir( tDir ) )
				return 0 ;
		}
	if ( c & FILENAME )
		usage() ;

	regs.r_ds = FP_SEG( &tag ) ;
	regs.r_ax = 0x1300 ;
	regs.r_dx = FP_OFF( &tag ) ;

	return 1 ;
}

int d ;

void recusiveSearch( void ) {

	struct ffblk dir ;
	int c ;

	for ( c = findfirst( "*.*", &dir, FA_DIREC | FA_ARCH ) ; !c ;
		c = findnext( &dir ) ) {
		d = dir.ff_attrib ;
		loc = dir.ff_name ;
		if ( d & FA_DIREC ) {
			if ( *loc != '.' ) {
				chdir( loc ) ;
				recusiveSearch() ;
				loc = dir.ff_name ;
				if ( rmdir( loc ) )
					error( loc, "RMDIR" ) ;
			}
		} else if ( d & FA_RDONLY || d & FA_HIDDEN || d & FA_SYSTEM )
			if ( chmod( loc, S_IREAD | S_IWRITE ) )
				error( loc, "CHMOD" ) ;

	}

	parsfnm( "*.*", &tag, 1 ) ;
	intr( 0x21, &regs ) ;
	chdir( ".." ) ;
}

void main( int argc, char *argv[] ) {

	if ( argc != 2 )
		usage() ;

	getcwd( curDir, MAXPAT ) ;

	if ( attachTarget( argv[1] ) )
		recusiveSearch() ;
	argv[1][strlen(argv[1])-1] = 0 ;
	if ( rmdir( argv[1] ) )
		error( argv[1], "RMDIR" ) ;

	setdisk( curDir[0] - 'A' ) ;
	chdir( curDir ) ;
}