------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   A D A . I N T E R R U P T S . N A M E S                --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.1 $                             --
--                                                                          --
--   Copyright (C) 1991,1992,1993,1994,1995,1996 Florida State University   --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------


with System;

--  This implementation-define package spec contains interrups
--  supported by DJGPP v2

--  Usable Interrupts for Ada.Interrupts and Interrupts Entries are
--  marked with "--  ***" in the following constant definition.

package Ada.Interrupts.Names is

   SIGABRT     : constant Interrupt_ID := 288;
   SIGFPE      : constant Interrupt_ID := 289;
   SIGILL      : constant Interrupt_ID := 290;
   SIGSEGV     : constant Interrupt_ID := 291;
   SIGTERM     : constant Interrupt_ID := 292;
   SIGALRM     : constant Interrupt_ID := 293;
   SIGHUP      : constant Interrupt_ID := 294;
   SIGINT      : constant Interrupt_ID := 295;
   SIGKILL     : constant Interrupt_ID := 296;
   SIGPIPE     : constant Interrupt_ID := 297;
   SIGQUIT     : constant Interrupt_ID := 298;
   SIGUSR1     : constant Interrupt_ID := 299;
   SIGUSR2     : constant Interrupt_ID := 300;
   SIGNOFP     : constant Interrupt_ID := 301;
   SIGTRAP     : constant Interrupt_ID := 302;
   SIGTIMR     : constant Interrupt_ID := 303;
   SIGPROF     : constant Interrupt_ID := 304;

end Ada.Interrupts.Names;
