PRAGMA LIST(On);

-- Source Ex4.Ada
-- By Arthur V. Lopes, 7/12/94

-- This program implements a solution for the problem exibited
-- by the program Concurrent_Programming_2.

-- Task entries are used to achieve syncronization between the
-- tasks. The main task will make use of a start bottom to tell
-- its children tasks that they can start displaing on the screen.
-- Each children task will wait for its bottom to be pressed.
-- After this is performed the main task will use a stop bottom
-- to know that the children tasks are done. This is one way
-- of achiving the goal of clearing the screen, running the two
-- declared tasks concurrently, and then placing the cursor
-- at the third line. 

WITH ADa.Text_IO, VT100; USE Ada.Text_IO;
PROCEDURE Concurrent_Programming_3 IS

	PROTECTED Screen IS
		PROCEDURE ClearScreen;
		PROCEDURE Display_At(Column, Row : Integer; C : Character);
	END Screen;

	PROTECTED BODY Screen IS

		PROCEDURE ClearScreen IS
		BEGIN
			VT100.ClearScreen;
		END ClearScreen;

		PROCEDURE Display_At(Column, Row : Integer; C : Character) IS

		BEGIN
			VT100.MoveCursor(Column,Row);
			Put(C);
		END Display_At;  
	END Screen;

	SUBTYPE Interval IS INTEGER RANGE 1 .. 10;

	TASK Display_A IS
		ENTRY Start;
		ENTRY Stop;
	END Display_A;

	TASK Display_B IS
		ENTRY Start;
		ENTRY Stop;
	END Display_B;

	TASK BODY Display_A IS -- This is the body part of Display_A
	BEGIN
		ACCEPT Start;
		FOR I IN Interval LOOP
			Display_At(I,1,'A');
			DELAY 0.01;
		END LOOP;
		ACCEPT Stop;
	END Display_A;

	TASK BODY Display_B IS
	BEGIN
		ACCEPT Start;
		FOR I IN Interval LOOP
			Display_At(I,2,'B');
			DELAY 0.01;
		END LOOP;
		ACCEPT Stop;
	END Display_B;

BEGIN
	ClearScreen;
	Display_A.Start;
	Display_B.Start;
	Display_A.Stop;
	Display_B.Stop;
	New_Line;
END Concurrent_Programming_3;