/***
*  fastdd.c
* 
*  replace "dd if=argv[1] skip=argv[2]"
*  use "lseek" for skip to speed up
* 
*  for mulinux
*
*  Alain Spineux 9/98
*  Added progress indicator, M. Andreoli
***/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <signal.h>

#define BUFSIZE 1024 


static void Abort(int sig)
{
fprintf(stderr,"Signal %d\n",sig);
exit(1);
}

int main(int argc, char *argv[])

{
  struct stat stat_info;

  char buf[BUFSIZE];
  int fd=0;
  int n;
  int count=0;
  int size;
  float done;

  (void) signal(SIGINT,Abort);

  fd=open(argv[1], O_RDONLY);
 
/* check size */

fstat(fd,&stat_info);
size=stat_info.st_size;

if (size == 0 ) {
	if ( strcmp(argv[1],"/dev/fd0") == 0 ) size=1440*1024;
	if ( strcmp(argv[1],"/dev/fd0H1440") == 0 ) size=1440*1024;
	if ( strcmp(argv[1],"/dev/fd0H1722") == 0 ) size=1722*1024;
}

size-=1024*atoi(argv[2]);

  lseek(fd, 1024*atoi(argv[2]), SEEK_SET); 

  while ( 1 ) {
        n=read(fd, buf, BUFSIZE);
        if (n == 0) break;          /* EOF.  */
        if (n < 0) return -2;
        write(1, buf, n);
	count+=n;

	fprintf(stderr, "%3d%%\b\b\b\b",div(100*count,size).quot);
  }
	fprintf(stderr, "Done\n");
  close(fd); 
  return 0;
}

