/* 
expr.c: reduced for muLinux 
*/

/*
 * Copyright (C) 1997
 *      Michele Andreoli, Pontedera (PISA) Italy.  All rights reserved.
 */

#include <stdio.h>
#include <stdlib.h>

#define USAGE "expr X [-|+|/|*|%] Y, or: expr [o|x] X\n"

main(int argc, char** argv)
{
long x,y;
char *op=NULL;
div_t q;

/* Parsing */

switch ( argc )
{
case 3:	{ 
	op=argv[1];
	x=strtol( (const char*)(argv[2]),0,10);
	break;
	}
case 4:
	{
	x=strtol( (const char*)(argv[1]),0,10);
	op=argv[2];
	y=strtol( (const char*)(argv[3]),0,10);
        break;
        }
default: {fprintf(stderr,USAGE) ;exit(1);}
}


/* operate */

switch( op[0] )
{
/* aritmetic */
case '+':	{printf("%ld\n",x+y); break;}
case '-':	{printf("%ld\n",x-y); break;}
case '*':	{printf("%ld\n",x*y); break;}
case '%':	{printf("%ld\n",x%y); break;}
case '/':	
		{
		printf("%ld\n",(div(x,y)).quot); 
		break;}
/* binary conversion */
case 'o':	{printf("\\0%o\n",x); break;}
case 'x':	{printf("0x%x\n",x); break;}

default:	{fprintf(stderr,USAGE) ;exit(1);}	

}


}
