#!/bin/sh
##############################################################################
# Commandline wiki engine for /bin/sh - 2005 Sebastian Misch
# Meet the WikiSH project at http://wikish.do.homeunix.org
#
# NOTE: This file is autogenerated. Do not edit.
#
# $Id: wiki.sh,v 1.8 2005/10/11 11:57:02 smisch Exp $
#
##############################################################################
## Defaults

AWK=awk
HEADER=/dev/null
FOOTER=/dev/null

if [ "x$2" = "x" ] ; then
  if [ -f ~/.wiki/wiki.conf ] ; then
    . ~/.wiki/wiki.conf
  else
    echo No local configuration found in ~/.wiki/ - using defaults.
  fi
else 
  echo Using default configuration.
fi

meta() {
  $AWK -v pg="$FILE"\
       -v tt="$TITLE"\
       -v wd="$WORDS" "\
       gsub(/<!--Wiki-->/, bu sn)\
       gsub(/<!--Page-->/, pg)\
       gsub(/<!--Filename-->/, pg \".html\")\
       gsub(/<!--Title-->/, tt)\
       gsub(/<!--Words-->/, wd)\
       {print}"
}

##############################################################################
## Internal vars

FILE=$1

if [ "x$FILE" = "x" ] ; then 
  echo Usage: $0 [wiki]
  exit 0
fi

if [ -f $FILE ] ; then 
WIKI=`echo $FILE|sed 's/\..*$//g'` 
TITLE=`echo $WIKI|sed 's/\([a-z0-9]\)\([A-Z]\)/\1 \2/g'` 
WORDS=`cat $FILE|$AWK '{gsub(/[^a-zA-Z]/,"\n");print}'|\
       $AWK 'length>6{print tolower($0)}'|sort|uniq -c|sort -r|\
       head -10|$AWK '{printf("%s,",$2)}'`
TOC=`$AWK 'BEGIN{print ""}\
     $0!~/^--? /{next}\
     /^- /{s=0; c++}/^-- /{s++;}\
     {$1="";gsub(/^ /,"");printf\
     ("<SPAN STYLE=float:left;min-width:50px;>%s%s.%s%s</SPAN>"\
      "<A CLASS=\"wikishtocitem\" HREF=#%s.%s>%s</A><BR>\n",\
     (s==0?"<B>":""),c,(s==0?"":s),(s==0?"</B>":""),\
     c,s,(s==0?"<B>":"")$0(s==0?"</B>":""))}' $FILE`
cat $HEADER|meta>$WIKI.html
cat $0 | $AWK 'n>0{print}/^___PARSER/{n++}'|\
  $AWK -f - -v sh=1 -v toc="$TOC" -v datadir="." baseurl="" wiki="$WIKI" \
   $FILE >> $WIKI.html
cat $FOOTER|meta>>$WIKI.html
else 
  echo $FILE not found
fi

exit 0

___PARSER
