#!/bin/sh

##############################################################################
## Shell test

SH=/bin/sh

FOO=`echo "${#*}" 2> /dev/null`

if [ "x$FOO" = "x" ] ; then
  SH=`which bash`
  if [ "x$SH" = "x" ] ; then
    echo /bin/sh seems to be a kornshell, bash not found.
    echo Could not find a compatible shell.
    exit 1
  fi
fi

echo "Using shell: $SH"


##############################################################################
## RCS test

RCS=true
CI=`which ci`
CO=`which co`
if [ "x$CI" = "x" ] ; then
  echo "RCS/ci not found - using a fake."
  RCS=false
fi
if [ "x$CO" = "x" ] ; then
  echo "RCS/co not found - using a fake."
  RCS=false
fi

test "x$RCS" = "xfalse" && \
  echo "Disabling RCS usage."


##############################################################################
## Webserver
USER=`ps -ef | grep httpd | grep -v grep | head -1 | sed 's/^ *//g' | cut -f1 -d ' '`
if [ "x$USER" = "x" ] ; then
  USER=nobody
fi
HTDOCS=`ls -l /usr/local/httpd/htdocs 2> /dev/null`
CGIBIN=`ls -l /usr/local/httpd/cgi-bin 2> /dev/null`

echo -n "What is the user id your webserver is running [$USER]? " 
read foo
if [ "x$foo" = "x" ] ; then
  echo Keeping default value: $USER
else
  USER=$foo
fi

echo -n "What is path of your html documents (htdocs) [$HTDOCS]? " 
read foo
if [ "x$foo" = "x" ] ; then
  echo Keeping default value: $HTDOCS
else
  HTDOCS=$foo
fi

echo -n "What is path of your CGI script directory (cgi-bin) [$CGIBIN]? " 
read foo
if [ "x$foo" = "x" ] ; then
  echo Keeping default value: $CGIBIN
else
  CGIBIN=$foo
fi

BASEURL='http://localhost'
echo -n "What is the url to your website [$BASEURL]? " 
read foo
if [ "x$foo" = "x" ] ; then
  echo Keeping default value: $BASEURL
else
  BASEURL=$foo
fi

CGIALIAS='/cgi-bin'
echo -n "What is the CGI alias of your website [$CGIALIAS]? " 
read foo
if [ "x$foo" = "x" ] ; then
  echo Keeping default value: $CGIALIAS
else
  CGIALIAS=$foo
fi

SCRIPTNAME="$BASEURL$CGIALIAS/wikish.cgi"
BASEURL="$BASEURL/wikish"

##############################################################################
## AWK

for A in "awk" "gawk" "nawk" "mawk" ; do
  A=`which $A`
  test "x$A" = "x" || AWK=$A 
done


test -d install || mkdir install

##############################################################################
## Wiki conf
echo Creating your configuration...
( \
  echo "BASEURL=$BASEURL" ; \
  echo "DATADIR=$HTDOCS/wikish" ; \
  echo "SCRIPTNAME=$SCRIPTNAME" ; \
  echo "STYLESHEET=$BASEURL/wiki.css" ; \
  echo "AWK=$AWK" ; \
  echo "CI=$CI" ; \
  echo "CO=$CO" \
  ) > install/wiki.conf

##############################################################################
## Header / Footer
echo Generating standard templates...
echo '
<HTML>
  <HEAD>
    <TITLE><!--Title--></TITLE>
    <LINK REL="stylesheet" HREF="wiki.css">
    <META HTTP-EQUIV="content-type" CONTENT="text/html; charset=ISO-8859-1">
    <META NAME="Description" VALUE="<!--Title-->">
    <META NAME="Copyright" VALUE="Edit me!">
    <META NAME="Author" VALUE="Edit me!">
    <META NAME="Generator" VALUE="WikiSH <!--WikishVersion-->">
    <META NAME="ROBOTS" CONTENT="index,follow">
    <META NAME="Language" VALUE="EN">
    <META NAME="Content" VALUE="<!--Title-->,<!--Words-->">
    <META NAME="Keywords" VALUE="<!--Title-->,<!--Words-->">
    <META NAME="revisit-after" CONTENT="14 days">
  </HEAD>
  <BODY>
    <DIV CLASS=left>
    <DIV CLASS=wikishheader>
    <A NAME=top></A>
    <H1 CLASS=wikishh1><!--Title--></H1>
    <BR>
    <BR>
    
    <SPAN CLASS=wikishmenu>
      <B CLASS="wikishrcs"><!--Page--> <!--Revision--></B>&nbsp;&nbsp;&nbsp;  
      <A CLASS="wikishmenuitem" HREF="index.html">Home</A> |
      <A CLASS="wikishmenuitem" HREF="#bottom">Bottom</A> |
      <A CLASS="wikishmenuitem" HREF=<!--Wiki-->?edit&<!--Page-->>Edit</A> 
    </SPAN>  
    <BR>
    <HR>
    </DIV>
    <DIV CLASS=wikishpage>
    <P>
' > install/header

echo '
    </DIV>
    <DIV CLASS=wikishfooter>
      <HR>
      <A NAME=bottom></A>
      <SPAN CLASS=wikishmenu>
        <A CLASS="wikishmenuitem" TARGET="_top" HREF="index.html">Home</A>
        <A CLASS="wikishmenuitem" HREF="#top">Top</A>
        <A CLASS="wikishmenuitem" TARGET="_top" 
           HREF="<!--Wiki-->?edit&<!--Page-->">Edit</A>
      </SPAN>  
    <TT CLASS="wikishrcs"><!--Id--></TT>  
    </DIV>
    <DIV CLASS=wikishad>
      <SPAN CLASS=wikishgrayedout>
      Managed with the 
      <A CLASS=wikishgrayedout TARGET="_new"
      HREF="http://wikish.do.homeunix.org">WikiSH</A> 
      written in /bin/sh<BR>
      2006, by <A CLASS=wikishgrayedout TARGET="_new" HREF="http://www.sebastian-misch.de">Sebastian Misch</A>
      </SPAN>
    </DIV>
    </DIV>
  </BODY>
</HTML>
' > install/footer


##############################################################################
## wiki
echo Patching the wiki to meet your setup...
cp src/wiki install/wikish.cgi
# Patch shell
perl -pi -e 's,#!/bin/sh,#!'$SH',g' install/wikish.cgi
# Patch rcs
test "x$RCS" = "xfalse" && \
  perl -pi -e 's,^.* ci .*$, cp \$FILE \$DATADIR/\$RCS/\$FILE\,v ,g' install/wikish.cgi
test "x$RCS" = "xfalse" && \
  perl -pi -e 's,^.* co .*$, cp \$DATADIR/\$RCS/\$FILE\,v \$FILE ,g' install/wikish.cgi


##############################################################################
## wiki.css
cp src/wiki.css install/wiki.css
cp src/px/*.gif install/

##############################################################################
## Install

echo ''
echo -n 'Ready to install. Press <enter> to succeed, <CTRL-C> to abort.'
read

set -x
echo Creating directories...
test -d $HTDOCS || mkdir -p $HTDOCS
test -d $HTDOCS/wikish || mkdir -p $HTDOCS/wikish
test -d $HTDOCS/wikish/RCS || mkdir -p $HTDOCS/wikish/RCS
test -d $HTDOCS/wikish/px || mkdir -p $HTDOCS/wikish/px
test -d $CGIBIN || mkdir -p $CGIBIN

echo Changing ownerships and permissions...
chmod 755 $HTDOCS
chmod 755 $HTDOCS/wikish
chown $USER $HTDOCS/wikish
chmod 755 $HTDOCS/wikish/RCS
chown $USER $HTDOCS/wikish/RCS
chmod 755 $HTDOCS/wikish/px
chown $USER $HTDOCS/wikish/px
chmod 755 $CGIBIN

echo Copying files...
cp install/wikish.cgi \
     install/wiki.conf \
     install/header \
     install/footer \
     $CGIBIN/
cp install/wiki.css $HTDOCS/wikish/
cp install/*.gif $HTDOCS/wikish/px/

echo Changing ownerships and permissions...
chmod 755 $CGIBIN/wikish.cgi
chown $USER $CGIBIN/wikish.cgi
chmod 644 $CGIBIN/wiki.conf $CGIBIN/header $CGIBIN/footer
chown $USER $CGIBIN/wiki.conf $CGIBIN/header $CGIBIN/footer
chmod 644 $HTDOCS/wikish/wiki.css
chown $USER $HTDOCS/wikish/wiki.css
chmod 644 $HTDOCS/wikish/px/*.gif
chown $USER $HTDOCS/wikish/px/*.gif

CR=`echo -e "\n"`
PWD=`pwd`
cd $CGIBIN
export QUERY_STRING="add&index"
echo -e "

r-$BASEURL/px/wikish-small.gif

- The Wiki''''''SH on your server - You made it!

Congratulations, the Wiki''''''SH engine is now installed 
on your server.

-- Your Wiki Configuration

| Configuration | Value    |
| URL           | $BASEURL |
| AWK           | $AWK     |
| Revisioning   | $RCS     |


-- Start Wikiing
Click ''edit'' on the upper right and start editing 
your new Wiki.

Click here to create your FirstWikiPage.

-- Further Resources
Visit http://wikish.do.homeunix.org for further information
and latest updates of the Wiki''''''SH.


" > /tmp/msg
export CONTENT_LENGTH=`cat /tmp/msg|wc -c|sed 's/ //g'`

test UID = 0 && (cat /tmp/msg | su $USER ./wikish.cgi) \
	|| (cat /tmp/msg | ./wikish.cgi)
rm /tmp/msg
cd $PWD

echo ""
echo ""
echo Now point your browser to $BASEURL and see if it went through.





