/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * bbs.h - part of the yabbs bulletin board package by alex wetmore
 *         see bbs.c for information on the system and copying instructions.
 *
 * This file has sysop changeable constants (for the most part).
 */

#ifndef __DATE__                                /* make up a date if there  */
#define __DATE__ "braindead system!"            /*  isn't one               */
#endif

/* user options (should each use a different bit of a 32-bit integer)       */
#define O_XPERT 1                               /* expert option number     */

/* fseek and lseek definations (for the machines that don't have them)      */
#ifndef SEEK_SET
#define SEEK_SET 0                              /* mach is braindead        */
#define SEEK_CUR 1                              /* it should have these in  */
#define SEEK_END 2                              /* stdio.h                  */
#endif

/* possible codes for passing to killconnection()                           */
#define K_USER 0                                /* user exited              */
#define K_TIME 1                                /* user timed out           */
#define K_FERR 2                                /* file error               */
#define K_SILENT 3                              /* no silly strings         */
#define K_HUP 4                                 /* console hangup           */
#define K_FERR_NW 5                             /* file error, don't update */
                                                /* users.dat                */
#define K_NETWORK 6                             /* network error            */

/* message return codes                                                     */
#define M_OK 0                                  /* message is okay          */
#define M_OOB -1                                /* message out of bounds    */
#define M_PRIVATE -2                            /* message is private       */
#define M_DELETED -3                            /* message is deleted       */
#define M_ERR -4                                /* other error              */

/* files to get from the server                                             */
#define F_WELCOME "welcome.txt"                 /* welcome file             */
#define F_LASTU "lastuser.txt"                  /* last user file           */
#define F_NEWS "news.txt"                       /* news file                */
#define F_NEWUSER "newuser.txt"                 /* dumped to new users      */

/* paths for temp files                                                     */
#define F_ZTMP "/tmp/yabbs-z."                  /* temporary files for zcat */
#define F_GTMP "/tmp/yabbs-g."                  /* temporary files for zcat */
#define F_EDTMP "/tmp/yabbs-e."                 /* path to editor temp file */
/* if users have terminals that are in the terminal database than the       */
/* client will use one of the below.  Users can set their EDITOR variable   */
/* to change the editor personally, or PAGER to change their pager.         */
/* If they are on a dumb terminal the internal editor/pager is used, which  */
/* is fairly featureless and dumb                                           */
#define F_EXTERNED "/usr/local/bin/joe"         /* default editor           */
#define F_EXTERNPG "/usr/local/bin/less"        /* external pager           */

/* strings                                                                  */
#define S_NULLBASE "null base"                  /* name for un-used bases   */

/* macros                                                                   */
#define nullbase(baseid) (strcmp(base[baseid].title, S_NULLBASE) == 0)
