#define __MBD
#define NOTERM  
#include <dirent.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>                        
#include <time.h>                           
#include <sys/param.h>                      
#include <sys/socket.h>                     
#include <netinet/in.h>                     
#include <netdb.h>                          
#include <stdarg.h>                         

#include <fcntl.h>
#include <sys/stat.h>
#include <dirent.h>
#include <strings.h>
#include <string.h>
#include <ctype.h>
#include <arpa/inet.h>
                     
#include "../defs.h"
#include "../s_global.h"


#include <sys/types.h>   

#ifdef _LINUX
#include <linux/time.h>
#endif



#undef EXTERN
#define ALLOCATE
#define NNTP_ABLE

#include "uqwk.h"
char msg[1024*8],NG[2*STRING],INHALT[2*STRING];
FILE *nntp_rd_fp,*nntp_wr_fp;
char nntp_line[1024*8];
int article,article_von,article_bis,auth,posting,groups;

#undef _ART_DEBUG
#undef VIEW


#include <stdio.h>
#include <sys/types.h>

#include <pwd.h>
#include <string.h>

#ifndef RSORT
#define RSORT "sort -r"
#endif



void InitNews()
{
  NntpConnect();
  NNTPReadActive();
  LoadTree();
  MakeHeapNewsRc();
  UpdateRcTree(0); UpdateRcTree(1);
  printf("\ndone.\nprocessing news....");fflush(stdout);
}



void NntpConnect()
{
   time((time_t *) &NNTP_TIMEOUT);
   GET_NNTP_CHECK_ON=1;
   printf("\nnntp: connecting to %s ..... ", NNTP_HOST);
   fflush(stdout);
   nntp_connect_port(NNTP_HOST,NNTP_DEFAULT_DUMMY);
   time((time_t *) &NNTP_TIMEOUT); GET_NNTP_CHECK_ON=0;
}



void nntp_connect_port(char *server, int _port) 
{

    NNTP_ON=1;
    if (server_init (server, (char *) NNTP_PORT, _port)!=-1)   /*!PORT-BUG!*/
    {
     /* server ok .. */
    } else
    {
        printf("\n%c%s\n",BELL,NNTP1);
        NNTP_ON=0;
        fflush(stdout);
        sleep(2);
        return;
    }

    NNTPSetStat();
}





void NNTPClean()
{
do
{
 get_server(&msg,NNTP_STRLEN);
} while (msg[0]!=0);
}


void NNTPSetStat()
{
int _bef; 


get_server(msg,NNTP_STRLEN);

Log(190,"nntp-read",msg); /* read */

if (strpos("INN",msg)!=0) /* check for INN */
{
  Log(190,"nntp-put:","mode reader");
  put_server("mode reader");
  get_server(msg,NNTP_STRLEN);
  Log(190,"nntp-read",msg); /* read stats*/
}
auth=posting=0;

/* setting*/
_bef=atoi((char *) cut_bef(msg));

if (_bef==OK_CANPOST)
{
 posting=1;
}
else
if (_bef==OK_NOPOST)
{
  posting=0;
}

if (strpos("auth",msg)!=0)
  auth=1;
  
  
/* output */  
if (posting) Log(190,"set","nntp: posting ok"); /* posting */
  else Log(190,"set","nntp: no posting");
  
  
}







char *NntpGroup(gruppe)
unsigned char *gruppe;
{
int nstat;
static char s[NNTP_STRLEN],k[NNTP_STRLEN];

        sprintf(k,"GROUP %s",gruppe);
        put_server(k);
	get_server(&s,NNTP_STRLEN);
	
	sprintf(k,"nntp: \"GROUP %s\" ->",gruppe); 
#ifdef NNTP_LOG	
	Log(190,k,s); 
#endif 	
	nstat=atoi((char *) cut_bef(cut_leer(s))); /* nntp-status */
	
	if (nstat==OK_GROUP) {	/* Group selected */
	  strcpy(k,(char *) cut_arg(cut_leer(s)));
	  article=atoi((char *) cut_bef(cut_leer(k))); /* Artikel-Anzahl */
	  strcpy(k,(char *) cut_arg(cut_leer(k)));
	  article_von=atoi((char *) cut_bef(cut_leer(k))); /* von Artikel-Nummer */
	  strcpy(k,(char *) cut_arg(cut_leer(k)));
	  article_bis=atoi((char *) cut_bef(cut_leer(k))); /* bis Artikel-Nummer */
	  sprintf(k,"nntp: article:%d, v:%d, t:%d ->",article,
 	    article_von,article_bis); 
#ifdef NNTP_LOG 	    
 	    Log(190,k,s); 
#endif 	    
          strcpy(NG,gruppe); 	    

	  return(NULL);
	}
	else {
	 strcpy(k,(char *) cut_arg(cut_leer(s)));
	 switch (nstat)
	 {
	  case ERR_NOGROUP:
	   	sprintf(k,"%s (%s)",GetText("NNTP1"),gruppe);
	        break;
	  case ERR_NOAUTH:/* authorization required for command */
	   	sprintf(k,"%s (%s)",GetText("NNTP2"),gruppe);
	        break;
	 default:
	  	break;
	 }
	 return((char * ) &k);
	}

}





int NntpNext() /* next. Article */
{
int nstat;
static char s[NNTP_STRLEN],k[NNTP_STRLEN];

        sprintf(k,"NEXT\n");
        put_server(k);
        get_server(s,NNTP_STRLEN);
	
	if (atoi(s)==OK_NOTEXT) {/* status ok: No text sent -- stat, next, last */	
	  strcpy(k,(char *) cut_arg(s));
#ifdef NNTP_LOG	  
	  Log(190,"nntp-next:",k);
#endif	  
	  return(atoi(k));
	}
	else {
#ifdef NNTP_LOG	
	 Log(190,"nntp-next:",s);
#endif	 
	 return(0);
	}
}


int NntpPrev() /* prev. Article */
{
int nstat;
static char s[NNTP_STRLEN],k[NNTP_STRLEN];

        sprintf(k,"LAST\n");
        put_server(k);
        get_server(s,NNTP_STRLEN);
	
	if (atoi(s)==OK_NOTEXT) {	/*ok:  No text sent -- stat, next, last */	
	  strcpy(k,(char *) cut_arg(s));
#ifdef NNTP_LOG	  
	  Log(190,"nntp-next:",k);
#endif	  
	  return(atoi(k));
	}
	else {
#ifdef NNTP_LOG	
	 Log(190,"nntp-next:",s);
#endif	 
	 return(0);
	}
}






/* schreibt Artikel-Header in TMP */
int NNTPHead(art,lst_fd)
int art;
FILE *lst_fd;
{
int nstat,_art;
static char s[NNTP_STRLEN];
char k[NNTP_STRLEN],tt[NNTP_STRLEN];
unsigned char date[NNTP_STRLEN],from[NNTP_STRLEN],subject[NNTP_STRLEN],lines[NNTP_STRLEN];

        sprintf(k,"HEAD\n");
        put_server(k);
	get_server(s,NNTP_STRLEN);
#ifdef NNTP_DEBUG		
        sprintf(tt,"\nnntp: \"HEAD\" -> %s\n",s);
	/*StrLog(tt);  */
#endif	
	nstat=atoi((char *) cut_bef(cut_leer(s))); /* nntp-status */
#ifdef NNTP_DEBUG		
	/*StrLog(s);*/
#endif	
	strcpy(s,(char *) cut_arg(cut_leer(s))); 
#ifdef NNTP_DEBUG
        /*StrLog("...nach#5 ");*/
#endif	
	if (nstat==OK_HEAD) 	/* ok head follow */
	{
	  _art=atoi((char *) cut_bef(cut_leer(s))); /* artikel-Nummer */
	  lines[0]=subject[0]=from[0]=date[0]=0;
#ifdef NNTP_DEBUG
        /*StrLog("...nach#7 ");*/
#endif	  
	  while (get_server((char *) s,NNTP_STRLEN))
	  {
	   if (s[0]=='.') break;
	   if (strpos("From",s)==1) strcpy(from,(char *) cut_arg(s)); else
	   if (strpos("Subject",s)==1) strcpy(subject,(char *) cut_arg(s)); else
	   if (strpos("Lines",s)==1) strcpy(lines,(char *) cut_arg(s)); else
	   if (strpos("Date",s)==1) strcpy(date,(char *) cut_arg(s)); 	  
	  } 
#ifdef NNTP_DEBUG
        /*StrLog("...nach#8 ");*/
#endif	  
          strcat(from,LEER);  		from[21]=0;
          strcat(subject,LEER);		subject[27]=0;
          strcat(date,LEER);		date[17]=0;
          strcat(lines,LEER);		lines[3]=0;
          sprintf(k,"%d             ",_art); k[5]=0;
	  fprintf(lst_fd,"%s %s %s %s %s\n", k,subject,from,date,lines);
	}
return(0);
}

/*
 * server_init  Get a connection to the remote server.
 *
 *	Parameters:	"machine" is the machine to connect to.
 *			"service" is the service to connect to on the machine.
 *			"port" is the servive port to connect to.
 *
 *	Returns:	-1 on error
 *			server's initial response code on success.
 *
 *	Side effects:	Connects to server.
 *			"nntp_rd_fp" and "nntp_wr_fp" are fp's
 *			for reading and writing to server.
 */

int server_init (machine, service, _port)
	char	*machine;
	char	*service;
	unsigned short _port;
{
	int	sockt_rd, sockt_wr;

	sockt_rd = get_tcp_socket (machine, service, _port); 

	if (sockt_rd < 0)
		return (-1);

	/*
	 * Now we'll make file pointers (i.e., buffered I/O) out of
	 * the socket file descriptor.  Note that we can't just
	 * open a fp for reading and writing -- we have to open
	 * up two separate fp's, one for reading, one for writing.
	 */

	if ((nntp_rd_fp = (FILE *) fdopen (sockt_rd, "r")) == NULL) {
		printf ("\nserver_init: fdopen #1");
		/*StrLog ("\nserver_init: fdopen #1");*/
		return (-1);
	}

	sockt_wr = dup (sockt_rd);

	if ((nntp_wr_fp = (FILE *) fdopen (sockt_wr, "w")) == NULL) {
		printf ("\nserver_init: fdopen #2");
		/*StrLog ("\nserver_init: fdopen #2");*/
		nntp_rd_fp = NULL;		/* from above */
		return (-1);
	}

	/*
	 * Now get the server's signon message
	 */
	/*(void) get_server (nntp_line, sizeof (nntp_line));*/
	return (atoi (nntp_line));
}




/*
 * put_server -- send a line of text to the server, terminating it
 * with CR and LF, as per ARPA standard.
 *
 *	Parameters:	"string" is the string to be sent to the
 *			server.
 *
 *	Returns:	Nothing.
 *
 *	Side effects:	Talks to the server.
 *			Closes connection if things are not right.
 *
 *	Note:	This routine flushes the buffer each time
 *			it is called.  For large transmissions
 *			(i.e., posting news) don't use it.  Instead,
 *			do the fprintf's yourself, and then a final
 *			fflush.
 */

void put_server (string)
	char *string;
{

	fprintf (nntp_wr_fp, "%s\r\n", string);
	(void) fflush (nntp_wr_fp);

}


void close_server ()
{
	if (nntp_wr_fp == NULL || nntp_rd_fp == NULL)
		return;

        printf("\nnntp: close server.");
	put_server ("QUIT");
	/*(void) get_server (nntp_line, sizeof (nntp_line));*/

	(void) fclose (nntp_wr_fp);
	(void) fclose (nntp_rd_fp);
}



char *nntp_respcode (respcode)
	int respcode;
{
	static char *text;

	/*
	 * If the last response line matches and has a description, return it
	 */
	if (atoi (nntp_line) == respcode && strlen (nntp_line) > 4) {
		return nntp_line;
	}

	switch (respcode) {
		case 0:
			text = "";
			break;
		case INF_HELP:
			text = "100  Help text on way";
			break;
		case INF_AUTH:
			text = "180  Authorization capabilities";
			break;
		case INF_DEBUG:
			text = "199  Debug output";
			break;
		case OK_CANPOST:
			text = "200  Hello; you can post";
			break;
		case OK_NOPOST:
			text = "201  Hello; you can't post";
			break;
		case OK_SLAVE:
			text = "202  Slave status noted";
			break;
		case OK_GOODBYE:
			text = "205  Closing connection";
			break;
		case OK_GROUP:
			text = "211  Group selected";
			break;
		case OK_GROUPS:
			text = "215  Newsgroups follow";
			break;
		case OK_XMOTD:
			text = "217  News motd file follows";
			break;
		case OK_XINDEX:
			text = "218  Group index file follows";
			break;
		case OK_ARTICLE:
			text = "220  Article (head & body) follows";
			break;
		case OK_HEAD:
			text = "221  Head follows";
			break;
		case OK_BODY:
			text = "222  Body follows";
			break;
		case OK_NOTEXT:
			text = "223  No text sent -- stat, next, last";
			break;
		case OK_NEWNEWS:
			text = "230  New articles by message-id follow";
			break;
		case OK_NEWGROUPS:
			text = "231  New newsgroups follow";
			break;
		case OK_XFERED:
			text = "235  Article transferred successfully";
			break;
		case OK_POSTED:
			text = "240  Article posted successfully";
			break;
		case OK_AUTHSYS:
			text = "280  Authorization system ok";
			break;
		case OK_AUTH:
			text = "281  Authorization (user/pass) ok";
			break;
		case OK_BIN:
			text = "282  binary data follows";
			break;
		case OK_SPLIST:
			text = "283  spooldir list follows";
			break;
		case OK_SPSWITCH:
			text = "284  Switching to a different spooldir";
			break;
		case OK_SPNOCHANGE:
			text = "285  Still using same spooldir";
			break;
		case OK_SPLDIRCUR:
			text = "286  Current spooldir";
			break;
		case OK_SPLDIRAVL:
			text = "287  Available spooldir";
			break;
		case OK_SPLDIRERR:
			text = "288  Unavailable spooldir or invalid entry";
			break;
		case CONT_XFER:
			text = "335  Continue to send article";
			break;
		case CONT_POST:
			text = "340  Continue to post article";
			break;
		case NEED_AUTHINFO:
			text = "380  authorization is required";
			break;
		case NEED_AUTHDATA:
			text = "381  <type> authorization data required";
			break;
		case ERR_GOODBYE:
			text = "400  Have to hang up for some reason";
			break;
		case ERR_NOGROUP:
			text = "411  No such newsgroup";
			break;
		case ERR_NCING:
			text = "412  Not currently in newsgroup";
			break;
		case ERR_XMOTD:
			text = "417  No news motd file";
			break;
		case ERR_XINDEX:
			text = "418  No index file for this group";
			break;
		case ERR_NOCRNT:
			text = "420  No current article selected";
			break;
		case ERR_NONEXT:
			text = "421  No next article in this group";
			break;
		case ERR_NOPREV:
			text = "422  No previous article in this group";
			break;
		case ERR_NOARTIG:
			text = "423  No such article in this group";
			break;
		case ERR_NOART:
			text = "430  No such article at all";
			break;
		case ERR_GOTIT:
			text = "435  Already got that article, don't send";
			break;
		case ERR_XFERFAIL:
			text = "436  Transfer failed";
			break;
		case ERR_XFERRJCT:
			text = "437  Article rejected, don't resend";
			break;
		case ERR_NOPOST:
			text = "440  Posting not allowed";
			break;
		case ERR_POSTFAIL:
			text = "441  Posting failed";
			break;
		case ERR_NOAUTH:
			text = "480  authorization required for command";
			break;
		case ERR_AUTHSYS:
			text = "481  Authorization system invalid";
			break;
		case ERR_AUTHREJ:
			text = "482  Authorization data rejected";
			break;
		case ERR_INVALIAS:
			text = "483  Invalid alias on spooldir cmd";
			break;
		case ERR_INVNOSPDIR:
			text = "484  No spooldir file found";
			break;
		case ERR_COMMAND:
			text = "500  Command not recognized";
			break;
		case ERR_CMDSYN:
			text = "501  Command syntax error";
			break;
		case ERR_ACCESS:
			text = "502  Access to server denied";
			break;
		case ERR_FAULT:
			text = "503  Program fault, command not performed";
			break;
		case ERR_AUTHBAD:
			text = "580  Authorization Failed";
			break;
		default:
			text = "Unknown NNTP response code";
			break;
	}
	return (text);
}




/*
 * get_tcp_socket -- get us a socket connected to the specified server.
 *
 *	Parameters:	"machine" is the machine the server is running on.
 *			"service" is the service to connect to on the server.
 *			"port" is the port to connect to on the server.
 *
 *	Returns:	Socket connected to the server if
 *			all is ok, else -1 on error.
 *
 *	Side effects:	Connects to server.
 *
 *	Errors:		Printed via perror.
 */

int get_tcp_socket (machine, service, _port)
	char	*machine;	/* remote host */
	char	*service;	/* nttp/smtp etc. */
	unsigned short _port;	/* tcp port number */
{
#ifdef NNTP_ABLE
	int	s = -1;
	struct	sockaddr_in _sin;


#ifndef EXCELAN
	struct	servent *getservbyname(), *sp;
	struct	hostent *gethostbyname(), *hp;
#ifdef h_addr
	int	x = 0;
	register char **cp;
	static char *alist[1];
#endif /* h_addr */
	unsigned long inet_addr();
	static struct hostent def;
	static struct in_addr defaddr;
	static char namebuf[256];

	if ((sp = (struct servent *) getservbyname (service, "tcp")) ==  NULL) {
		printf("%s/tcp: Unknown service.\n", service);
		/*StrLog("?/tcp: Unknown service.\n");*/
		return (-1);
	}
	/* If not a raw ip address, try nameserver */
	if (!isdigit(*machine) || 
	    (long)(defaddr.s_addr = (long) inet_addr (machine)) == -1) {
		hp = gethostbyname (machine);
	} else {
		/* Raw ip address, fake  */
		(void) strcpy (namebuf, machine);
		def.h_name = (char *) namebuf;
#ifdef h_addr
		def.h_addr_list = alist;
#endif
		def.h_addr = (char *) &defaddr;
		def.h_length = sizeof (struct in_addr);
		def.h_addrtype = AF_INET;
		def.h_aliases = 0;
		hp = &def;
	}
	if (hp == NULL) {
		printf ("\n%s: Unknown host.\n", machine);
		/*StrLog("\n Unknown host.\n");*/
		return (-1);
	}

	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = hp->h_addrtype;
	_sin.sin_port = sp->s_port;
#else /* EXCELAN */
	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = AF_INET;
#endif /* EXCELAN */

	/*
	 * The following is kinda gross.  The name server under 4.3
	 * returns a list of addresses, each of which should be tried
	 * in turn if the previous one fails.  However, 4.2 hostent
	 * structure doesn't have this list of addresses.
	 * Under 4.3, h_addr is a #define to h_addr_list[0].
	 * We use this to figure out whether to include the NS specific
	 * code...
	 */

#ifdef h_addr
	/*
	 * get a socket and initiate connection -- use multiple addresses
	 */

	for (cp = hp->h_addr_list; cp && *cp; cp++) {
		s = socket (hp->h_addrtype, SOCK_STREAM, 0);
		if (s < 0) {
			printf ("socket");
			/*StrLog("\nSOCK_STREAM: socket-error...");*/
			return (-1);
		}
		bcopy(*cp, (char *) &_sin.sin_addr, hp->h_length);
		
		if (x < 0) {
			fprintf (stderr, "Trying %s", (char *) inet_ntoa (_sin.sin_addr));
		}
		x = connect (s, (struct sockaddr *) &_sin, sizeof (_sin));
		if (x == 0) {
			break;
		}
		fprintf (stderr, "\nConnection to %s: ", (char *) inet_ntoa (_sin.sin_addr));
		/*StrLog("\nConnection to...... close");*/
		(void) close (s);
	}
	if (x < 0) {
		fprintf (stderr, "Giving up...\n");
		sprintf(buf,"nntp-host: %s  -> Giving up...",NNTP_HOST);
		MailErr(1,buf,"failure: nntp-host is not aviable!");
		exit (-1);
	}
#else	/* no name server */
#ifdef EXCELAN
	if ((s = socket (SOCK_STREAM,(struct sockproto *)NULL,&_sin,SO_KEEPALIVE)) < 0) {
		/* Get the socket */
		printf ("socket");
		return (-1);
	}
	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = AF_INET;
	_sin.sin_port = htons (IPPORT_NNTP);
	/* set up addr for the connect */

	if ((_sin.sin_addr.s_addr = rhost (&machine)) == -1) {
		fprintf (stderr, "\n%s: Unknown host.\n", machine);
		return (-1);
	}
	/* And then connect */

	if (connect (s, (struct sockaddr *)&_sin) < 0) {
		printf ("connect");
		/*StrLog(" connect-err ");*/
		(void) close (s);
		return (-1);
	}
#else /* not EXCELAN */
	if ((s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
		printf ("\nsocket-error ");
		/*StrLog("AF_INET: socket-error");*/
		return (-1);
	}

	/* And then connect */

	bcopy (hp->h_addr, (char *) &_sin.sin_addr, hp->h_length);
	if (connect (s, (struct sockaddr *) &_sin, sizeof (_sin)) < 0) {
		printf("connect");
		/*StrLog("connect");*/
		(void) close (s);
		return (-1);
	}

#endif /* !EXCELAN */
#endif /* !h_addr */
	return (s);
#else
	return (-1);
#endif /* NNTP_ABLE */
}




/*
 * get_server -- get a line of text from the server.  Strips
 * CR's and LF's.
 *
 *	Parameters:	"string" has the buffer space for the
 *			line received.
 *			"size" is the size of the buffer.
 *
 *	Returns:	-1 on error, 0 otherwise.
 *
 *	Side effects:	Talks to server, changes contents of "string".
 *			Reopens connection when necessary and requested.
 */


int get_server_line(string, size)
    char *string;
    int size;
{
    register char *cp, *nl;

#ifdef NNTP_DEBUG
        /*StrLog("\nget_server_line...");*/
#endif
    if (fgets(string, size, nntp_rd_fp) == NULL) {
	io_error();
	return -1;
    }
    for (cp = string, nl = NULL; *cp != NUL; cp++) {
	if (*cp == CR) {
	    nl = cp;
	    break;
	}
	if (nl == NULL && *cp == NL)
	    nl = cp;
    }
    if (nl != NULL) *nl = NUL;
#ifdef NNTP_DEBUG
        /*StrLog("...done\n");*/
#endif
        
    return 0;
}



/*
 * get_server: get a response line from the server.
 *
 * 	Returns the numerical value of the reponse, or -1 in case of errors.
 */

int  get_server(string, size)
    char *string;
    int size;
{
    if (get_server_line(string, size) < 0)
	return (0);
#ifdef NNTP_ART_DEBUG
   Log(190,"get_server",string);
#endif
     return((int ) strlen(string));
}



int io_error()
{
      printf( "\nLost connection to nntp-server");
      return(0);
}






/*
 *  get a response code from the server and return it to the caller
 */

int get_nntp_code ()
{
	char line[NNTP_STRLEN];

	if (get_server (line, NNTP_STRLEN) == -1) {
	        Log(190,"nntp-error: txt_connection_to_server_broken",line);
		printf("nntp-error: txt_connection_to_server_broken\n");
		return(0);
	}
#ifdef NNTP_LOG	
	Log(190,"nntp: get_respcode",line);
#endif	
	return atoi (line);
}





/* schreibt Artikel-Header in TMP */
int NNTPGetArticle(art_no,lst)
int art_no;
char *lst;
{
static int nstat,_art,richtung;
FILE *fd;
char s[4096],k[4094];
int c=0;
static int ret_art=0;



void NNTPReadArticle()
{
         sprintf(k,"HEAD");
         put_server(k);
         s[0]=0;
         if (get_nntp_code()==OK_HEAD)
         {

          while ((get_server(s,2048)!=-1)&& 
                     (!((s[0]=='.')&&(strlen(s)==1)))
               )
          {
           fprintf(fd,"%s\n",s);
          }
         } /* if body ok ..*/

         fprintf(fd,"\n"); 
         
         sprintf(k,"BODY");
         put_server(k);
         s[0]=0;
         if (get_nntp_code()==OK_BODY)
         {

          while ((get_server(s,2048)!=-1)&& 
                     (!((s[0]=='.')&&(strlen(s)==1)))
               )
          {
           fprintf(fd,"%s\n",s);
          }
          
         } /* if body ok ..*/
	 
}


#ifdef _ART_DEBUG
       printf("\nNNTPGetArticle(in:%d)",art_no);
#endif

if ((fd=fopen(lst,"w"))==NULL)
{
  printf("\nCan't write (%s), contact Sysop!",lst);
  return((int) 0);
}
       
        sprintf(k,"STAT");
        put_server(k);
	get_server(s,NNTP_STRLEN);
	
	nstat=atoi((char *) s); /* nntp-status */
#ifdef _ART_DEBUG		
	printf("\nnntp:%s",s);
#endif	
	
	if (nstat==OK_NOTEXT) 	/* stat ok? */
	{
	  strcpy(s,(char *) cut_arg(cut_leer(s))); 
	  _art=atoi((char *) s); /* artikel-Nummer */
#ifdef _ART_DEBUG		
        printf("NNTPGetArticle(%d): stat: article: %d",art_no,_art);
#endif		  


         if (_art==art_no) {
           NG_ART=ret_art=art_no;         
           NNTPReadArticle();
           fclose(fd);  
           return(_art);
         }
                    

        } else
        {    /* stat != OK */
#ifdef _ART_DEBUG		
        printf("NNTPGetArticle(): stat!=ok");
#endif		
#ifdef VIEW
	 printf("\nNNTPGetArticle()-> stat!=ok: %s\n",s);        
#endif	 
         ret_art=0;
        }
fclose(fd);
if (!ret_art) unlink(lst);
return(ret_art);
}





/* check, on Artikel da ist oder nicht und setzt NNTP-Server auf Start-Porition */
int NNTPSetArticle(art_no)
int art_no;
{
int nstat,_art,richtung;
FILE *fd;
char s[NNTP_STRLEN],k[NNTP_STRLEN];
int c=0;
int ret_art=0;
unsigned char date[NNTP_STRLEN],from[NNTP_STRLEN],subject[NNTP_STRLEN],lines[NNTP_STRLEN];



        sprintf(k,"STAT");
        put_server(k);
	get_server(s,NNTP_STRLEN);
	
#ifdef NNTP_ART_DEBUG		
	sprintf(k,"nntp: \"STAT\" -> %s",s);  
	/*StrLog(k);*/
#endif	
	
	nstat=atoi((char *) s); /* nntp-status */
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:",s);
	/*StrLog(s);*/
#endif	
	strcpy(s,(char *) cut_arg(cut_leer(s))); 
	if (nstat==OK_NOTEXT) 	/* stat ok? */
	{
	  _art=atoi((char *) cut_leer(s)); /* artikel-Nummer */
#ifdef NNTP_ART_DEBUG		
        sprintf(s,"NNTPGetArticle(%d): stat: article: %d",art_no,_art);
	Log(190,"nntp:",s);
	/*StrLog(s);*/
#endif		  

         
         if (_art==art_no) return (_art);
/*         
          else
              printf("%s%c",GetText("BLD23_MSG"),CR);
*/                             
         
         if (_art<art_no) {
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:","if (_art<art_no) ->Next");
#endif		           
          do{
           c=NntpNext();
          }
          while ((c<art_no)&&(c!=0));
         } else
         {
          if (_art!=art_no )
          {
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:","if (!(_art<art_no)) ->Prev");
#endif	
           do {
            c=NntpPrev();
           }
           while ((c>art_no)&&(c!=0));
          }
         }
                   
         return(c);
	 
        } else
        {    /* stat != OK */
#ifdef NNTP_ART_DEBUG		
        sprintf(s,"NNTPGetArticle(): stat!=ok");
	Log(190,"nntp:",s);
	/*StrLog(s);*/
#endif		
	 return(0);
        }
    return(art_no);
}


/* Artikel ueber NNTP-senden */
int NntpPost(artikel)
char *artikel;
{
char k[NNTP_STRLEN];
char ss[NNTP_STRLEN];
int i;
FILE *fd;

  sprintf(k,"POST");
  put_server(k);
          
  if ((i=get_nntp_code())!=CONT_POST)
   {
    printf("\n%s",nntp_respcode(i));
    return(0);
   }
  if ((fd=fopen(artikel,"r"))==NULL)
  {
   printf("nntp: NntpPost -> Can't open (%s)\n", artikel);
   return(0);
  }
  while (fgets(ss,NNTP_STRLEN,fd)!=NULL)
  {
    if (ss[0]=='.') ss[0]=SPACE;
    if (ss[strlen(ss)-1]=='\n') ss[strlen(ss)-1]=0;
    put_server(ss);
  }
  fclose(fd);
  sprintf(k,".");
  put_server(k);
  printf("\nwait for nntp-server responding .....");
  sleep(3);  /* bei INN_NNTP-Servern muss eine kleineWartezeit zwischen den Postings liegen! */

  if ((i=get_nntp_code())!=OK_POSTED)
  {
   printf("\n%s",nntp_respcode(i));
   return(0);
  }      
  else 
  {
   printf("\n%s\n",nntp_respcode(i));
   return(1);
  }
}






int NNTPReadActive()
/*
 *  Read active file
 */
{
	char group_name[2048];
	struct act_ent *ap, *d;
	char s[NNTP_STRLEN];
	int n,nstat,g=0;
	FILE *fd;




	if (act_list!=NULL) return(1);
	
  	
	
/*StrLog("\nNNTPReadActive()....");*/
	printf("nntp: read active ...."); fflush(stdout);
	
#ifdef DEBUG
	printf("\NNTPReadActive(): in ");
#endif


	
	d=NULL;
	put_server("LIST\n");
	get_server(group_name,NNTP_STRLEN);
	Log(190,"nntp: read active-file",group_name); 
	n=0;
	nstat=atoi((char *) cut_bef(cut_leer(group_name))); /* nntp-status */
        article=groups=0;
        	
	if (nstat!=OK_GROUPS) {
          sprintf(group_name,"stat=%d",nstat);	 
	  nerror("s_qwk_lst.c", 304, "nntp: read-active", "read invalid nntp-status -> nntp server is down?",group_name );
	  return;
	}

	sprintf(s,"%s/tmp/qwk",HOME); mkdir(s,0777);
	sprintf(s,"rm -rf %s/tmp/qwk/%d",HOME,USER_ID); system(s);
	sprintf(s,"%s/tmp/qwk/%d",HOME,USER_ID); mkdir(s,0777);
        sprintf(s,"%s/tmp/qwk/%d/active$",HOME,USER_ID);
        fd=fopen(s,"w");
        	
	/* Read through it */
	while ( (get_server(s,NNTP_STRLEN)) )
	{
		/* Get new act entry */
#ifdef NNTP_DEBUG
	printf("\nReadActive(): nntp_read: (%s)\n",strings(s));
	msleep(20);
#endif
		g++;
                if ((strpos(".",s)==1)||(strlen(s)<2)) break;
                strcpy(buf,s);
                fprintf(fd,"%s\n",s);        
		ap = (struct act_ent *) malloc (sizeof (struct act_ent));
		if (ap == NULL) OutOfMemory();

		/* Parse name, message numbers */
		sscanf (buf, "%s %d %d %c", group_name, &ap->hi, &ap->lo,&ap->post);
		article=article+ap->hi-ap->lo+1;
		ap->name = (char *) malloc (1+strlen(group_name));
		if (ap->name == NULL) OutOfMemory();
		strcpy (ap->name, group_name);
#ifdef NNTP_DEBUG
	printf("\NNTPReadActive(): group_nam: %s\n",group_name);
#endif
		/* Add to list */
		ap->is_area=1; /* am Anfang sind alle 'on' */
		ap->next = act_list;
		ap->prev=d;
		act_list = d = ap;
	}
#ifdef NNTP_DEBUG
	printf("\NNTP_ReadActive(): Return(1)"); sleep(1);
#endif	
  	sprintf(group_name,"number of groups=%d",g);	 
  	fclose(fd);

        Log(150,"nntp: ",group_name);
  	
        
  	groups=g;
  	sprintf(s,"%s/etc/acticle.id",HOME);
  	if ((fd=fopen(s,"w"))!=NULL)
  	{
  	 fprintf(fd,"%d %d\n%s\n%s",groups,article,mydate(0),mytime(0));
  	 fclose(fd);
  	} else 
  	{
  	 nerror("s_qwk*ls.c", 383, "NNTP_ReadActive", "Can't write", s);
  	}
	
	sprintf(group_name,"cat %s/tmp/qwk/%d/active$|%s>%s/tmp/qwk/%d/active",HOME,USER_ID,RSORT,HOME,USER_ID);  	
	system(group_name);
	sprintf(group_name,"%s/tmp/qwk/%d/active$",HOME,USER_ID);  	
	unlink(group_name);

/*        StrLog("...done");*/
	return (1);
}





/* the better funct() for check the user-entry
 */
struct nrc_ent  *FindRcEntry (c)
char *c;
{
char s[2*STRING];

	struct nrc_ent *ap;
	
	ap = nrc_list;
	strcpy(s,c); 
	
	while (NULL != ap)
	{
		if ((strpos(ap->name,s)==1) &&(strpos(s,ap->name)==1) )
		{		
		return (ap);
		}
		ap = ap->next;
	}
	return (NULL);
}
