
/* ix/MBox (language.c) by Sylvio Runge 9/94

   Die Funktionen fuer untersch. BBS-Sprachen    

   This C source code contains the following functions:

*/



#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <strings.h>
#include <dirent.h>




#define LOW_STRING 40

#undef LSTRING
char HOME[80];



#include "../mbox.h"
#include "../s_global.h"
#include "../proto.h"
#include "../language.h"

#define _USE_SHARED_MEM


#undef DEBUG   /* INIT  */
#undef DEBUG2  /* GetText() */
#define MAXLE 10	/* max Versuche bis voreingest, sprache */
int NEWLOGIN=1;
int org=0;
int gbl_mode=0,gbl_lang=0;

#ifndef _USE_SHARED_MEM
static struct L_TYP l_entry[MAX_LANGUAGE_ENTRY];
#else
#include <sys/ipc.h>
#include <sys/shm.h>
static struct L_TYP *l_entry,*entry_top;
static int mem_id;
static struct shmid_ds sh_buf;
#endif
    
    
int new_lang=0; 

#define LANG_TEST   /* check der MSG-BASE */
    
    
unsigned char *mydate(mode)
int mode;
{
  struct tm *tp;
  time_t tt;
   unsigned char wt[8][11];

  static  unsigned char s[STRING];


  strcpy(wt[0], "Sonntag");
  strcpy(wt[1], "Montag");
  strcpy(wt[2], "Dienstag");
  strcpy(wt[3], "Mittwoch");
  strcpy(wt[4], "Donnerstag");
  strcpy(wt[5], "Freitag");
  strcpy(wt[6], "Samstag");
  time(&tt);
  tzset();
  tp = localtime(&tt);
  if (mode == 0) {
	sprintf(s, "%02.2d.%02.2d.%04.4d", tp->tm_mday, tp->tm_mon + TZS, 1900 + tp->tm_year);
  }
  if (mode == 1) {
	sprintf(s, "%02.2d.%02.2d.%02.2d", tp->tm_mday, tp->tm_mon + TZS, tp->tm_year);
  }
  if (mode == 2) {
	sprintf(s, "%s", wt[tp->tm_wday]);
  }
  if (mode == 3) {
	if((tp->tm_wday == 0) || (tp->tm_wday == 6))
		strcpy(s, wt[tp->tm_wday]);

	else
		s[0] = 0;
  }
  return ( unsigned char *) s;
}



void Logo()
{
 printf("\n");
 printf("+---------------------------------------------------------------------------+\n");
 printf("|  %s: mk.lang                                                       |\n",VERSION); 
 printf("|  (c) 08/96  <runge@boerde.de>                                             |\n");        
 printf("+---------------------------------------------------------------------------+\n"); 

}


/* strings-funct */
unsigned char *strings(s)
unsigned char s[];
{
static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<32)) b[j]=32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}


/* Position eines Strings in einem anderen -> strpos alias PAS */
int strpos(s, t)
UNSIGNED char s[], t[];
{
  int j=0, i = 0, a = 0;
  
  
    while (t[i] != 0) 
    {
      j=0;
      if (t[i] == s[0]){
      a=i+1;
      while ((s[j]==t[i])&&(s[j]!=0)) {
      j++; i++;
    }
 if (s[j]==0) return (int) a ; else a='0';
 }
 i++;                                                                                                      }
 return (int) NULL;
}





UNSIGNED char *cut_bef(s)
UNSIGNED char s[];
{
  static UNSIGNED char bef[2*STRING];
    int i = 0;
    
    
      while (s[i] > 32) {
              bef[i] = s[i];
                      i++;
                        }
                          bef[i] = 0;
                            return (UNSIGNED char *) bef;
}
                            

unsigned char *cut_arg(s)
unsigned char s[];
{
  static unsigned char arg[STRING];
    int i = 0, a = 0;
      while (s[i] > 32) i++;
        if (s[i] == 0) return (unsigned char *) "";
          while (s[i] == 32) i++;
            while (s[i] != 0) {
                    arg[a] = s[i];
                            i++;
                                    a++;
     }
     arg[a] = 0;
     while((arg[(a-1)] < 33) && (a > 1)){
     a--;
     arg[a] = 0;
   }
   return (unsigned char *) arg;
}
                                                              
                                                                                                         

/* Einlesen der *msg-Files in sprache 1 == deutsch  */
void L_Init0(mode,language)
int mode,language;
{
int i,n,j=0,m;
unsigned char h[LSTRING];
unsigned char b[LSTRING];
unsigned char a[STRING];
FILE *fd=NULL;


	 gbl_mode=mode;
	 gbl_lang=language;
         sprintf(h,"%s/etc/languages/msg/%s",HOME,GetLangName(language,0));
         if (!((language==1)&&(mode==1)))
           printf("\nprocess language#%d (%s)...",language,GetLangName(language,0));              
         if ((language==1)&&(strpos("deutsch",GetLangName(language,0))!=1))
         {
            printf("\n\7(language #1) != german (deutsch)\n  Please check first 'list.languages!\n"); 
            exit(-1);
         }
NEWLANG:
         if ((fd=fopen(h,"r"))==NULL)
         {
           printf("\n mk.lang: new language \"%s\" detected -> create a new msg-base\n load default langauge....", GetLangName(language,0));          
           fd=fopen(h,"w");
           fclose(fd);
           new_lang++;
           L_Init0(1,1);
           printf(" make new message-strings... (%s)\n", GetLangName(language,0));
           goto NEWLANG;
         }
     if ((language==1)&&(!mode))
     {
         NEWLOGIN=0;
         for (i=0; i<=MAX_LANGUAGE_ENTRY; i++)
         {
           strcpy(l_entry->name,"");
           l_entry->txt[0]=0;
           l_entry++;
         }
         i=0;
         l_entry=entry_top;
         

	 while ((fgets(h,LSTRING-2,fd)!=NULL))         
 	 {
 	   strcpy(a,(char *) cut_bef(h));
 	   strcpy(b,(char *) CutMsg0(cut_arg(h)));
           strcpy(l_entry->name,(char *) a);
           l_entry->ok=0;
           b[99]=0;
           strcpy(l_entry->txt,(char *) b);
           i++;  l_entry++;
 	 }
 	 if (i>(MAX_LANGUAGE_ENTRY-3)) nerror("language.c", 101, "language", "language: msg-file to large, to many messages", "msg-file to large");
 	 printf(" -> %d entrys",i);
 	 org=i;
     }
     else
     {
         m=0; i=0; 
	 while ((fgets(h,LSTRING-2,fd)!=NULL))         
 	 {
 	   strcpy(a,(char *) cut_bef(h));
 	   strcpy(b,(char *) CutMsg0(cut_arg(h)));
 	   l_entry=(struct L_TYP *) GetText0((char *) a);
         
           
           b[99]=0;
           if (l_entry!=NULL) {
             strcpy(l_entry->txt,(char *) b);
             l_entry->ok=1;
            }
            else  m++;

           i++;  
           
 	 }
 	 if (i>(MAX_LANGUAGE_ENTRY-3)) nerror("language.c", 101, "language", "language: msg-file to large, to many messages", "msg-file to large");
 	 if ((org-i-m)>0)
 	 {
 	  if (i>org-i-m)
    	    printf(" -> %d entrys (%d old, %d new)",i,m,org-i-m);     
    	   else
    	   printf(" -> %d entrys (%d old, %d new)",org-i-m,m,org-i-m);
    	   ViewNewMsg(mode);
 	 }
 	 else
 	 printf(" -> %d entrys (%d old, %d new)",i,m,0);
 	 
     
     }
     fclose(fd);
  
 
}



void ViewNewMsg(mode)
int mode;
{
int i,mod=0;
char s[STRING];

 l_entry=entry_top;
 if (l_entry!=NULL) 
 {
   for (i=0; i<=MAX_LANGUAGE_ENTRY; i++)
   {
        if (!l_entry->ok)
        {
          if (!mod)
          {
           mod=1;
           StrLLog(0,"\n\n");
           printf("Log-Messages are found in \"/tmp/t-bbs.newmsg.log\" ");
           StrLLog(0,"\n------------ new messages-strings are in ~bbs/etc/langauges/msg ------\n");
          }
          StrLLog(1,l_entry->name);
        }
        l_entry->ok=0; 
        l_entry++;
   }
 }

}




void StrLLog(mode,str1)
int mode;
unsigned char *str1;
{
FILE *fd;
unsigned char s[2*STRING];

 fflush(stdout);
 sprintf(s,"/tmp/t-bbs.newmsg.log");
 if  ((fd=fopen(s,"a"))!=NULL)
 if ((mode) && (strlen(str1)>1))
 {
  fprintf(fd,"%s, ",mydate(0));
  fprintf(fd,"language=%s :",GetLangName(gbl_lang,0));
  printf("language=%s : ",GetLangName(gbl_lang,0));
 }
 fprintf(fd,"%s",str1);
 printf("%s",str1);
 if ((mode) && (strlen(str1)>1))
 {
  fprintf(fd,"\n");
  printf("\n");
 }
 fclose(fd);
 fflush(stdout);

}






void Done()
{
   shmctl(mem_id, IPC_RMID, &sh_buf);
   if (new_lang>0) 
   {
    printf("\n------------------------------------------------------------------");
    printf("\n  Don't forget:                                                  ");
    printf("\n  translate your new ~bbs/etc/languages/... files for a real     ");
    printf("\n  language-support.                                              ");
    printf("\n------------------------------------------------------------------");
   }
}


                                                                                                         

/* Seichern der *msg-Files in sprache !=1   */
void LSave(language)
int language;
{
int i,n,j=0,m;
unsigned char h[LSTRING];
unsigned char b[LSTRING];
unsigned char a[LOW_STRING];
FILE *fd=NULL;


          switch (language)
          {
          case 1:
           return;
           break;
          default:
           sprintf(h,"%s/etc/languages/msg/%s",HOME,GetLangName(language,0));
   	   break;
          }
         printf("; save....");              
         if ((fd=fopen(h,"w"))==NULL) nerror("language.c", 60, "language", "Can't read, tell your sysop to complaint", h);          
         l_entry=entry_top;
         j=0;
         while (j<(MAX_LANGUAGE_ENTRY-3))
            {
              if (strlen(l_entry->name)>0)
              {
               fprintf(fd,"%s \"%s\"\n",(char *) l_entry->name,(char *) l_entry->txt);
              }
               j++; l_entry++;
            }
         fclose(fd);
}



struct L_TYP *GetText0(nam)
unsigned char nam[];
{
static unsigned char  b[STRING];
int i=0;

l_entry=entry_top;
  sprintf(b,"%s (%s) not found, tell your sysop\n",SL_04,nam);
  while  (i<MAX_LANGUAGE_ENTRY)
  {
   if ((strpos(nam,l_entry->name)) && (l_entry->txt!=NULL))
    return (struct L_TYP *) (l_entry);    
   i++; l_entry++;
  }
  if (strpos(SL_04,b))
    {
       /*
       printf("\n\7msg-entry (text) (%s) not found, tell your sysop\n",nam);     
       */
   }
  
  
 return (struct L_TYP *) (0);
}



int GetEChar0(nam)
unsigned char nam[];
{
int i=0,b=-1;
unsigned char a[STRING];

  while  (i<MAX_LANGUAGE_ENTRY)
  {
   if ( (strpos(nam,l_entry->name)) && (l_entry->txt!=NULL)) {
      strcpy(a,l_entry->txt);
      b=a[0];
     }
   i++; l_entry++;
  }
 if (b==-1)
  {
	printf("\n\7msg-entry (char) (%s) not found, tell your sysop\n",nam);     
	sleep(1); b=0;
  }
  
 return (b);
}







unsigned char *CutMsg0(nam)
unsigned char nam[];
{
static unsigned char  b[STRING];
int i=1;

  b[0]=0;
  while  (i< (strlen(nam)-1))
  {
   b[i-1]=nam[i];
   i++;
  }
  b[i-1]=0;
  
 return (UNSIGNED char *) (b);
}





void MemInit()
{
    if ((mem_id=shmget(L_KEY,(sizeof(struct L_TYP)*MAX_LANGUAGE_ENTRY ),
                      IPC_CREAT | L_PERM))<0)
   { 
    printf("\nCan't alloc shared-Memory -> STOP\n"); exit(-1);
   }                      
                      
    entry_top=(struct L_TYP *) shmat(mem_id,0,0);
    l_entry =entry_top; 
    if (entry_top < ((struct L_TYP *) 0))
     {
      nerror("language.c", 162, "tbbs: shmat() failed", 
      "system: Can't handle shared memory | memory is bad & to small.... ", 
      "system-memory is full");
      exit(-6);
     }         
   l_entry =entry_top;
}



void main()
{
int i;

#if defined(_ESTDIO) || !defined(_SYS7)
  setbuf(stdout, NULL);
  setbuf(stdin, NULL);
#endif
    
SetMain();
Logo();



/* msg-base */
printf("\nStep 1: Check MSG-Base (msg), please wait....."); 
#ifdef LANG_TEST
MemInit();
for (i=1; i<=GetMaxLanguage(); i++)
{
  L_Init0(i-1,i);   /* Deutsch laden bzw. process */
  if (i>1) LSave(i);
}
#endif

printf("\n\nStep 2: Check languages-links and directorys, please wait....."); 
for (i=1; i<=GetMaxLanguage(); i++)
 do_link_check(i);



Done();
printf("\n\nbye.\n");
}
