
/* ix/MBox (language.c) by Sylvio Runge 9/94

   Die Funktionen fuer untersch. BBS-Sprachen    

   This C source code contains the following functions:

*/



#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
/*#include <stdlib.h>*/
#include <strings.h>


int L_INIT=0;


/*#include <sys/wait.h>*/
#include <dirent.h>



#define LOW_STRING 40

#undef LSTRING


#ifndef VU
#include "mbox.h"
#include "s_global.h"
#include "proto.h"
#include "language.h"
#else
#include "../mbox.h"
#include "../s_global.h"
#include "../proto.h"
#include "../language.h"
#endif



#undef DEBUG   /* INIT  */
#undef DEBUG2  /* GetText() */
#define MAXLE 10	/* max Versuche bis voreingest, sprache */
int NEWLOGIN=1;
#ifdef _USE_SHARED_MEM
int make_sh=1;		/* sh-mem-segment ist schon da :) */
#endif

#ifndef _USE_SHARED_MEM
 static struct L_TYP l_entry[MAX_LANGUAGE_ENTRY];     
#else 
#include <sys/ipc.h>
#include <sys/shm.h>
 static struct L_TYP *l_entry,*entry_top; 
 static int mem_id;   			
 static struct shmid_ds sh_buf;
#endif

/* Einlesen der *msg-Files je nach sprache */
void L_Init()
{
int i,n,j=0,kk=0;
unsigned char h[LSTRING];
unsigned char b[LSTRING];
unsigned char a[LOW_STRING];
FILE *fd=NULL;

 alarm(30*60); /* TimeOUT bei Abfrage der Sprache */
#ifdef ONLY_GERMAN

  ZOPT.OPT->USER.language=1;
  i=1;
  
  
#else  

  if (ZOPT.OPT->USER.language>GetMaxLanguage()) ZOPT.OPT->USER.language=0;
  i=ZOPT.OPT->USER.language;
  L_INIT=1; 

  
  while ((!ZOPT.OPT->USER.language)&&(j<MAXLE))
  {
  
     SetFett("us",0,0);
     printf("\n\n%s:\n",GetGbl("L_QUESTION0"));
     SetNorm("me",0,0);
     
     for (kk=0; kk<GetMaxLanguage(); kk++) 
     printf ("%d  %s\n",kk+1,GetLangName(kk+1,1));
     printf("\n[1..%d] >",GetMaxLanguage());
     
     printf("1%c",BS); fflush(stdout);
     i=getint()-48;  printf("%c",i+48);
     LOOP:
      if ((i>0)&&(i<(GetMaxLanguage()+1))) {
        ZOPT.OPT->USER.language=i;
        strcpy(h,(unsigned char *) GetLangName(ZOPT.OPT->USER.language,0));
        printf("\nlanguage: %s\n",h); 
       }
       else
       {
        if (i==-38)  
        {
          i=1;
          goto LOOP;
        }
       }
     j++;
  }
  if (j>=MAXLE) {
     ZOPT.OPT->USER.language=1;  i=1;
     printf(SL_03); 
     SetFett();
     printf("\n%s\n",SL_02);
     SetNorm();
   }
#endif /* ONLY_GERMAN */
   
 if ((i>0)&&(i<(GetMaxLanguage()+1))) /* l_init */
 {
          sprintf(h,"%s/etc/languages/msg/%s",
           ZOPT.OPT->HOME,(char *) GetLangName(ZOPT.OPT->USER.language,0));
     if (NEWLOGIN)
     {
         NEWLOGIN=0;
#ifndef _USE_SHARED_MEM         
         for (i=0; i<=MAX_LANGUAGE_ENTRY; i++)
         {
           strcpy(l_entry[i].name,"");
           l_entry[i].txt[0]=0;
         }
#else     
      if (((mem_id=shmget(L_KEY+ZOPT.OPT->USER.language,
           (sizeof(struct L_TYP)*MAX_LANGUAGE_ENTRY ),
          IPC_EXCL | L_PERM))<0)!=0)
      {
/*         printf("\nmake new shared-menory-segment...\n"); !!!!!!!!!*/
         if ((mem_id=shmget(L_KEY+ZOPT.OPT->USER.language,
           (sizeof(struct L_TYP)*MAX_LANGUAGE_ENTRY ),
           IPC_CREAT | L_PERM))<0)
         {
          nerror("language.c", 152, "tbbs: shmget() failed", 
          "system: Can't handle shared memory | memory is bad & to small.... ", 
          "system-memory is full");
          exit(-5);
         }

       }  /* end creat memory-segment */ else make_sh=0;
       
         entry_top=(struct L_TYP *) shmat(mem_id,0,0);
         l_entry =entry_top; 
         if (entry_top < ((struct L_TYP *) 0))
         {
          nerror("language.c", 162, "tbbs: shmat() failed", 
          "system: Can't handle shared memory | memory is bad & to small.... ", 
          "system-memory is full");
          exit(-6);
         }         
         
         l_entry =entry_top; 
#endif         
         i=0;
#ifdef _USE_SHARED_MEM         
         l_entry =entry_top;
#endif         
         if ((fd=fopen(h,"r"))==NULL) nerror("language.c", 60, "language", "Can't read, tell your sysop to complaint", h);
#ifdef _USE_SHARED_MEM         
         if (make_sh) /* neues Segment initialisieren */
#else
         if (1)
#endif         
         {
	 while ((fgets(h,LSTRING-2,fd)!=NULL))         
 	 {
 	   strcpy(a,(char *) cut_bef(h));
 	   strcpy(b,(char *) CutMsg(cut_arg(h)));
#ifndef _USE_SHARED_MEM 	   
           strcpy(l_entry[i].name,(char *) a);
#else
           strcpy(l_entry->name,(char *) a);
#endif           
           
           b[99]=0;
#ifndef _USE_SHARED_MEM           
           strcpy(l_entry[i].txt,(char *) b);
#else
           strcpy(l_entry->txt,(char *) b);
#endif           
           i++;
#ifdef _USE_SHARED_MEM           
           l_entry++;
#endif           
 	 }
 	 if (i>(MAX_LANGUAGE_ENTRY-3)) {
 	   printf("\nlanguage.c:  msg-file to large, to many system-messages (file corrupt?)!\n");
 	   sleep(4); exit(-3);
 	  }
 	 }
     }
     fclose(fd);
#ifdef _USE_SHARED_MEM        
     if (make_sh)
     {
      l_entry++;        
      strcpy(l_entry->name,"");
      l_entry->txt[0]=0;
      /*shmctl(mem_id, IPC_RMID, &sh_buf);  nicht seg. loeschen!!! */
     }
#endif                           
                           
 }
}


unsigned char *GetText(nam)
unsigned char nam[];
{
static unsigned char  b[STRING];
int i=0;

  sprintf(b,"%s (%s) not found, tell your sysop\n",SL_04,nam);
#ifdef _USE_SHARED_MEM
         l_entry =entry_top;
#endif  
  while  (i<MAX_LANGUAGE_ENTRY)
  {
#ifndef _USE_SHARED_MEM  
   if ((strpos(nam,l_entry[i].name)) && (l_entry[i].txt!=NULL))
    return (UNSIGNED char *) (l_entry[i].txt);    
#else
   if ((strpos(nam,l_entry->name)) && (l_entry->txt!=NULL))
    return (UNSIGNED char *) (l_entry->txt);    
#endif    
   i++; 
#ifdef _USE_SHARED_MEM   
   l_entry++;
#endif   
  }
  if (strpos(SL_04,b))
    {
       TextErrLog(0,nam);
       /*
       printf("\n\7msg-entry (text) (%s) not found, tell your sysop\n",nam);     
       */
   }
  
  
 return (UNSIGNED char *) (b);
}



int GetEChar(nam)
unsigned char nam[];
{
int i=0,b=-1;
unsigned char a[STRING];

#ifdef _USE_SHARED_MEM
         l_entry =entry_top;
#endif

  while  (i<MAX_LANGUAGE_ENTRY)
  {
#ifndef _USE_SHARED_MEM  
   if ( (strpos(nam,l_entry[i].name)) && (l_entry[i].txt!=NULL)) {
      strcpy(a,l_entry[i].txt);
#else
   if ( (strpos(nam,l_entry->name)) && (l_entry->txt!=NULL)) {
      strcpy(a,l_entry->txt);
#endif      
      b=a[0];
     }
   i++; 
#ifdef _USE_SHARED_MEM   
   l_entry++;
#endif   
  }
 if (b==-1)
  {
	printf("\n\7msg-entry (char) (%s) not found, tell your sysop\n",nam);     
	sleep(1); b=0;
        TextErrLog(1,nam);
  }
  
 return (b);
}







unsigned char *CutMsg(nam)
unsigned char nam[];
{
static unsigned char  b[STRING];
int i=1;

  b[0]=0;
  while  (i< (strlen(nam)-1))
  {
   b[i-1]=nam[i];
   i++;
  }
  b[i-1]=0;
  
 return (UNSIGNED char *) (b);
}





unsigned char *GetLanguage()
{
static unsigned char b[LOW_STRING];

strcpy(b,(unsigned char *) GetLangName(ZOPT.OPT->USER.language,0));
return (UNSIGNED char *) (b);
}







int smalltalk( cmdline )
UNSIGNED char cmdline[];
{

#ifndef VU   
           if 
              (
               (ZOPT.OPT->USER.lisa_text < 2)&&(!ZOPT.OPT->lisa_ruhe)
                &&(!ZOPT.OPT->MENUE_USING) 
               )      
             smalltalk_german(cmdline);
#endif           

  return((int) 1);
}


void  TextErrLog(i,nam)
int i;
unsigned char nam[];
{
 FILE *fd;
 unsigned char s[STRING];
 
#ifdef LANGUAGE_LOG
     sprintf(s,"%s/etc/errlog/%s",ZOPT.OPT->HOME,LANGUAGE_ERR_LOG);
     if ((fd=fopen(s,"a"))!=NULL)
     {
       if (i==0) fprintf(fd,"%s: %d text (%s) %s %s\n",mydate(1),ZOPT.OPT->USER.language, nam,VERSION,PATCHLEVEL);
       	else     fprintf(fd,"%s: %d char (%s) %s %s\n",mydate(1),ZOPT.OPT->USER.language, nam,VERSION,PATCHLEVEL);
       fclose(fd);
     }
#endif
}




/* liefert Anzahl der Sprachen */
int GetMaxLanguage()
{
 FILE *fd;
 char s[2*STRING];
 int sum=0;


sprintf(s,"%s/etc/list.languages",ZOPT.OPT->HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  while ((fgets(s,2*STRING,fd)!=NULL) && (strpos("======",s)==NULL)) ;
  while ((fgets(s,2*STRING,fd)!=NULL) )
    if (
          (strlen((char *) cut_bef(s))>0)      &&
          (strlen((char *) cut_arg(s))>0)
      )  
       sum++ ;
  fclose(fd);
  if (sum<1) 
  {
    nerror("language.c", 445, "tbbs: GetMaxLanguages() failed, invaild list.languages!", 
      "system: no language!", 
      "language is missing!");
      exit(-8);
  } else
    return(sum);

} else 
{
  nerror("language.c", 442, "tbbs: GetMaxLanguages() failed, invaild installation?", 
      "system: Can't open languages-support-files", 
      s);
      exit(-6);
 }
}







/* liefert Name oder Beschreibung der Sprache zurueck */
/* no	:  	Nummer der Sprache 
   mode	:  	0 -> filename
   		1 -> beschreibung
*/   	
char *GetLangName(no,mode)
int no, mode;
{
FILE *fd;
static char s[2*STRING],tmp[STRING];
int sum=0;

if (!no) no=1;

sprintf(s,"%s/etc/list.languages",ZOPT.OPT->HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  while ((fgets(s,2*STRING,fd)!=NULL) && (strpos("======",s)==NULL)) ;
  while ((fgets(s,2*STRING,fd)!=NULL) )
    {
      if ((strlen((char *) cut_bef(s))>0)&&(strlen((char *) cut_arg(s))>0))  sum++ ;
      if (sum==no) 
      {
        fclose(fd);
        if (!mode) {
         strcpy(tmp,(char *) strings(cut_bef(s)));   
         sum=0;
         while (sum<STRING) 
          {
           if (tmp[sum]==SPACE) tmp[sum]=0;
           sum++;
          }     
         
        } else
         strcpy(tmp,(char *) cut_arg(s));
        return( (char *) tmp);
      }      
    }  
  fclose(fd);
  nerror("language.c", 495, "tbbs: GetLangName() failed, invaild language!", 
      "system: no language!", 
      "language is missing!");
      exit(-12);
} else
  nerror("language.c", 500, "tbbs: GetLangName() failed, no language-support!", 
      "system: no language!", 
      s);
}