/* 
 * Prints the text given on the command line as a 4 line banner.  If no text
 * is given on the command line, it runs as a filter instead, reading input
 * from stdin and printing the banner to stdout.  Lines exceeding 80 columns
 * will be automatically wrapped, breaking arbitrarily between characters.
 * Some kerning is done, and there is a weak attempt to put extra space between
 * characters that might run together if printed too close together.
 */

#include <stdio.h>
#include <ctype.h>

#define SPACES	4	/* spaces to leave for a space */
#define LINELEN	79	/* maximum output line length */
#define CHEIGHT	4	/* height of characters not including decenders */
			/* ...just changing CHEIGHT won't work */

struct{
	char ch;
	char *line[CHEIGHT+1];
	} font[]= {

       {'A',
       {"  __",
	" /  \\",
	"| () |",
	"|_||_|",
	""}},

       {'B',
       {" ____",
	"| __ \\",
	"| __ (",
	"|____/",
	""}},

       {'C',
       {"  ____",
	" /  __)",
	"(  (__",
	" \\____)",
	""}},

       {'D',
       {" ____",
	"|  _ \\",
	"| |_) )",
	"|____/",
	""}},

       {'E',
       {" ____",
	"| ___)",
	"| _)_",
	"|____)",
	""}},

       {'F',
       {" ____",
	"| ___)",
	"| __)",
	"|_|",
	""}},

       {'G',
       {"  ____",
	" /  __)",
	"(  (_  )",
	" \\____/",
	""}},

       {'H',
       {" _   _",
	"| |_| |",
	"|  _  |",
	"|_| |_|",
	""}},

       {'I',
       {" ___",
	"(   )",
	" | |",
	"(___)",
	""}},

       {'J',
       {"    _",
	" _ | |",
	"( )| |",
	" \\__/",
	""}},

       {'K',
       {" _  __",
	"| |/ /",
	"|   (",
	"|_|\\_\\",
	""}},

       {'L',
       {" _",
	"| |",
	"| |__",
	"|____)",
	""}},

       {'M',
       {" _    _",
	"| \\  / |",
	"| \\\\// |",
	"|_|\\/|_|",
	""}},

       {'N',
       {" _  _",
	"| \\| |",
	"| \\\\ |",
	"|_|\\_|",
	""}},

       {'O',
       {"  ___",
	" / _ \\",
	"( (_) )",
	" \\___/",
	""}},

       {'P',
       {" ____",
	"| __ \\",
	"|  __/",
	"|_|",
	""}},

       {'Q',
       {"  ___",
	" / _ \\",
	"( (_) )",
	" \\__\\\\",
	""}},

       {'R',
       {" ____",
	"| __ \\",
	"|    /",
	"|_|\\_\\",
	""}},

       {'S',
       {" ____",
	"/ ___)",
	"\\___ \\",
	"(____/",
	""}},

       {'T',
       {" _____",
	"(_   _)",
	"  | |",
	"  |_|",
	""}},

       {'U',
       {" _  _",
	"| || |",
	"| || |",
	" \\__/",
	""}},

       {'V',
       {"__  __",
	"\\ \\/ /",
	" \\  /",
	"  \\/",
	""}},

       {'W',
       {" _      _",
	"( )    ( )",
	" \\ \\()/ /",
	"  \\_/\\_/",
	""}},

       {'X',
       {"__  __",
	"\\ \\/ /",
	" )  (",
	"/_/\\_\\",
	""}},

       {'Y',
       {"__  __",
	"\\ \\/ /",
	" \\  /",
	" /_/",
	""}},

       {'Z',
       {" _____",
	"(__  /",
	"  / /_",
	" /____)",
	""}},

       {'0',
       {"  ___",
	" /   \\",
	"(  |  )",
	" \\___/",
	""}},

       {'1',
       {" __",
	"/  |",
	" | |",
	"(___)",
	""}},

       {'2',
       {" ____",
	"(___ \\",
	" / __/",
	"/____)",
	""}},

       {'3',
       {" ____",
	"(___ \\",
	" _(_ (",
	"(____/",
	""}},

       {'4',
       {"  ___",
	" / _ |",
	"/__   )",
	"   |_|",
	""}},

       {'5',
       {" ____",
	"| ___)",
	"|___ \\",
	"(____/",
	""}},

       {'6',
       {"  ___",
	" / __)",
	"(  _ \\",
	" \\___/",
	""}},

       {'7',
       {" _____",
	"(__  / ",
	"  / /",
	" /_/",
	""}},

       {'8',
       {" ___",
	"/ _ \\",
	") _ (",
	"\\___/",
	""}},

       {'9',
       {" ___",
	"/ _ \\",
	"\\__  )",
	"(___/",
	""}},

       {'\047',
       {" _",
	"(_)",
	" /",
	"",
	""}},

       {';',
       {"",
	" _",
	"(_)",
	"(_)",
	" /"}},

       {',',
       {"",
	"",
	" _",
	"(_)",
	" /"}},

       {'`',
       {" _",
	"(_)",
	" \\",
	"",
	""}},

       {'"',
       {" _ _",
	"(_(_)",
	" / /",
	"",
	""}},

       {'-',
       {"",
	" ___",
	"(___)",
	"",
	""}},

       {'_',
       {"",
	"",
	" ___",
	"(___)",
	""}},

       {'.',
       {"",
	"",
	" _",
	"(_)",
	""}},

       {'/',
       {"   __",
	"  / /",
	" / /",
	"/_/",
	""}},

       {'\\',
       {"__",
	"\\ \\",
	" \\ \\",
	"  \\_\\",
	""}},

       {'|',
       {" _",
	"| |",
	"| |",
	"|_|",
	""}},

       {':',
       {"",
	" _",
	"(_)",
	"(_)",
	""}},

       {'(',
       {"  __",
	" / /",
	"( (",
	" \\_\\",
	""}},

       {')',
       {"__  ",
	"\\ \\",
	" ) )",
	"/_/",
	""}},

       {'!',
       {" _",
	"| |",
	"|_|",
	"(_)",
	""}},

       {'?',
       {" ___",
	"(__ \\",
	" |__/",
	" (_)",
	""}},

       {'%',
       {" _  __",
	"(_)/ /",
	"  / /_",
	" /_/(_)",
	""}},

       {'&',
       {"  _",
	" ( )",
	"/  \\_",
	"\\___(",
	""}},

       {'^',
       {"",
	" /\\",
	"//\\\\",
	"",
	""}},

       {'=',
       {"",
	" ___",
	"(___)",
	"(___)",
	""}},

       {'+',
       {"   _",
	" _| |_",
	"(_   _)",
	"  |_|",
	""}},

       {'[',
       {" _",
	"| )",
	"||",
	"|_)",
	""}},

       {']',
       {" _",
	"( |",
	" ||",
	"(_|",
	""}},

       {'{',
       {"  _",
	" | /",
	"< (",
	" |_\\",
	""}},

       {'}',
       {" _",
	"\\ |",
	" ) >",
	"/_|",
	""}},

       {'$',
       {" _.._",
	"/ ||_)",
	"\\_|| \\",
	"(_||_/",
	""}},

       {'*',
       {" __  __",
	" \\ \\/ /",
	"(_    _)",
	" /_/\\_\\",
	""}},

       {'@',
       {"  ___",
	" / __\\",
	"( (o(_)",
	" \\___/",
	""}},

       {'~',
       {"",
	"  _",
	" /_\\_/)",
	"(/ \\_/",
	""}}, 

       {'>',
       {"__",
	"\\ \\",
	" > >",
	"/_/",
	""}},

       {'<',
       {"  __",
	" / /",
	"< <",
	" \\_\\",
	""}},

       /* This marks the end of the character table */

       {'\0',
       {NULL,
	NULL,
	NULL,
	NULL,
	NULL}}
	};

main(argc,argv)
int argc;
char **argv;
{
char dave[256];
int i;

	if (argc == 1)
	{
		while(fgets(dave,255,stdin) != NULL)
			kite(dave);
	}
	else
	{
		dave[0]= '\0';
		for (i=1; i < argc; i++)
		{
			strcat(dave,argv[i]);
			if (i != argc-1)
				strcat(dave," ");
		}
		kite(dave);
	}
}

char buf[CHEIGHT+1][LINELEN+1]; /* output buffer */
int i[CHEIGHT+1];		/* indexes into the output buffer lines */
int printlast;			/* should we print descender line? */

kite(s)
char *s;
{
int j,k,n;
char chr,chl;
int pad;
int l[CHEIGHT+1];
int f[CHEIGHT+1],minstart;

	i[0]= i[1]= i[2]= i[3]= i[4]= 0;
	printlast= 0;

	for (;*s != '\0'; s++)
	{
		/* Process spaces */
		if (*s == ' ' || *s == '\t')
		{
			if (makeroom(SPACES,SPACES,SPACES,SPACES,SPACES))
			{
				for(j=0; j<SPACES; j++)
				{
					buf[0][i[0]++]= ' ';
					buf[1][i[1]++]= ' ';
					buf[2][i[2]++]= ' ';
					buf[3][i[3]++]= ' ';
					buf[4][i[4]++]= ' ';
				}
			}
		}

		/* Convert to upper case */
		if (islower(*s)) *s= toupper(*s);

		/* Find the character in the font table */
		for (n=0; (font[n].ch != '\0') && (font[n].ch != *s); n++)
			;
		if (font[n].ch == '\0')
			continue;
		
		/* Find leftmost non-overlapping position for next char */
		minstart= 0;
		for (j= 0; j < CHEIGHT+1; j++)
		{
			l[j]= strlen(font[n].line[j]);

			f[j]= first(font[n].line[j]);
			if (f[j] != -1 && i[j]-f[j] > minstart)
				minstart= i[j]-f[j];
		}

		/* See if we need an extra space to keep the letters apart */
		pad= 0;
		for (j= 0; j < CHEIGHT+1; j++)
		{
			if (f[j] != -1)
			{
				if (minstart+f[j] > i[j] ||
				    minstart+f[j] <= 0) continue;
				chl= buf[j][minstart+f[j]-1];
				chr= font[n].line[j][f[j]];
				if (chl != ' ' && chl != ')' &&
				    chr != ' ' && chr != '(') pad= 1;
			}
		}
		minstart += pad;

		/* Make sure we have room for the letter */
		if (!makeroom(minstart-i[0]+l[0],
		              minstart-i[1]+l[1],
		              minstart-i[2]+l[2],
		              minstart-i[3]+l[3],
		              minstart-i[4]+l[4]))
			minstart=0;
		
		/* Store the letter */
		for (j= 0; j < CHEIGHT+1; j++)
		{
			for (k= i[j]; k < minstart; k++)
				buf[j][k]= ' ';

			for (k= 0; k < l[j]; k++)
			{
				if (font[n].line[j][k] != ' ' ||
				    minstart+k >= i[j])
				{
					buf[j][minstart+k]= font[n].line[j][k];
					if (j==4 && font[n].line[j][k] != ' ')
						printlast= 1;
				}
			}
			if (minstart+l[j] > i[j])
				i[j]= minstart+l[j];
		}
	}
	printbuf();
}

int first(s)
char *s;
{
int i;
	for (i= 0; s[i] != '\0'; i++)
		if (s[i] != ' ') return(i);
	return(-1);
}

makeroom(s0,s1,s2,s3,s4)
int s0,s1,s2,s3,s4;
{
	if ( i[0]+s0 > LINELEN-1 || i[1]+s1 > LINELEN-1 ||
	     i[2]+s2 > LINELEN-1 || i[3]+s3 > LINELEN-1 || i[4]+s4 > LINELEN-1)
	{
		printbuf();
		return(0);
	}
	return(1);
}

printbuf()
{
int j;
	for (j= 0; j < CHEIGHT+printlast; j++)
	{
		buf[j][i[j]]= '\0';
		puts(buf[j]);
		i[j]= 0;
	}
	printlast= 0;
}


