

#ifdef _SYS7	/* UNIX System 7  (MINIX, COHERENT, ...) */

#include  <sgtty.h>
static struct tchars newtc, oldtc;

#else		/* UNIX System V  (UNIX, XENIX, ESIX, ...) */

#ifdef _LINUX
#include  <termio.h>
#else
#ifndef _NETBSD
#include  <sys/termio.h> 
#endif
#endif

static struct termio newtc, oldtc;

#endif

#include <sys/ioctl.h>

/* #CX - If user sends CTRL-X, UNIX receives SIGQUIT. */

void ctrlx()
{


#ifdef _SYS7

  ioctl(0, TIOCGETC, (struct sgttyb *) &oldtc);
  newtc = oldtc;
  newtc.t_quitc = 24;
  ioctl(0, TIOCSETC, (struct sgttyb *) &newtc);

#else

  ioctl(0, TCGETA, (struct termio *) &oldtc);
  newtc = oldtc;
  newtc.c_cc[VQUIT] = 24; 
  ioctl(0, TCSETA, (struct termio *) &newtc);
 
#endif

}




/* #NX - Restore SIGQUIT. */

void noctrlx()
{
#ifdef _SYS7

  ioctl(0, TIOCSETC, (struct sgttyb *) &oldtc);

#else

  ioctl(0, TCSETA, (struct termio *) &oldtc);

#endif

}
