#define __MBD

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <dirent.h>
/*#include <stdlib.h>*/

#include "mbox.h"
#define N_OPT
#include "s_global.h"

struct GLOBAL_OPT_TYP OPT;
#include "config.h"
int ALL;

#undef NOCLEANTMP
#include "mbd.h"
int do_list=0;

UNSIGNED char tmp[STRING], _TO[STRING],_FROM[STRING];
UNSIGNED char alias[MAX_XMD_ALIAS][2][STRING];
UNSIGNED char x400[STRING],ERR_MBOX[STRING],ADMIN[STRING],_SUBJECT[STRING];
UNSIGNED char PIPE_RECEIVER[STRING],SYSTEM[STRING],ALIAS_FROM[STRING];
int INTERACT;
int maillogsize;



/* #ET - Calculates the delivering time out of a "Date:" header line [hd].

   This function returns a "X-Delivering-Time:" header line. */

UNSIGNED char *elapsed_time( hd )
UNSIGNED char hd[];
{
  UNSIGNED char tag[STRING];
  UNSIGNED char monat[STRING];
  UNSIGNED char jahr[STRING];
  UNSIGNED char zeit[STRING];
  UNSIGNED char zone[STRING];

static  UNSIGNED char s[2*STRING];
static  UNSIGNED char t[STRING];
 
  UNSIGNED char mon[12][4];

  UNSIGNED char tzcode[STRING];
  UNSIGNED char tzfact[STRING];
  UNSIGNED char tzname[STRING];

  int i = 0, a = 0;

  long ljahr, lzeit;
  long njahr, nzeit;

  FILE *fp;


  strcpy(mon[ 1], "Jan");
  strcpy(mon[ 2], "Feb");
  strcpy(mon[ 3], "Mar");
  strcpy(mon[ 4], "Apr");
  strcpy(mon[ 5], "May");
  strcpy(mon[ 6], "Jun");
  strcpy(mon[ 7], "Jul");
  strcpy(mon[ 8], "Aug");
  strcpy(mon[ 9], "Sep");
  strcpy(mon[10], "Oct");
  strcpy(mon[11], "Nov");
  strcpy(mon[12], "Dec");

  while((a == 0) && (hd[i] != 0)){
	if((hd[i] >= '0') && (hd[i] <= '9')) a = i;
	i++;
  }

  strcpy(s, (UNSIGNED char *) strcopy(hd, a, (strlen(hd))));

  sscanf(s, "%s %s %s %s %s", tag, monat, jahr, zeit, zone);
 
  for(i = 1; i <= 12; i++){
	if(strcomp(mon[i], monat) == 0) a = i;
  }

  sprintf(s, "%02.2d.%02.2d.%02.2d", atoi(tag), a, atoi(jahr));
  ljahr = dateconv( (UNSIGNED char *) s );

  lzeit = (long) (atol( strcopy(zeit, 0, 1) ) * 60) + (atol(strcopy(zeit, 3, 4)));
  
  strcpy(s, (UNSIGNED char *) mydate( 0 ));
  njahr = dateconv( (UNSIGNED char *) s );

  strcpy(s, (UNSIGNED char *) mytime( 0 ));
  nzeit = (long) (atol( strcopy(s, 0, 1) ) * 60) + (atol(strcopy(s, 3, 4)));

  if((zone[1] >= '0') && (zone[1] <= '9')){     /* +0500, -0100, ...  */
	strcpy(tzfact, (UNSIGNED char *) zone);
	tzname[0] = 0;
  }
  else{						/* GMT, CET, EET, ... */
        sprintf(s,"%s/%s",HOME,TIMEZONES);
	fp = fopen( s, "r" );
	if(fp == NULL){
		sprintf(t, "XMD-FILE-NOT-FOUND: %s\n", (UNSIGNED char *) s);
		return (UNSIGNED char *) t;
	}
	while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));
	while(fgets(s, STRING, fp) != NULL){
		sscanf(s, "%s", t);
		if(strcomp(zone, t) == 0){
			sscanf(s, "%s %s", tzcode, tzfact);	
			strcpy(tzname, (UNSIGNED char *) stripped(strcopy(s, 19, strlen(s))));
		}
	}
	fclose(fp);
  }

  strcpy(s, (UNSIGNED char *) GMT_DIFF);	
  if(s[0] == '-'){
	s[0] = ' ';
	nzeit += (long) (atol(s) * 60 / 100); 
  }
  else{
	s[0] = ' ';
	nzeit -= (long) (atol(s) * 60 / 100); 
  }
  
  if(tzfact[0] == '-'){
  	tzfact[0] = ' ';
	lzeit += (long) (atol(tzfact) * 60 / 100); 
  }
  else{
	tzfact[0] = ' ';
	lzeit -= (long) (atol(tzfact) * 60 / 100); 
  }
  
  njahr -= ljahr; 

  if(njahr > 30){
	njahr -= 70;	
  }
  if(njahr > 30){
	return( (UNSIGNED char *) "X-Delivering-Time: Not able to calculate!\n" );
  }

  nzeit -= lzeit;
  
  if(nzeit < 0){
	nzeit += (24 * 60);
	njahr -= 1;
  }

  if(njahr > 0){
	sprintf(s, "X-Delivering-Time: %ld day(s), %ld hour(s) and %ld minute(s)",
		  (long) njahr, 
		  (long) (nzeit / 60), 
		  (long) (nzeit - ((nzeit / 60) * 60)));
  }
  else{
	sprintf(s, "X-Delivering-Time: %ld hour(s) and %ld minute(s)",
		  (long) (nzeit / 60), 
		  (long) (nzeit - ((nzeit / 60) * 60)));	
  }

  if(tzname[0] != 0){
	sprintf(t, "; %s", tzname);
	strcat(s, t);
  }

  strcat(s, "\n");


  return (UNSIGNED char *) s;
}



void log_it( s1, s2, s3 )
UNSIGNED char s1[], s2[], s3[];
{
  FILE *ff;
  char t[STRING];


  ff = fopen( XMDLOG, "a" );
  if(ff == NULL){
	printf("\nCan't open %s\n", XMDLOG);
	return;
  }
  fprintf(ff, "%5.5s  %5.5s > %-29.29s   [%s %s]\n",
	(UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
        (UNSIGNED char *) s1, s2, s3);
  fclose(ff);
      
}



unsigned char *punkt2leer(s)
unsigned char s[];
{
   static unsigned char b[STRING];
   int j,k = 0 ;
    
   for (j=0;j<=(strlen(s));j++)
   {
     b[j]=s[j];
      if (b[j]==46) b[j]=32;
   }
   b[j]=0;
       
   return (UNSIGNED char *) (b);
}
         
         







void err(msg)
char *msg;
{
printf("\nfailure: Can't chown %d.%d file:(%s)\n",GUEST_GID,GUEST_GID,msg);
}



/* Position eines Strings in einem anderen -> strpos alias PAS */
int strpos(s, t)
UNSIGNED char s[], t[];
{
  int j=0, i = 0, a = 0;


  while (t[i] != 0) {
	j=0;
	if (t[i] == s[0]){
	    a=i+1;
	    while ((s[j]==t[i])&&(s[j]!=0)) {
	       j++; i++;
	     }
	    if (s[j]==0) return (int) a ; else a='0';
	 }
	i++;
  }

  return (int) NULL;
}




/* ++++++++++++++++++++++  Globale ZCFG lesen ++++++++++++++++++ */
void SetZMain()
{
FILE *fd;
unsigned char t[STRING];
char s[STRING],*env;
int i,j;


strcpy(s,(char *) sstrings(GRead("mailsize")));
maillogsize= atoi(s);


strcpy(s,(char *) sstrings(GRead("log.mail")));
if (strpos("on",s)==NULL) maillogsize=0;



}




main(argc, argv)
int argc;
unsigned char *argv[];
{
 umask(0000);
 if (getuid()!=GUEST_GID)  do_list=1; 
 setgid(GUEST_GID);
 setuid(GUEST_GID);
 if ((getuid()!=GUEST_GID)||(getgid()!=GUEST_GID))   
 {
   printf("\n\7you have no execute-permission!\n");
   exit(-1);
 }   

 SetMain();
 SetZMain();
 chdir(HOME);
 do_check();
/* sleep(5);*/
 do_spool();
      
}

            
            
            
            
void  do_spool()
{
char s[2*STRING];
DIR *dp;
struct dirent *actdir;
int i;
                
sprintf(s,"%s/spool/mail",HOME);
dp=opendir(s);
for (i=0;i<2;i++) readdir(dp);
while ((actdir = readdir(dp)) != NULL)
{
  if (do_list) printf("\n%s", actdir->d_name);
  chdir(HOME);
  chdir("spool/mail");                  
  do_mail(actdir->d_name);
  chdir(HOME);
  chdir("spool/mail");                    
  unlink( actdir->d_name);
}
closedir(dp);

}


               
               
void do_mail(mail)
char *mail;
{
char rec_char[STRING];
int fd;
int i, a, b;
int ok=0,rec=0,rec_id=0;
struct userdaten LOOSER;
char s[2*STRING];

  
strcpy(s,mail);
s[strpos("#",mail)-1]=0;
strcpy(rec_char,(char *) punkt2leer(s));


  rec=0;
  sprintf(s,"%s/%s",HOME,UDBASE);
  fd = open(s, O_RDONLY);
  if (fd == -1) {
	printf("\nCan't read %s\n", UDBASE);
	exit(-1);
  }
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) ) 
  {
	if (strpos((char *) rec_char, (char *) LOOSER.name) ==1) 
	{
		rec_id = LOOSER.id;
	}
  }
  close(fd);
/*  printf(" %d",rec_id); */
  if (!rec_id) 
  {
    printf("\nCan't find Receipt of Mail, sorry\n");
    exit(-3);
  }
  MailTo(mail,rec_char,rec_id);
}               



int MailTo(mail,rec_char,rec_id)
char *mail, *rec_char;
int rec_id;
{
FILE *fp;
FILE *ff;
struct tm *timeptr;
time_t timer;
int  mail_id;
int local   = 0;
int i, a, b;
int arrived = 1;
int lines   = 0;  
   
char s[2*STRING];
UNSIGNED char t[2*STRING],stt[STRING];
UNSIGNED char subject[STRING];
UNSIGNED char autor[STRING];
char tt[STRING];
UNSIGNED char ex[LONGSTRING];
UNSIGNED char user[STRING],zautor[STRING];
UNSIGNED char destination[STRING];
UNSIGNED char receipt[STRING];
char *ttt;
                      
                
strcpy(_TO,rec_char);            
strcpy(subject, XMD01_MSG);
/*printf("\n -> MailTo(%s,%s,%d)\n",mail,rec_char,rec_id);*/
  
  sprintf(stt, "%s/usr/%c/%d/seq", HOME, rec_char[0],rec_id);
  maybe_locked(stt, "r"); mblock( stt ); 
	sprintf(t, "%s/usr/%c/%d/seq", HOME, rec_char[0], rec_id);
	fp = fopen(t, "r");
	if(fp == NULL){
		log_it( "Can't read:", t, "!" );
		err_brief(0,mail);
		return(-3);
	}
  fgets(s, STRING, fp);
  mail_id = atoi( s );
  if (do_list) printf(" msg-nr:%d ",mail_id);
  fclose(fp);

  fp = fopen(t, "w");
  if(fp == NULL){
	log_it( "Can't write to:", t, "!" );
  }
  fprintf(fp, "%d\n", (int) (mail_id + 1));
  fclose(fp);
      



  sprintf(destination, "%s/usr/%c/%d/%d", HOME, rec_char[0], rec_id, mail_id);

  fp = fopen(destination, "w");
  if(fp == NULL){
	log_it( "Can't write to:", destination, "!" );
	printf("\nCan't write to %s\n", destination);
	return(-1);
  }
       
      
      

  sprintf(s, "%s %s (%s)\n", GBL01_MSG, X_MAIL_DEMON, "xmd");
  fputs(s, fp);

  time(&timer);
  timeptr = localtime(&timer);
  strcpy(t, (UNSIGNED char *) asctime(timeptr));

  sprintf(s, "%s %s", GBL02_MSG, t);
  fputs(s, fp);

  sprintf(s, "%s %s\n\n", GBL03_MSG, subject);
  fputs(s, fp);

  fprintf(fp, "%s\n\n", XMD02_MSG);

  lines = 7;

  autor[0] = 0;
  subject[0] = 0;

  ff = fopen(mail, "r");
  if (ff == NULL) {
	return;
  }
  autor[0]=0;
  while (fgets(s, STRING, ff) != NULL) {
	i = 0;
	s[STRING-1]=0;
	
	if(strpos("*From ", s) == 1){
		strcpy(s, (UNSIGNED char *) stripped(strcopy(s, 1, STRING)));

		strcat(s, "\n");
	}
	if(strcomp("Date: ", s) == 0){
		fputs((char *) elapsed_time( s ), fp);
	}
	fputs(s, fp);
	lines++;
	if((strcomp("Subject: ", s) == 0) && (subject[0] == 0)){
		strcpy(subject, (UNSIGNED char *) stripped(strcopy(s, 9, STRING)));
	}
	
	if (strpos("From: ", s) == 1) 
	{
	        if ((1)||(autor[0]==0))
	        {
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
		local = 0;
		}
	} 
	if(strpos("From ", s) == 1){
	        if (autor[0]==0)
	        {
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 5, STRING)));
		strcpy(_FROM,autor);
		local = 1;
		}
	} 
	if(strpos("*From ", s) == 1){
	        if (autor[0]==0)
	        {
		strcpy(autor, (UNSIGNED char *) stripped(strcopy(s, 6, STRING)));
		local = 1;
		}
	}
  }
  fclose(ff);
  fclose(fp);
  
  i = 0; 
  while(autor[i] != 0){
	if(autor[i] == '(') autor[(i-1)] = 0;
	i++;
  }

  if(autor[0] == '"'){
	i = 1;
	while((autor[i] != '"') && (autor[i] != 0)){
		i++;
	}
	i--;
	strcpy(autor, (UNSIGNED char *) strcopy(autor, 1, i));
  }

  if((local == 1) && (strcomp("postmaster", autor) == 0)){
	fclose(fp);
	unlink(destination);
	if(INTERACT == 0) printf("[%s]\n", rec_char);
	fp = fopen( XMDLOG, "a" );
	if(fp == NULL){
		printf("\nCan't append to %s\n", XMDLOG);
		return;
	}
	fprintf(fp, "%-29.29s   %33.33s\n", (UNSIGNED char *) stripped(rec_char), subject);
	fclose(fp);
	    
	    
	return;
  }

 sprintf(s, "%s/usr/%c/%d/INDEX", HOME, rec_char[0], rec_id);

  fp = fopen(s, "a");
  if(fp == NULL){
	log_it( "Can't append to:", s, "!" );
 	err_brief(2,mail);
 	exit(0);
	return;
  }

  sprintf(s, "%d              ", mail_id);
  s[6] = 0;
  fputs(s, fp);

  sprintf(ex, "%s                                  ", subject);
  ex[26] = 0;
  fputs(ex, fp);

  sprintf(ex, "  %s                                        ", autor);
  ex[22] = 0;
  fputs(ex, fp);


  strcpy(s, (UNSIGNED char *) mydate(1));
  strcpy(t, (UNSIGNED char *) mytime(1));
  sprintf(ex, "  %s  %s         ", s, t);
  ex[19] = 0;
  fputs(ex, fp);
  sprintf(s, "%s\n", LE215_MSG);
  fputs(s, fp);

  fclose(fp);
  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, rec_char[0], rec_id);

  sprintf(stt, "%s/usr/%c/%d/seq", HOME, rec_char[0],rec_id);
  mbunlock(stt);


  ff = fopen( XMDLOG, "a" );
  if(ff == NULL){
	printf("\nCan't append to %s\n", XMDLOG);
	return;
  }
  fprintf(ff, "%5.5s  %5.5s   %-29.29s   %-31.31s\n", 
	  (UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
	  (UNSIGNED char *) stripped(rec_char), subject);
  fclose(ff);

  if(receipt[0] != 0){
	i = 0; b = 0;
	while(receipt[i] != 0){
		if(receipt[i] == '!') b = i;
		if(receipt[i] == '@') b = i;
		i++;
	}
	if(b == 0) return;
 	i = b; a = 0;
	while((i > 0) && (a == 0)){
		if((receipt[i] == ' ') ||
		   (receipt[i] == '<') ||
		   (receipt[i] == '(')) a = i + 1;
		i--;
	}
  	i = b; b = 0;
 	while((receipt[i] != 0) && (b == 0)){
		if((receipt[i] == ' ') ||
		   (receipt[i] == '>') ||
		   (receipt[i] == ')')) b = i -1;
		i++;
	}
	if(b == 0) b = i -1;
 	strcpy(receipt, (UNSIGNED char *) strcopy(receipt, a, b));

	sprintf(t, "%s/tmp/%d.REC", HOME, getpid());
	ff = fopen( t, "w" );	
	if(ff == NULL){
		log_it( "Can't write to:", t, "!" );
		printf("\nCan't write to %s\n", t);
  	}

	time(&timer);

	fprintf(ff, "From: XMD@%s\n", UUCPID2); 
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	fprintf(ff, "To: %s\n", receipt);
	fprintf(ff, "Subject: mail delivering report\n");
	fprintf(ff, "X-Mailer: %s %s b\n", VERSION, PATCHLEVEL);	
	fprintf(ff, "Message-Id: <%x.xmd@%s>\n", timer, UUCPID2);
	fputs("\n", ff);

	fprintf(ff, "%s, %s at %s\n\n", LOCATION, mydate( 1 ), mytime( 1 ));

	fprintf(ff, "Your mail \"%s\" ...\n", subject);
	if(arrived == 1){
		fprintf(ff, "... reached %s.\n\nBye for now!\n", (UNSIGNED char *) stripped(rec_char));
	}
	else{
		fprintf(ff, "... couldn't be delivered to %s.\n\n", (UNSIGNED char *) stripped(rec_char));
		fprintf(ff, "The local postmaster got a copy of your mail! Maybe he is able to forward it\nto the correct receipient!\n\n");
	}
	fclose(ff);

	RMailTo(mail,"bbs",receipt);
	unlink( t );
  }
  sprintf(t, "%s/usr/%c/%d/seq", HOME, rec_char[0],rec_id);
  mbunlock(t);

}



unsigned char *cut_bef(s)
unsigned char s[];
{
static unsigned char bef[STRING];
int i = 0;
    
    
while (s[i] > 32) {
   bef[i] = s[i];
   i++;
 }
 bef[i] = 0;
 return (unsigned char *) bef;
}
                     



unsigned char *leer2punkt(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==32) b[j]=46;
}
 b[j]=0;
  	     
  return (UNSIGNED char *) (b);
}







/* #BR - ERR-Mail to a ext.user [arg]. */

err_brief(mode,mail)
int mode;
char *mail;
/* modes :
 	0 	-> bbs-user unknown 
 	
*/
{
  FILE *fp;
  FILE *fd,*ff;
  time_t timer,k;
  int ffd;


  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char autor[STRING];
  UNSIGNED char rec_char[STRING];
  struct userdaten LOOSER;

  int receiver,i;


  chdir(HOME);





	time(&timer); k=time(0);
        sprintf(s,"%s/tmp/errmail.%d",HOME,getpid());
        if ((ff=fopen(s,"w"))==NULL)
        {
          printf("\nCan't write to (%s)\n",s);      
          exit(-1);
        }        
        
        sprintf(s,"%s/etc/log/bbsmail.error.log",HOME);
        if ((fp=fopen(s,"a"))==NULL)
        {
          printf("\nCan't append to (%s)\n",s);      
          exit(-1);
        }        
        if (mode!=5)
        {
	 fprintf(ff, "From: %s@%s (postmaster@%s)\n", "Administration" /*ADMIN*/,UUCPID2,UUCPID2);
	} else
	{  /* message is looping */
	 fprintf(ff, "From: TBBS_MAILER-DAEMON@%s\n",UUCPID2);
	}
	fprintf(ff, "Sender: T-BBS_MAILER-DAEMON@%s\n", UUCPID2); 
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	
	
	
	if (mode!=5) 
	{
	 fprintf(ff, "To: %s\n", cut_bef(_FROM));
 	 fprintf(ff, "Cc: %s\n", ZPOSTMASTER);	 
	} else
	{
 	 fprintf(ff, "To: %s\n", ZPOSTMASTER);
	}
	
	
	if (mode!=5)
	 fprintf(ff, "Subject: %s\n",BBSMD01_MSG);
	else fprintf(ff, "Subject: %s\n",BBSMD01a_MSG);
	fprintf(ff, "X-Mailer: xmd %s <%s>\n", VERSION,  AUTOR2);	
    if (!gethostname(&s[0],STRING))
    {
     k=time(0);
     fprintf(ff,"Received: by \"%s\"  %s \nMessage-ID: <%d.%d-tbbs@%s>\n\n",
       s,BBSMD_VERSION,getpid(),k,UUCPID2);
    }
	
	fputs("\n", ff);

switch (mode)
{
    case 0: /* keine User-Pfad */
       fprintf(ff, "%s\n%s\n%s\n \"%s\"",BBSMD03_MSG, BBSMD03a_MSG,BBSMD04_MSG,_TO);
       fprintf(ff, " %s \"%s@%s\")\n%s\n\n\n", 
        BBSMD04a_MSG,"Administration"/*leer2punkt(ADMIN)*/,UUCPID2,BBSMD05_MSG);
       break;
    case 2:  /* internel -error (permission) */
       fprintf(ff, "%s\n%s\n%s\n",BBSMD03_MSG, BBSMD03c_MSG,BBSMD05_MSG);
       break;       
    case 3:  /* user not found */
       fprintf(ff, "%s\n%s\n%s\n \"%s\"",BBSMD03_MSG, BBSMD03a_MSG,BBSMD04_MSG,_TO);
       fprintf(ff, " %s \"%s@%s\")\n%s\n\n\n", 
        BBSMD04x_MSG,leer2punkt(ADMIN),UUCPID2,BBSMD05_MSG);       
       break;      
    case 5:  /* Mail ist LOOPING */
       fprintf(ff, "%s\n%s\n%s\n%s@%s:\n\"%s\"\n%s",BBSMD03_MSG, BBSMD03e_MSG,BBSMD04_MSG,
        leer2punkt(ADMIN),UUCPID2,_TO,BBSMD04e_MSG);
       fprintf(ff,"\n%s\n",BBSMD05_MSG);       
       break;             
}

        _FROM[0]=0; 
        sprintf(s,"%s/spool/mail/%s",HOME,mail); 
        fd=fopen(s,"r");
        while (fgets(s,STRING,fd)!=NULL)
        {
         if ((_FROM[0]==0)&&(strpos("From ",s)==1)) 
         {
              strcpy((char *) &_FROM, (char *) &s[5]);
         }     
         fprintf(ff,"%s",s);
        }
        
        for (i=0; i<20; i++) {
         if (_FROM[i]==SPACE) _FROM[i]=0;
        }
        
	fclose(ff); fclose(fd);
	
	
	sprintf(t,"%s/tmp/errmail.%d",HOME,getpid());
	ff=fopen(t,"r");
	fprintf(fp,"\n\n\n----------- snip ---------- snip ---------- snip ------------ snip -----\n");
	while (fgets(s,STRING,ff)!=NULL)
	{
	  s[STRING]=0;
    	  fprintf(fp,"%s",s);
	}
	fclose(fp); fclose(ff);
	
	
	if (mode!=5) /* !=LOOPING-MSG */
	{
         strcpy(s,ZPOSTMASTER);	 RMailTo(t,"bbs",(char *) s);
	 strcpy(s,_FROM);  RMailTo(t,"bbs",(char *) _FROM);
	} else
	{
	
	  RMailTo(t,"bbs",ZPOSTMASTER);
	}
	unlink(t);
        
}




int RMailTo(_s,from,rec_char)
unsigned char *_s,*from,*rec_char;
{
FILE *fd,*fp;
char s[2*STRING];


if (!(fd=fopen(_s,"r"))) return (0);
sprintf(s,"%s -F%s -f%s %s ", SYSTEM_MAIL,
	from,from,rec_char);
if ((fp = popen(s, "w")) == NULL)
{
 printf("\nxmd: Can't open pipe to Mailer (%s)!\n",SYSTEM_MAIL);
 return(-2);
}
while (fgets(s,STRING,fd)!=NULL) 
{
  s[STRING]=0;
  fprintf(fp,"%s",s);
}
pclose(fp);
fclose(fd);
return (1);                                                          

}





int TestPID(pid)
int pid;
{
char s[STRING];
struct stat fst;
int i;

sprintf(s,"/proc/%d",pid);
i=stat(s, &fst);
if (((fst.st_mode & S_IFMT)==S_IFDIR) && (i==0))
{
 return(1);
}
else return(0);

}



/* prueft, ob spooler schon laeuft, wenn ja, dann stop */
void do_check()
{
char s[2*STRING];
FILE *fd;
int i;

sprintf(s,"%s/etc/spool/bbs.spool.pid",HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  fgets(s,STRING/2,fd);
  i=atoi(s);
  fclose(fd);
  if (TestPID(i)==1) exit(0);  /* laeuft !!!! */
}
/*
Hidden();
setpgrp();
*/
fd=fopen(s,"w");
fprintf(fd,"%d\n",getpid());
fclose(fd);
}





void Hidden()
{
int temp;

while ((temp = fork()) < 0) sleep(1);
if (temp) exit(0);      /* not exit() !!! */
}





/* wandelt alle Zeilchen in Grossbuchstaben */
char *touppers(s)
char s[];
{
  static char b[STRING];
    int j = 0 ;
    
    for (j=0;j<=(strlen(s));j++)
    {
     b[j]=s[j];
      if ((b[j]>64)&&(b[j]<91)) b[j]=b[j]+32;
      }
       b[j]=0;
       
       
return ((char *) b);
}
         



unsigned char *cut_arg(s)
unsigned char s[];
{
  static unsigned char arg[STRING];
  int i = 0, a = 0;
  while (s[i] > 32) i++;
  if (s[i] == 0) return (unsigned char *) "";
  while (s[i] == 32) i++;
  while (s[i] != 0) {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = 0;
  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = 0;
  }
  return (unsigned char *) arg;
}
