include cpipe.e

procedure error()
    crash_message(sprintf("Errno = %d", os_errno))
    ? 1/0
end procedure

global function popen(sequence command, sequence args)
    atom pid
    sequence ipipe, opipe, epipe
    ipipe = {os_pipe()}
    opipe = {os_pipe()}
    epipe = {os_pipe()}
    if atom(ipipe[1]) then
	error()
    end if
    if atom(opipe[1]) then
	error()
    end if
    if atom(epipe[1]) then
	error()
    end if
    ipipe = ipipe[1]
    opipe = opipe[1]
    epipe = epipe[1]
    pid = os_fork()
    if pid = 0 then
	VOID = os_signal(15, os_sig_dfl) --15 = sigterm
	if os_dup2(ipipe[1], os_stdin) = -1 then
	    error()
	end if
	if os_dup2(opipe[2], os_stdout) = -1 then
	    error()
	end if
	if os_dup2(epipe[2], os_stderr) = -1 then
	    error()
	end if
	--if os_execv(command, args) then
	--this function is broken somehow, and for some reason this hack
	--seems to make it work just fine
	if os_execv(command, {"junk"}&args) then
	    error()
	end if
    elsif pid = -1 then
	error()
    end if
    return {pid, ipipe[2], opipe[1], epipe[1]}
end function

