include dll.e
include machine.e

constant STDLIB = open_dll("")
constant PIPE = define_c_func(STDLIB, "pipe", {C_POINTER}, C_INT)
constant READ = define_c_func(STDLIB, "read", {C_INT, C_POINTER, C_INT}, C_INT)
constant WRITE = define_c_func(STDLIB, "write", {C_INT, C_POINTER, C_INT}, C_INT)
constant CLOSE = define_c_func(STDLIB, "close", {C_INT}, C_INT)
constant DUP2 = define_c_func(STDLIB, "dup2", {C_INT, C_INT}, C_INT)
constant KILL = define_c_func(STDLIB, "kill", {C_INT, C_INT}, C_INT)
constant FORK = define_c_func(STDLIB, "fork", {}, C_INT)
constant EXECV = define_c_func(STDLIB, "execv", {C_POINTER, C_POINTER}, C_INT)
constant SIGNAL = define_c_func(STDLIB, "signal", {C_INT, C_POINTER}, C_POINTER)
constant ERRNO = define_c_var(STDLIB, "errno")

global constant os_stdin = 0
global constant os_stdout = 1
global constant os_stderr = 2
global constant os_sig_dfl = 0
global constant os_sig_ign = 1
global atom os_errno os_errno = 0
global object VOID VOID = {}

global function os_pipe()
    atom cmd, r, in, out
    cmd = allocate(8)
    r = c_func(PIPE,{cmd})
    if r = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    in = peek4u(cmd)
    out = peek4u(cmd+4)
    free(cmd)
    return {in, out}
end function

global function os_read(atom fd, integer bytes)
    atom buf, r
    sequence data
    buf = allocate(bytes)
    r = c_func(READ, {fd, buf, bytes})
    if r = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    if r = 0 then
	free(buf)
	return ""
    end if
    data = ""
    for i = 1 to r do
	data &= peek(buf+i-1)
    end for
    return data
end function

global function os_write(atom fd, sequence str)
    atom buf, r
    buf = allocate_string(str)
    r = c_func(WRITE, {fd, buf, length(str)})
    if r = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    return r
end function

global function os_close(atom fd)
    atom r
    r = c_func(CLOSE, {fd})
    if r = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    return 0
end function

global function os_dup2(atom oldfd, atom newfd)
    atom r
    r = c_func(DUP2, {oldfd, newfd})
    if r = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    return r
end function

global function os_kill(atom pid, atom signal)
    atom r
    r = c_func(KILL, {pid, signal})
    if r = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    return r
end function

global function os_fork()
    atom pid
    pid = c_func(FORK, {})
    if pid = -1 then
	os_errno = peek4u(ERRNO)
	return -1
    end if
    return pid
end function

global function os_execv(sequence s, sequence v)
    atom sbuf
    atom vbuf sequence vbufseq
    atom r
    sbuf = allocate_string(s)
    vbufseq = ""
    for i = 1 to length(v) do
	vbufseq &= allocate_string(v[i])
    end for
    vbufseq &= 0
    vbuf = allocate(length(vbufseq)*4)
    poke4(vbuf, vbufseq)
    r = c_func(EXECV, {sbuf, vbuf}) -- execv() should never return
    os_errno = peek4u(ERRNO)
    return r
end function

global function os_signal(integer signal, atom handler)
    return c_func(SIGNAL, {signal, handler})
end function

