/* edit.c - edit current file
 *
 * $Id: edit.c,v 1.2 2001/11/13 10:23:52 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <ctype.h>
#include "hook.h"
#include "terminal.h"
#include "viewfile.h"

extern int menuview_abort;


/* Edit the current file.
 *
 * Just returns if editing is not allowed or if a file lock could not be
 * obtained.
 */
void rf_edit_whole_file (rf_data_t data) {
  struct stat sb;
  long pos;

  if (!(data->flags & MENU_STATUS_EDIT)) return;

  if (stat (data->ldb_entry->realname, &sb)) return;

  if (bbs_hook (HOOK_CHECK_BAN, "E", 0)) {
    t_goto (0, t_rows - 1);
    t_clrtoeol ();
    t_centre ("\035R  *** You are banned from altering files ***  \035r");
    sleep (2);
    rf_redraw = 1;
    return;
  }

  pos = data->ldb_entry->current_line - (t_rows / 2) + 1;

  if (rf_edit_lock (data->ldb_entry->realname)) return;

  mview_edit_file (data->ldb_entry->realname, pos, 1, data->title, 0);

  rf_edit_unlock ();

  if (!(data->flags & MENU_STATUS_BARLOG)) bbs_hook (HOOK_LOG_EDIT, data, 0);
}


/* Edit the current file in the internal editor.
 *
 * Just returns if editing is not allowed or if a file lock could not be
 * obtained.
 */
void rf_internal_edit_whole_file (rf_data_t data) {
  struct stat sb;
  long pos;
  int r;

  if (!(data->flags & MENU_STATUS_EDIT)) return;

  if (stat (data->ldb_entry->realname, &sb)) return;

  if (bbs_hook (HOOK_CHECK_BAN, "E", 0)) {
    t_goto (0, t_rows - 1);
    t_clrtoeol ();
    t_centre ("\035R  *** You are banned from altering files ***  \035r");
    sleep (2);
    rf_redraw = 1;
    return;
  }

  pos = data->ldb_entry->current_line - (t_rows / 2) + 1;

  if (rf_edit_lock (data->ldb_entry->realname)) return;

  r = mview_edit_file (data->ldb_entry->realname, pos, 0, data->title, 0);

  rf_edit_unlock ();

  if (r != 0) return;

  if (!(data->flags & MENU_STATUS_BARLOG)) bbs_hook (HOOK_LOG_EDIT, data, 0);
}


/* Display the editing menu, and perform the action appropriate to the
 * selected option.
 */
void rf_edit_file (rf_data_t data) {
  int candel = 0;
  int canedit = 0;
  int c;

  if (data->flags & MENU_STATUS_READONLY) return;

  if (data->flags & MENU_STATUS_EDIT) canedit = 1;
  if (data->flags & MENU_STATUS_ADD) candel = 1;
  if (data->flags & MENU_STATUS_DELETE) candel = 1;
  if (data->flags & MENU_STATUS_BARDELETE) candel = 0;

  data->linebuf[0] = 0;
  if (canedit) strcat (data->linebuf, "[\035BA\035b]:Edit  ");
  if ((canedit) && !bbs_hook (HOOK_IS_EXTERNAL, 0, 0)) {
    strcat (data->linebuf, "[\035BE\035b]:Edit  ");
  }
  if (candel) strcat (data->linebuf, "[\035BD\035b]:Delete  ");
  strcat (data->linebuf, "[\035BQ\035b]:Quit");

  rf_redraw = 1;

  do {
    if (rf_redraw) {
      rf_wipe_footer (data);
      t_goto (0, t_rows - 1);
      t_centre (data->linebuf);
      rf_redraw = 0;
    }
    c = toupper (t_getchar (1));
    if (menuview_abort) c = 'Q';
    if (c == 12) rf_redraw = 1;
    if ((!canedit) && (c == 'A')) c = 0;
    if ((!canedit) && (c == 'E')) c = 0;
    if ((c == 'E') && bbs_hook (HOOK_IS_EXTERNAL, 0, 0)) c = 0;
    if ((!candel) && (c == 'D')) c = 0;
  } while ((c != 'A') && (c != 'E') && (c != 'D') && (c != 'Q'));

  switch (c) {
    case 'Q':
      rf_wipe_footer (data);
      rf_footer (data);
      break;
    case 'A':
      bbs_hook (HOOK_SET_ACTION, "Edit ",
                (data->flags & MENU_STATUS_HIDETITLE) ? "" : data->title);
      rf_internal_edit_whole_file (data);
      data->last_scanned = 0;
      rf_get_current_line (data);
      bbs_hook (HOOK_SET_ACTION, "Reading ",
                (data->flags & MENU_STATUS_HIDETITLE) ? "" : data->title);
      break;
    case 'E':
      bbs_hook (HOOK_SET_ACTION, "Edit ",
                (data->flags & MENU_STATUS_HIDETITLE) ? "" : data->title);
      rf_edit_whole_file (data);
      data->last_scanned = 0;
      rf_get_current_line (data);
      bbs_hook (HOOK_SET_ACTION, "Reading ",
                (data->flags & MENU_STATUS_HIDETITLE) ? "" : data->title);
      break;
    case 'D':
      rf_delete_entry (data);
      data->last_scanned = 0;
      rf_get_current_line (data);
      break;
    default: break;
  }
}

/* EOF */
