/* action.c - set current action or keypath
 *
 * $Id: action.c,v 1.2 2000/07/28 16:44:20 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "viewmenu.h"
#include "mstring.h"
#include "lock.h"
#include "hook.h"
#include "bbs.h"


char current_action[1024] = {0};
char current_keypath[MENUVIEW_KEYPATHLEN + 1] = {0};
extern char * uid_user;
extern int action_fd;
extern int use_xtitle;
extern int status_fd;
extern char * status_file;
extern time_t last_keypress;
extern time_t last_idle_update;
extern time_t start_time;
extern int menuview_abort;
extern char * logout_reason;


/* Set the current process title.
 */
void hook_set_proctitle (void) {
  struct stat sb;
  char buf[1024];
  char * loc;
  char * a;

  sprintf (buf, "%s/%s", cf_str ("status"), current_user);
  if (!stat (buf, &sb)) {			/* user [D]isconnected */
    remove (buf);
    rmdir (buf);
    logout_reason = "You have been disconnected by another user.";
    menuview_exitup = 1;
    menuview_abort = 1;
    return;
  }

  if (proc_title) {

    if ((strlen (current_keypath) == 0)
        || (!strcmp (current_keypath, "^"))) {
      if (!strcmp (uid_user, current_user)) {
        snprintf (buf, sizeof (buf), "(%s)", current_action);
      } else {
        snprintf (buf, sizeof (buf), "(%s|%s)", current_user, current_action);
      }
    } else {
      if (!strcmp (uid_user, current_user)) {
        snprintf (buf, sizeof (buf), "(<%s> %s)",
                  current_keypath, current_action);
      } else {
        snprintf (buf, sizeof (buf), "(%s|<%s> %s)", current_user,
                  current_keypath, current_action);
      }
    }

    mstripattr (buf);

    memset (proc_title, 0, proc_title_len);
    strncpy (proc_title, buf, proc_title_len - 1);

  }

  if (getenv ("SPOOL_FILE")) return;		/* in a subprocess */

  if (action_fd >= 0) {
    snprintf (buf, sizeof (buf), "%s", current_action);
    mstripattr (buf);
    lseek (action_fd, 0, SEEK_SET);
    write (action_fd, buf, strlen (buf));
    ftruncate (action_fd, strlen (buf));
  }

  if (use_xtitle) {
    snprintf (buf, sizeof (buf) - 2, "\033]2;%s: %s",
              current_user, current_action);
    mstripattr (buf + 4);
    strcat (buf, "\007");
    write (0, buf, strlen (buf));
  }

  if (status_fd >= 0) {
    a = getenv ("MVIEW_NAMELINE");
    loc = "";
    bbs_hook (HOOK_LOCATION, &loc, &loc);
    snprintf (buf, sizeof (buf), "%s\n%s\n%s\n%s\n%ld\n%s\n%ld\n",
              current_user, (a) ? a : "", current_keypath, current_action,
              last_keypress, loc, start_time);
    my_flock (status_file, status_fd, LOCK_EX);
    lseek (status_fd, 0, SEEK_SET);
    write (status_fd, buf, strlen (buf));
    ftruncate (status_fd, strlen (buf));
    my_flock (status_file, status_fd, LOCK_UN);
    last_idle_update = time (0);
  }
}


/* Set the current action to "a""b". Either "a" or "b" may be 0 to signify a
 * blank string.
 */
void hook_set_action (char * a, char * b) {
  snprintf (current_action, sizeof (current_action),
            "%s%s", (a) ? a : "", (b) ? b : "");
  hook_set_proctitle ();
}


/* Set the current keypath to "k".
 */
void hook_set_keypath (char * k) {
  strncpy (current_keypath, (k) ? k : "", MENUVIEW_KEYPATHLEN);
  current_keypath[MENUVIEW_KEYPATHLEN] = 0;
  hook_set_proctitle ();
}


/* Store a pointer to the current keypath in "*ptr".
 */
void hook_get_keypath (char ** ptr) {
  *ptr = current_keypath;
}


/* Store a pointer to the current action in "*ptr".
 */
void hook_get_action (char ** ptr) {
  *ptr = current_action;
}

/* EOF */
