/* privcheck.c - check whether exercising privilege is allowed
 *
 * $Id: privcheck.c,v 1.1.1.1 1999/12/02 20:00:06 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>
#include "examine.h"
#include "bbs.h"


/* Check whether the current user's userlevel is low enough to exercise any
 * privilege on "user".
 *
 * Returns nonzero if the current user cannot exercise privileges.
 */
int examine_priv_check (char * user) {
  char * a;
  int ul_c, ul_o;

  if (!strcmp (user, current_user)) return (0);

  examine_udb_load (user);

  a = getenv ("BBS_LEVEL");			/* read current user's level */
  if (!a) return (1);
  if (!strcmp (a, "")) a = "99";
  ul_c = atoi (a);

  a = examine_udb_env ("BBS_LEVEL");		/* read other user's level */
  if (!a) return (1);
  if (!strcmp (a, "")) a = "99";
  ul_o = atoi (a);

  if (ul_c >= ul_o) return (1);

  return (0);
}

/* EOF */
