/* disconnect.c - disconnect another user
 *
 * $Id: disconnect.c,v 1.1.1.1 1999/12/02 20:00:02 ivarch Exp $
 */

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include "terminal.h"
#include "examine.h"
#include "hook.h"
#include "bbs.h"


/* Allow the user to disconnect "user".
 */
void examine_disconnect (char * user) {
  char buf[1024];
  int c, n;

  if (examine_priv_check (user)) return;

  snprintf (buf, sizeof (buf) - 1,
            "Really disconnect `\035B%s\035b'?  [\035BY\035b]/[\035BN\035b]",
            user);

  rf_redraw = 1;
  n = 0;

  do {

    c = t_getchar (n);				/* read a keypress */
    n = 1;

    t_checksize ();				/* check for terminal resize */

    bbs_hook (HOOK_KEY_PRESSED, 0, &c);

    if (rf_redraw) {
      t_goto (0, t_rows - 1);
      t_clrtoeol ();
      t_centre (buf);
      rf_redraw = 0;
    }

    if (c == 12) rf_redraw = 1;
    else if (c == 'y') c = 'Y';
    else if (c == 'n') c = 'N';

  } while ((c != 'Y') && (c != 'N'));

  rf_redraw = 1;

  if (c == 'N') return;

  sprintf (buf, "%s/%s", cf_str ("status"), user);

  mkdir (buf, S_IRWXU | S_IRWXG);

  t_goto (0, t_rows - 1);
  t_clrtoeol ();
  t_centre ("Disconnection request transmitted");

  sleep (1);
}

/* EOF */
