#!/usr/bin/perl -w
#
# Usage: thisperlscript STARTMENU TITLE TEMPLATEFILE OUTDIR
#
# Makes a set of web pages starting at file STARTMENU, storing in directory
# OUTDIR. Will screw up if STARTMENU refers to ../something, so be careful.
# TITLE is the title to give to the first menu, and TEMPLATEFILE is an HTML
# template, in which "TITLE" is replaced by the current title, and a line
# containing only the word "DATA" is replaced by the file contents.
#
# Note that gzipped files are not supported by this script, and any files
# ending in ".cm" are not linked to (so that discussion files are not put
# on the web).
#
# $Id: m2ht.pl,v 1.1.1.1 1999/12/02 19:59:14 ivarch Exp $

umask 022;

sub convert_file;
sub convert_menu;
sub ensure_dir;

($startmenu, $toptitle, $template, $outdir) = @ARGV;

$startout = $startmenu;
$startout =~ s@^.*/([^/]*)$@$1@;
$startout = $startout . ".html";

$startdir = $startmenu;
$startdir =~ s@^(.*/)[^/]*$@$1@;

convert_menu ("$startmenu", "$outdir/$startout", "$toptitle", "");


sub convert_file {
  my ($in, $out, $title, $indent) = @_;

  print "${indent}$in\n";

  ensure_dir ($out);

  open (OUT, "> $out") || die "failed to write to $out";
  open (IN, "$template") || die "failed to read $template";

  while (<IN>) {
    if (/^DATA$/) {
      open (CONV, "mconv -fhy -w 79 $in |") || die "mconv $in failed";
      while (<CONV>) { print OUT; }
      close (CONV);
    } else {
      s/TITLE/${title}/g;
      print OUT;
    }
  }

  close (IN);
  close (OUT);
}


sub convert_menu {
  my ($in, $out, $title, $indent) = @_;
  my @files;
  my @menus;
  my @titles;
  my $file;
  my $menu;
  my $indir;
  my $outdir;

  @files = ();
  @menus = ();
  @titles = ();

  print "${indent}$in\n";
  $indent = "$indent  ";

  ensure_dir ($out);

  open (OUT, "> $out") || die "failed to write to $out";
  open (IN, "$template") || die "failed to read $template";

  while (<IN>) {

    if (/^DATA$/) {

      open (CONV, "mconv -mhgn -w 79 $in |") || die "mconv $in failed";

      while (<CONV>) {
        s@<a href=\".*.cm.html\">(.*)</a>@$1@g;
        if (m@<a href=\"(.*.mn).html\">.*</a></b>] . (.*)$@) {
          push @menus, "$1 $2";
        } elsif (m@<a href=\"(.*).html\">.*</a></b>] . (.*)$@) {
          push @files, "$1 $2";
        }
        s/^ +$//;
        s@([^ ].*)<b>(<a href=\".*\">)(.*)</a></b>(] . )@$2$1<b>$3</b>$4</a>@;
        print OUT;
      }

      close (CONV);

    } else {
      s/TITLE/${title}/g;
      print OUT;
    }
  }

  close (IN);
  close (OUT);

  foreach $file (@files) {
    $indir = $in;
    $indir =~ s@^(.*)/[^/]*$@$1@;
    $outdir = $out;
    $outdir =~ s@^(.*)/[^/]*$@$1@;
    $title = $file;
    $title =~ s@^[^ ]+ @@;
    $title =~ s@\<[^>]*\>@@g;
    $file =~ s@^([^ ]+) .*$@$1@;
    convert_file ("$indir/$file", "$outdir/$file.html", "$title", "$indent");
  }

  foreach $menu (@menus) {
    $indir = $in;
    $indir =~ s@^(.*)/[^/]*$@$1@;
    $outdir = $out;
    $outdir =~ s@^(.*)/[^/]*$@$1@;
    $title = $menu;
    $title =~ s@^[^ ]+ @@;
    $title =~ s@\<[^>]*\>@@g;
    $menu =~ s@^([^ ]+) .*$@$1@;
    convert_menu ("$indir/$menu", "$outdir/$menu.html", "$title", "$indent");
  }
}


sub ensure_dir {
  my ($dir) = @_;
  my @components;
  my $piece;

  $dir =~ s@^(.*)/[^/]*$@$1@;
  @components = split (/\//,$dir);
  $dir = "";

  foreach $piece (@components) {
    $dir .= $piece . "/";
    mkdir ($dir, 0711);
  }
}

# EOF
