#! /usr/local/bin/perl
#
#  The name of the "gnlog.pl" program to run
#
$gnlog="gnlog.2.pl" ;
#
@days_month{"jan"} = 31 ;
@days_month{"feb"} = 29 ;
@days_month{"mar"} = 31 ;
@days_month{"apr"} = 30 ;
@days_month{"may"} = 31 ;
@days_month{"jun"} = 30 ;
@days_month{"jul"} = 31 ;
@days_month{"aug"} = 31 ;
@days_month{"sep"} = 30 ;
@days_month{"oct"} = 31 ;
@days_month{"nov"} = 30 ;
@days_month{"dec"} = 31 ;

@month_name{"jan"} = "Jan" ;
@month_name{"feb"} = "Feb" ;
@month_name{"mar"} = "Mar" ;
@month_name{"apr"} = "Apr" ;
@month_name{"may"} = "May" ;
@month_name{"jun"} = "Jun" ;
@month_name{"jul"} = "Jul" ;
@month_name{"aug"} = "Aug" ;
@month_name{"sep"} = "Sep" ;
@month_name{"oct"} = "Oct" ;
@month_name{"nov"} = "Nov" ;
@month_name{"dec"} = "Dec" ;
@month_name{"01"} = "Dec" ;
@month_name{"02"} = "Jan" ;
@month_name{"03"} = "Apr" ;
@month_name{"04"} = "May" ;
@month_name{"05"} = "Jun" ;
@month_name{"06"} = "Jul" ;
@month_name{"07"} = "Aug" ;
@month_name{"08"} = "Sep" ;
@month_name{"09"} = "Oct" ;
@month_name{"10"} = "Nov" ;
@month_name{"11"} = "Dec" ;
@month_name{"12"} = "Jan" ;

if( $#ARGV < 0 ) {
    print "Usage:  gn_date.pl  <month to process> <input log file> \n" ;
    print "  where month is 3 letter month abbrev\n" ;
    exit ;
}

$this_month = $ARGV[0] ;
$infile     = $ARGV[1] ;


if ( defined($month_name{$this_month})) {
    $this_month = $month_name{$this_month} ;
}

#
# only needed if this is running from a script after midnight - to pick 
# up the month before
#

$this_month =~ tr/A-Z/a-z/ ;

$first_letter = substr($this_month,0,1) ;
$rest_month  = substr($this_month,1) ;
$first_letter =~ tr/a-z/A-Z/ ;

$month_to_print = $first_letter.$rest_month ; 
#
#  We're making a shell script - do it
#
print "#! /bin/sh\n" ;
print "#\n" ;
print "#  to produce gopher logs for the month of $this_month\n" ;
print "#\n" ;
#
#
for ( $i = 1 ; $i <= $days_month{$this_month} ; $i++ ) {
    $outfile = $infile.".".$i ;
    printf ("grep \"%s %2d\"  %s | $gnlog\n", $month_to_print, 
                                          $i, 
                                          $infile ); 
                                          
}
__END__
Dec
Jan
Feb
Mar
Apr
May
Jun
Jul
Aug
Sep
Oct
Nov
Dec








