/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: mkcache/init.c
    Version 2.07
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include "mkcache.h"

int	recurse = 0,
	quiet	= 0;

char	mfname[MAXLEN],
	cfname[MAXLEN],
	myhost[MAXLEN],
	defaultport[MAXLEN];
	
extern char *optarg;
extern int optind;


void
init( argc, argv)
int	argc;
char	*argv[];
{
	int	c,
		dflg = 0,
		errflg = 0;
	char	*dir;

	islocal = isgnlink = ishname = FALSE;
	item[0] = path[0] = host[0] = port[0] = type[0] = '\0';
	separator[0] = section[0] = '\0';
	content[0] = suffix[0] = encoding[0] = attribute[0] = '\0';

	strcpy( myhost, GN_HOSTNAME);
	strcpy( defaultport, DEFAULTPORT);
	strcpy( mfname, MENUFNAME);
	strcpy( cfname, CACHEFNAME);

	while ((c = getopt(argc, argv, "qrd:m:c:h:p:")) != -1) {
		switch ((char) c) {
			case 'r':
				recurse++;
				break;
			case 'q':
				quiet++;
				break;
			case 'd':
				dflg++;
				dir = optarg;
				break;
			case 'm':
				strcpy( mfname, optarg);
				break;
			case 'c':
				strcpy( cfname, optarg);
				break;
			case 'h':
				strcpy( myhost, optarg);
				break;
			case 'p':
				strcpy( defaultport, optarg);
				break;
			case '?':
				errflg++;
		}
	}

	if (errflg) {
		fprintf( stderr, 
	"Usage: %s [-r] [-q] [-d dir] [-m menu] [-c cache] [-h host] [-p port]\n",
		argv[0]);
		exit (2);
	}

	if ( dflg ) {
		sprintf( mfpath, "%s/%s", dir, mfname);
		sprintf( cfpath, "%s/%s", dir, cfname);
	} else {
		sprintf( mfpath, "./%s", mfname);
		sprintf( cfpath, "./%s", cfname);
	}
	loadmime();

}

/* chop( line)  Cut out CRLF at end of line */

void
chop( line)
char *line;
{
	char	*p;

	if ( *line == '\0')
		return;
	if ( (p = strchr( line, '\n')) == (char *) NULL )
		return;
	if ( *--p != '\r')
		p++;
	*p = '\0';
}

