/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: mkcache/content.c
    Version 2.07
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include "mkcache.h"

#define MAXMIME	1024

extern char	*malloc();

static char	*binlist[MAXMIME][2] = {
		{"gif", "image/gif"},
		{ "xbm", "image/x-xbitmap"},
		{ "jpeg", "image/jpeg"},
		{ "jpg", "image/jpeg"},
		{ "jpe", "image/jpeg"},
		{ "mpeg", "video/mpeg"},
		{ "mpg", "video/mpeg"},
		{ "dvi", "application/x-dvi"},
		{ "ps", "application/postscript"},
		{ "eps", "application/postscript"},
		{ "au", "audio/basic"},
		{ "snd", "audio/basic"},
		{ "exe", "application/octet-stream"},
		{ "bin", "application/octet-stream"},
		{ NULL, NULL }
};

static char	*textlist[MAXMIME][2] = {
		{ "txt", "text/plain"},
		{ "html", "text/html"},
		{ "cgi", "text/html"},
		{ "ps", "application/postscript"},
		{ "eps", "application/postscript"},
		{ "xbm", "image/x-xbitmap"},
		{ "tex", "text/x-tex"},
		{ NULL, NULL }
};


void
getcontent( type1)
char	type1;
{
	int	i = 0;

	switch ( type1) {
	case '0':
		i = 0;
		while ( textlist[i][0] != NULL) {
			if ( streq( textlist[i][0], suffix)) {
				strcpy( content, textlist[i][1]);
				return;
			}
			i++;
		}
		strcpy( content, "text/plain");
		return;

	case '1':
	case '7':
	case 'h':
		strcpy( content, "text/html");
		return;
	case '4':
		strcpy( content, "application/mac-binhex40");
		return;
	case '5':
	case '9':
	case 's':
	case 'I':
		i = 0;
		while ( binlist[i][0]  ) {
			if ( streq( binlist[i][0], suffix)) {
				strcpy( content, binlist[i][1]);
				return;
			}
			i++;
		}
		strcpy( content, "application/octet-stream");
		return;
	}
}


void
loadmime()
{
	
	register char	*cp;
	char	buf[MAXLEN];
	FILE	*mimefp;
	int	i = 0,
		j = 0;

	if ( (mimefp = fopen( MIME_TYPE_FILE, "r")) == (FILE *) NULL) {
		fprintf(stderr, "Warning:  Unable to open mime type file:\n");
		fprintf(stderr, "%s\n", MIME_TYPE_FILE );
		fprintf(stderr, "Using defaults.\n" );
		return;
	}

	while ( fgets( buf, MAXLEN, mimefp)) {
		chop( buf);
			
		switch ( *buf) {
		case '0':
		case '4':

			if ( (cp = strchr( buf, '\t')) == NULL) {
				fprintf(stderr, "Corrupt mime type %s\n",
					 MIME_TYPE_FILE );
				exit( 2);
			}
			if ( (textlist[i][0] = malloc( SMALLBUF)) == NULL) {
				fprintf(stderr, "Not enough memory\n");
				exit( 2);	
			}
			strcpy( textlist[i][0], ++cp);
			
			if ( (cp = strchr( textlist[i][0], '\t')) == NULL) {
				fprintf(stderr, "Corrupt mime type %s\n",
					 MIME_TYPE_FILE );
				exit( 2);
			}
			*cp++ = '\0';
			textlist[i][1] = cp;
			i++;
			if ( i >= MAXMIME) {
				fprintf(stderr, "Mime type file too large.\n");
				exit( 2);
			}
			break;
		case '5':
		case '9':
		case 's':
		case 'I':
			if ( (cp = strchr( buf, '\t')) == NULL) {
				fprintf(stderr, "Corrupt mime type %s\n",
					 MIME_TYPE_FILE );
				exit( 2);
			}
			if ( (binlist[j][0] = malloc( SMALLBUF)) == NULL) {
				fprintf(stderr, "Not enough memory\n");
				exit( 2);	
			}
			strcpy( binlist[j][0], ++cp);
			
			if ( (cp = strchr( binlist[j][0], '\t')) == NULL) {
				fprintf(stderr, "Corrupt mime type %s\n",
					 MIME_TYPE_FILE );
				exit( 2);
			}
			*cp++ = '\0';
			binlist[j][1] = cp;
			j++;
			if ( j >= MAXMIME) {
				fprintf(stderr, "Mime type file too large.\n");
				exit( 2);
			}
		}
	}
	textlist[i][0] = textlist[i][1] = NULL;
	binlist[j][0] = binlist[j][1] = NULL;
}