/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/www.c
    Version 2.14
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include "gn.h"

/*
 * www_escape( path) replaces special chars in path with %XX escapes
 */

void
www_escape( path)
char	*path;
{

	register char	*cp,
			*cp2;
	char	buf[BUFSIZE];

	cp = path;
	cp2 = buf;
	while ( *cp ) {
		switch (*cp) {
		case ',':
		case ';':
		case '"':
		case '\'':
		case '&':
		case '=':
		case '(':
		case ')':
		case '?':
		case '#':
		case '{':
		case '}':
		case '%':
		case ' ':
			sprintf( cp2, "%%%X", (int) *cp);
			cp2 += 3;
			cp++;
			break;
		default:
			*cp2++ = *cp++;
		}
	}
	*cp2 = '\0';
	strcpy( path, buf);
}

/*
 * www_unescape( path) undoes what www_escape does.  Also change
 * any +'s to pluschar.
 */

void
www_unescape( path, pluschar)
char	*path,
	pluschar;

{

	register char	*cp,
			*cp2;
	int	val;

	char	minbuf[3],
		buf[PATHLEN];

	cp = path;
	cp2 = buf;
	while ( *cp ) {
		switch ( *cp) {
		case '%':
			cp++;
			minbuf[0] = *cp++;
			minbuf[1] = *cp++;
			minbuf[2] = '\0';
			sscanf( minbuf, "%x", &val);
			*cp2++ = (char) val;
			break;
		case '+':
			*cp2++ = pluschar;
			cp++;
			break;
		default:
			*cp2++ = *cp++;
		}
	}
	*cp2 = '\0';
	strcpy( path, buf);
}


/*
 * www_replace ( name) replaces special characters, <, >, & in a name
 */
  
void
www_replace ( name)
char	*name;
{
 	register char	*cp,
 			*cp2;
	char	buf[BUFSIZE];

	cp = name;
	cp2 = buf;
	while ( *cp ) {
		switch (*cp) {
		case '&':
			strcpy( cp2, "&amp;");
			cp2 += 5;
			break;
		case '<':
			strcpy( cp2, "&lt;");
			cp2 += 4;
			break;
		case '>':
			strcpy( cp2, "&gt;");
			cp2 += 4;
			break;
		default:
			*cp2++ = *cp;
		}
		cp++;
	}
	*cp2 = '\0';
	strcpy( name, buf);
}


/*
 * <This and other hname code contributed by Craig Milo Rogers>
 * www_unreplace ( name) removes any special HTML sequences in a name
 *
 *	This routine is the inverse of www_replace(), and a little bit
 * more.  It is used to convert possibly-HTML-containing names to plain
 * text, so they'll look OK when sent to gopher.
 *
 * 1)	Everything inside "<>" is skipped, including the brackets.
 *	Bracket nesting is taken into consideration.
 *
 * 2)	Three special character sequences are mapped:  "&amp;" becomes
 *	"&", "&lt;" becomes "<", and "&gt;" becomes ">".
 *
 * 3)	Other special character sequences beginning with "&" are left
 *	unchanged.
 *
 * Note:  Since none of the changes increase the length of the string,
 * the argument is edited in place.
 */
  
void
www_unreplace ( name)
char	*name;
{
 	register char	*cp,
 			*cp2;
	int	brackdepth = 0;
	
	cp = cp2 = name;
	while ( *cp ) {
		if ( *cp == '<') {
			brackdepth++;
			cp++;
		} else if ( *cp == '>') {
			brackdepth--;
			cp++;
		} else if ( brackdepth > 0) {
			cp++;
		} else if ( *cp == '&') {
			if        ( strncmp( cp, "&amp;", 5) == 0) {
				*cp2++ = '&';
				cp += 5;
			} else if ( strncmp( cp, "&lt;", 4) == 0) {
				*cp2++ = '<';
				cp += 4;
			} else if ( strncmp( cp, "&gt;", 4) == 0) {
				*cp2++ = '>';
				cp += 4;
			} else
				*cp2++ = *cp++;
		} else
			*cp2++ = *cp++;
	}
	*cp2 = '\0';
}
