/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/util.c
    Version 2.14

    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include "gn.h"

extern void	www_unescape();

void
senderr( msg, ip)
char	*msg;
Item	*ip;
{
	senderr2( msg, ip->selector);
}

void
www_err( status, msg)
char	*status,
	*msg;
{
	Item	*ip;
	char	buf[BUFSIZE];

	ip = &thisitem;

	if ( http & HTTP1_0) {
		sprintf( outheader.status, "%s %s", status, msg);
		writelog( "", "HTTP error", buf);
		strcpy(ip->content_type, "text/html");
		*ip->mod_date = *ip->encoding = *ip->length = '\0';
		http_prolog( ip);

	}
	fprintf( stdout, "<HEAD><TITLE>%s %s</TITLE></HEAD>\n", 
				status, msg);
	fprintf( stdout, "<BODY><H2>Error code %s</H2>\n%s\n</BODY>\n", 
				status, msg);
}

void
senderr2( msg, msg2)
char	*msg,
	*msg2;
{
	char	*status;


	if ( msg2 == NULL)
		msg2 = "";

	if ( http){
		if ( strncmp( msg, "Sorry", 5) == 0 ) {
			status = "403";
		}
		else {
			status = "400";
		}
		www_err( status, msg);
	}
	else
		printf(	"3Server error: %s\t\terror.host\t0\r\n.\r\n", msg);

	writelog( "", msg, msg2);
}


void
get_remote_info( ipnum, hostp)
char	*ipnum,
	*hostp;
{
	char			**hlist,
				*inet_ntoa();
	struct sockaddr_in	saddr;
	struct in_addr		*netaddr;
	struct hostent		*hostentp = NULL;
	int			size,
				name_ok = FALSE;

#ifdef NONET
	*ipnum = *hostp = '\0';
	return;
#else
	size = sizeof(saddr);
	if ( getpeername(fileno(stdin), &saddr, &size) < 0 ) {
		writelog( "", "getpeername failed", "");
		*ipnum = *hostp = '\0';
		return;
	}		
		
	strcpy(ipnum, inet_ntoa(saddr.sin_addr));
	netaddr = &saddr.sin_addr,
	hostentp = gethostbyaddr((char *) netaddr,
			sizeof (saddr.sin_addr.s_addr), AF_INET);

	if (hostentp == NULL) {
		strcpy( hostp, ipnum);
		return;
	}

	strcpy( hostp, hostentp->h_name);
	strlower( hostp);
	if ( accesstype == FREE)
		return;
	if ( (hostentp = gethostbyname( hostp)) == NULL) {
		writelog( "", "gethostbyname failed", "");
		strcpy( hostp, ipnum);
		return;
	}
	hlist = hostentp->h_addr_list;
	while ( *hlist ) {
		if (((struct in_addr *)(*hlist))->s_addr == netaddr->s_addr) {
			name_ok = TRUE;
			break;
		}
		hlist++;
	}
	if ( name_ok == FALSE)
		strcpy( hostp, ipnum);
#endif
}


#ifdef DO_LINGER

/* Thanks to Chip Rosenthal for this function */

void linger(fd, ltime)
int fd, ltime;
{
	struct linger li;
	li.l_onoff = (ltime > 0);
	li.l_linger = ltime;
	if ( setsockopt( fd, SOL_SOCKET, SO_LINGER, (char *)&li,
					    sizeof (li)) == -1) {
		/* ignore error if we are running on a tty */
		/* this allows gn to be run interactively for debugging */
		if ( isatty(fd))
			return;
		senderr2( "Could not set linger option [setsockopt]", "");
		exit(2);
	}
}

#endif


/* chop( line)  Cut out CRLF at end of line, or just LF */

void
chop( line)
char *line;
{
	register char	*cp;

	if ( *line == '\0')
		return;
	cp = line;
	while ( *cp )
		cp++;
	if ( *--cp == '\n') {
		*cp = '\0';
		if ( (cp > line) && *--cp == '\r')
			*cp = '\0';
	}
}

/*
 *  wild_match
 *
 *  String equality routine, including matching the '*' character.
 */

/*
 *  Borrowed from the ANU News sources V6.1b3 newsrtl.c.  Original sources
 *  Copyright 1989 by Geoff Huston.
 *
 */

int wild_match(l,p)
    char *l,
         *p;
{
    if (!*l) {
        if (!*p) return(1);
        else if (*p == '*') return(wild_match(l,p+1));
        else return(0);
        }
    if (*p == '*') {
        while (!wild_match(l,p+1)) {
            l++;
            if (!*l) {
                if (!*(p+1)) return(1);
                else return(0);
                }
            }
        return(1);
        }
    if ((*p == '%') || (*p == '?')) return(wild_match(l+1,p+1));
    if (*p == '^') return((*l == *(p+1)) && wild_match(l+1,p+2));
    return((*l == *p) && wild_match(l+1,p+1));
}


FILE *
safer_popen( command, args, type)
char	*command,
	*args,
	*type;
{
	register char	*cp,
			*cp2;

	int		is_cgi = FALSE;

	char		*argptr,
			buf[PATHLEN],
			buf2[PATHLEN],
			suspicious = '\0';

	if ( streq( type, "cgi")) {
		is_cgi = TRUE;
		type = "r";
	}
	strcpy( buf, command);
	argptr = buf + strlen( buf);

	if ( (cp = strrchr( buf, '/')) != NULL)  {
		*cp = '\0';
		if ( chdir( buf) != 0  )
			writelog( "", "Can't chdir for exec to", buf);
		*cp = '/';
	}
	strcpy( buf2, args);

	if (http)
		www_unescape( buf2, ' '); /* Change '+' to space and */
					  /* handle URL escapes */


/*
 * #define ESCAPE_META
 *
 * Ucomment this at your peril.  Several people has asked for the 
 * capability to pass all characters to shell scripts (type exec0, etc.), 
 * with the dangerous ones escaped with a backslash.  The normal behavior
 * is replace all the characters which have a special meaning to the
 * shell like ';' or '|' with a space.  This is done as a security
 * measure.  Escaping these characters with a backslash, as near as I can
 * tell, is secure for the shell which gn invokes to run your script or
 * program.  But it does nothing to protect any scripts *you* write.  I
 * don't advise using this.  If you uncomment this keep in mind that if
 * your script contains the line "echo $1" that $1 might be equal to 
 * "Tough luck!; rm *" so your command is turned into "echo Tough luck!;
 * rm *".  (By the way, if you are running with the user properly set to
 * 'nobody' in inetd.conf, no damage should be done by this particular 
 * command.  Anyway the capability is there if you feel confident using
 * it.  I don't use it.
 * 
 */
	cp = buf2;
	if ( *cp) {
		cp2 = argptr;
		*cp2++ = ' ';
		while ( *cp != '\0') {
			switch (*cp) {
				case	'\n':
				case	'\r':
					*cp = *cp2 = '\0';
					suspicious = *cp;
					break;
				case	';':
				case	'`':
				case	'\'':
				case	'|':
				case	'*':
				case	'?':
				case	'-':
				case	'~':
				case	'>':
				case	'<':
				case	'^':
				case	'[':
				case	']':
				case	'&':
				case	'(':
				case	')':
				case	'{':
				case	'}':
				case	'$':
				case	'=':
				case	'!':
				case	'\\':
					suspicious = *cp;
					if ( is_cgi)
						return (NULL);
					/* CGI spec says if command line
					   security issue, don't change
					   it -- use $QUERY_STRING intead */
#ifdef ESCAPE_META
					*cp2++ = '\\';
					*cp2++ = *cp++;
#else
					cp++;
					*cp2++ = ' ';
#endif
					break;
				default:
					*cp2++ = *cp++;
			}
		}
		*cp2 = '\0';
		if ( suspicious) {
			sprintf( buf, "Character %o in args", suspicious);
			writelog( "", "SECURITY", buf);
		}
	}
	else
		strcpy( buf, command);

	if ( *inputheader.tmpfile != '\0') {
		strcat( buf, " < ");
		strcat( buf, inputheader.tmpfile);
	}
	return (popen( buf, type));
}

