/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/init.c
    Version 2.14

    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/


#include <stdio.h>
#include <sys/types.h>
/*
#include <sys/file.h>
#include <sys/socket.h>
#include <netinet/in.h>
*/
#include <netdb.h>
#if defined( __STDC__) && !defined( NeXT)
#include <unistd.h>
#endif
#include <fcntl.h>
#include "gn.h"
#ifndef NO_SYSLOG
#include <syslog.h>
#endif

/* this may be needed if unistd.h isn't included... */
#ifndef SEEK_SET
#define SEEK_SET 0
#endif

#ifdef NO_VOID_PTR
#define	void	int
#endif

extern char *optarg;
extern int optind;

char	rootdir[PATHLEN],
	root_title[PATHLEN],
	cfname[PATHLEN],
	afname[PATHLEN],
	gnlogfile[PATHLEN],
	remotehost[MIDLEN],
	remaddr[SMALLLEN];

int	accesstype = FREE,
	chk_cache_id = FALSE,
	cache_id;

#ifndef NO_FLOCK
static void	locklog(),
		unlocklog();
#endif

static void	log_logfile ();

static FILE	*logfp = NULL;

#ifndef NO_SYSLOG
static void	log_syslog ();
#endif

static void	(*log_func) () = (void (*)()) NULL;

/*  Improved logging support thanks to Paul Dubois:

Logging can be done either to a named file, or using syslog.  If a named
file is used, it's locked if possible.

Two complications:
- Not all systems have flock(), or at least not flock()'s that have the
struct flock used below.
- syslog() isn't universally available.

To get around this, there are two levels of logging selection/restriction.
- The first level occurs at compile time, and compiles code only for
those facilities that are available.  (syslog() code isn't compiled if
NO_SYSLOG is defined, and the flock() stuff isn't compiled if
NO_FLOCK is defined.)

- The second level occurs at runtime and allows selection from such facilities
as are available.  Note that -L file can be given on the command line, but
if flock() isn't available, it's possible for the log file to be corrupted
by two competing gn processes.  -S is recommended as an alternative.  If
syslog() is unavailable, specifying -S on the command line prints a warning
and no logging is done.  -L file is recommended as an alternative.
*/

void
gn_init( argc, argv)
int	argc;
char	*argv[];
{
	int	c,
		errflg = 0;

/* Let's run as specified user and group if SET_UID defined.
 * This is imperitive if inetd cannot change UID from root.
 * (This has been tested with Ultrix 4.x.)
 */
#ifdef	SET_UID
#ifndef USERID
#define USERID	(-2)
#define GROUPID	(-2)
#endif
#ifndef STANDALONE  /* Otherwise this is done in standalone.c */
 	setgid(  (gid_t) GROUPID );   
 	setegid( (gid_t) GROUPID );
 	seteuid( (uid_t) USERID );
 	setuid(  (uid_t) USERID );  /* This pulls rug out from under us */
#endif
#endif

	*gnlogfile = '\0';
	*outheader.list = *outheader.status = '\0';
	strcpy( rootdir, ROOT_DIR);
	strcpy( root_title, ROOT_MENU_NAME);
	strcpy( cfname, CACHEFNAME);
	strcpy( afname, ACCESSFNAME);

	while ((c = getopt(argc, argv, "aAL:c:g:p:t:S:k:K")) != -1) {
		switch ((char) c) {
			case 'a':
				accesstype = ROOTCHK;
				break;
			case 'A':
				accesstype = DIRCHK;
				break;
			case 'L':
				strcpy( gnlogfile, optarg);
				log_func = log_logfile;
#ifndef STANDALONE
				open_gnlog( gnlogfile);
#endif
				break;
			case 'c':
				strcpy( cfname, optarg);
				break;
			case 'k':
				cache_id = atoi( optarg);
				chk_cache_id = CACHE_USE_UID;
				break;
			case 'K':
				cache_id = atoi( optarg);
				chk_cache_id = CACHE_USE_GID;
				break;
			case 'g':
				strcpy( afname, optarg);
				break;
#ifdef STANDALONE
			case 'p':
				port = atoi( optarg);
				break;
#endif
			case 't':
				strcpy( root_title, optarg);
				break;
			case 'S':
#ifdef NO_SYSLOG
				senderr2( "Option -S unavailable, no syslog",
						 "");
				exit( 2);
#else
				log_func = log_syslog;
#endif
				break;
			case '?':
				errflg++;
		}
	}

	if (errflg) {
#ifdef STANDALONE
		fprintf( stderr, "Usage: gn [-L logfile | -S] [-a | -A] ");
		fprintf( stderr, "[-c cache] [-p port] [-t title] \n");
		fprintf( stderr, "[-k cache_uid | -K cache_gid] [topdir]\n");
#else
		senderr2( "Unknown option given to server", "");
#endif
		exit (2);
	}
	if ( argv[optind] )
		strcpy( rootdir, argv[optind]);


#ifndef NO_SYSLOG
	if (log_func == log_syslog)
	{

# ifdef LOG_DAEMON
		/* 4.3 style */
		openlog ("gn", LOG_PID | LOG_NDELAY, LOG_DAEMON);
# else
		/* 4.2 style */
		openlog ("gn", LOG_PID);
# endif
	}
#endif
}

void
open_gnlog( logfile)
char	*logfile;
{
	if ( *logfile != '\0')
		if ( (logfp = fopen( logfile, "a")) == NULL ) {
#ifdef STANDALONE
			fprintf( stderr, "Can't open logfile: %s\n", logfile);
#else
			senderr2( "Can't open logfile", logfile);
#endif
			exit( 2);
		}
}


void
writelog( file, msg, msg2)
char	*file,
	*msg,
	*msg2;
{
	if (log_func != (void (*)()) NULL)
		(*log_func) (file, msg, msg2);
}


static void
log_logfile( file, msg, msg2)
char	*file,
	*msg,
	*msg2;
{
#ifndef NO_FLOCK
	struct flock	lck;
#endif
	time_t	clock;
	char	date[SMALLLEN],
		*ctime();

	time(&clock);
	strcpy( date, ctime(&clock));
	chop( date);

#ifndef NO_FLOCK
	locklog( &lck, fileno(logfp) );
#endif

	fseek( logfp, 0L, 2);   

#ifdef OLDGN_LOG_STYLE  /* logfile style for versions < 2.0 */
	fprintf(logfp, "%s: %s (%s): %s\n",  remotehost, msg, msg2, date);
#else
#ifdef GOPHERD_LOG_STYLE /* logfile style like UMN gopherd */
	fprintf(logfp, "%s %d %s : %s %s\n", 
			date, getpid(), remotehost, msg, msg2);
#else /* new style logfile for version >= 2.0 */
	fprintf(logfp, "%s: %s (%s): %s: %s\n",  
			remotehost, date, file, msg, msg2);
#endif
#endif

	(void) fflush(logfp);

#ifndef NO_FLOCK
	unlocklog( &lck, fileno(logfp) );   
#endif
}


#ifndef NO_FLOCK
static void
locklog(lck, fd)
struct flock	*lck;
int	fd;
{
	lck->l_type = F_WRLCK;
	lck->l_whence = SEEK_SET;
	lck->l_start = 0L;
	lck->l_len = 0L;
	fcntl(fd, F_SETLKW, lck);
}

static void
unlocklog( lck, fd)
struct flock	*lck;
int	fd;
{
	lck->l_type = F_UNLCK;
	fcntl( fd, F_SETLKW, lck);
}
#endif


#ifndef NO_SYSLOG

/*
 * syslog() provides the time automatically, no need to put it in the message.
 */

static void
log_syslog( file, msg, msg2)
char	*file,
	*msg,
	*msg2;
{
	syslog(LOG_INFO, "%s: (%s) %s %s",  remotehost, file, msg, msg2);
}
#endif



