/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/gn.h
    Version 2.14
    
    Copyright (C) 1994  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <ctype.h>
#include "../config.h"

#define VERSION	"GN/2.14"
#define HTTPVERSION "HTTP/1.0"
#define	PATHLEN	(4096)
#define	MAXLEN	(4096)
#define	ACCEPTLEN (3*MAXLEN)
#define	MAXPOST (20*MAXLEN)
#define MAXNUMHEADERLINES	(200)
#define BUFSIZE	(4096)
#define	MIDLEN	(1024)
#define SMALLLEN (256)

#define streq( a, b)	( strcmp( (a), (b)) == 0 )

#ifndef TRUE
#define TRUE	(1)
#endif

#ifndef FALSE
#define FALSE	(0)
#endif

#define CACHE_USE_UID	(100)
#define CACHE_USE_GID	(200)

#define DENYMSG	"Sorry, access denied or file does not exist"
#define FREE	(0)
#define ROOTCHK	(1)
#define DIRCHK	(2)
#define FULL	TRUE
#define PARTIAL	FALSE

#define NONE		(0)
#define HTTP0_9		(1)
#define HTTP1_0		(2)
#define HTTP1_0HEAD	(4)

/* These are possible values of entrytype field of Cache_entry */
#define	LOCAL		(1)
#define ILINE		(2)
#define REMGOPHER	(3)
#define REMGN		(4)
#define REMHTTP		(5)
#define HTTPTEXT	(6)
#define OWNER		(7)
#define FTPLINK		(8)
#define TELNETLINK	(9)

#define QUEBACKLOG	(10)

/* These are possible values of attribute field of Cache_entry */
#define INVISIBLE	(1)
#define NOSEARCH	(2)
#define GOPHERONLY	(3)
#define HTTPONLY	(4)
#define GNLINK		(5)
#define HTTPLINK	(6)



extern char	rootdir[],
		gnlogfile[],
		root_title[],
		cfname[],
		afname[],
		myhost[],
		myport[],
		remotehost[],
		remaddr[],
		cache_owner[],
		*get_input(),
		*get_cache_line(),
		*strlower();

extern int	errno,
		http,
		port,
		accesstype,
		cache_id,
		chk_cache_id,
		chkcache(),
		chkaccess();

extern void	gn_init(),
		do_standalone(),
		do_request(),
		process_url(),
		open_gnlog(),
		writelog(),
		chop(),
		sendtext(),
		sendbin(),
		senddir(),
		sendexec(),
		sendcache(),
		sendrange(),
		sendsearch(),
		sendhead(),
		sendcgi(),
		cache_search(),
		parse_selector(),
		cache_index(),
		get_remote_info(),
#ifdef DO_LINGER
		linger(),
#endif
		send_text_line(),
		send_cache_line(),
		www_cache_line(),
		www_unescape(),
		cache_prolog(),
		http_prolog(),
		cgi_env(),
		www_query(),
		www_err(),
		cache_epilog(),
		send_end(),
		senderr(),
		senderr2();

extern FILE	*safer_popen();

typedef struct Item {
	char	selector[PATHLEN],	/* The original selector */
		name[PATHLEN],		/* filled  by chkcache, used for www */
		gtype[PATHLEN],		/*
					 * Typically gopher type 0,1, etc.
					 * but really everything up to first
                                         * '/' in the selector
					 */
		filepath[PATHLEN],	/* Complete pathname of file  */
		relpath[PATHLEN],	/* Relative pathname of file  */
 		cachepath[PATHLEN],	/* Complete pathname of cache which */
					/* which contains this item */
 		accdir[PATHLEN],	/* path of access file directory */
		extra[PATHLEN],		/* Stuff after the last tab */
		args[PATHLEN],		/* Args for exec */
		content_type[MIDLEN],	/* MIME content type */
		mod_date[SMALLLEN],	/* File modification date */
		length[SMALLLEN],	/* File length */
		encoding[MIDLEN],	/* MIME content-transfer-encoding */
		suffix[SMALLLEN];	/* File name suffix */

	long	range_start,		/* Start and end of text file range */
		range_end;

	int	compressed;		/* True if file is compressed */

} Item;

extern Item	thisitem;


typedef struct Cache_entry {
	char	type1,			/*
					 * The single char type which is
					 * the first char in the .cache line
					 */
		name[MAXLEN],
		path[MAXLEN],
		host[MAXLEN],
		port[MAXLEN],
		cacheline[MAXLEN],
		content[MIDLEN],
		suffix[SMALLLEN],
		encoding[MIDLEN];	/* MIME content-transfer-encoding */

	int	entrytype,		/* 
					 * This can be REMGOPHER, REMGN,
                                         * LOCAL, COMMENT, OWNER, or HTTPTEXT,
					 */
		attribute,	/* e.g. INVISIBLE, NOSEARCH, 
					 * GOPHERONLY, HTTPONLY.
					 */

		hnameflag;		/*
					 * TRUE ==> name contains HTML
					 * FALSE ==> name contains plain text
					 */
} Cache_entry;

extern Cache_entry	*read_cache();


typedef struct Inheader {
	char	accept[ACCEPTLEN],
		method[SMALLLEN],
		content[SMALLLEN],
		encoding[SMALLLEN],	/* MIME content-transfer-encoding */
		length[SMALLLEN],
		ua[SMALLLEN],
		referer[MIDLEN],
		tmpfile[MIDLEN];
} Inheader;

extern Inheader	inputheader;

typedef struct Outheader {
	char	
		list[BUFSIZE],
		status[MIDLEN];
} Outheader;

extern Outheader	outheader;

