/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/gn.c
    Version 2.13
    
    Copyright (C) 1994  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/signal.h>
#include "gn.h"
#include "chkcache.h"

extern long	atol();
static void	do_post();

Item		thisitem;
Inheader	inputheader;
Outheader	outheader;

int		port = 0,
		http;


static char	*www_preparse();
static void	get_header();
extern int	daemon_init();

main( argc, argv)
int	argc;
char	*argv[];

{
	gn_init( argc, argv);

#ifdef	STANDALONE
	daemon_init();

	signal( SIGHUP, SIG_IGN);
	signal( SIGQUIT, SIG_IGN);
	signal( SIGINT, SIG_IGN);
	signal( SIGTERM, SIG_IGN);
	signal( SIGALRM, SIG_IGN);
	signal( SIGSYS, SIG_IGN);

	do_standalone();
	exit( 0);
#else
	alarm( TIMEOUT);  /* Timeout after TIMEOUT seconds */
	do_request();
	exit( 0);
#endif
}


void
do_request()

{
	char	selector[PATHLEN],
		*selp = selector;

	get_remote_info( remaddr, remotehost);
	strlower( remotehost);
#ifdef DO_LINGER
	linger(1, TIMEOUT);
#endif

	get_input( selector);
	strcpy( thisitem.selector, selector);

	/* If the first letter is in the following list it should
	   be an HTTP request					   */

	switch ( *selector) {
		case 'G':
		case 'H':
		case 'S':
		case 'P':
		case 'T':
			if ( (selp = www_preparse( selector)) == NULL)
				exit(0);
	}

	process_url( selp, &thisitem);
}


void
process_url( selp, ip)
char	*selp;
Item	*ip;
{
	int	itemtype;

	parse_selector( ip, selp, FULL);

	if ( chkaccess( ip, TRUE))
		itemtype = chkcache( ip);
	else
		itemtype = DENIED;

	switch (itemtype) {
		case ROOT:
			sendcache( ip);
			break;
		case TEXT:
			sendtext( ip);
			break;
		case RANGE:
			sendrange( ip);
			break;
		case DIR:
			sendcache( ip);
			break;
		case BIN:
			sendbin( ip);
			break;
		case EXEC:
			sendexec( ip);
			break;
		case CGI:
			sendcgi( ip);
			break;
		case SEARCH:
			sendsearch( ip);
			break;
		case HEADER:
			sendhead( ip);
			break;
		case COMMENT:
			exit( 0);
			break;
		case DENIED:
			senderr2( DENYMSG, ip->filepath);
			break;
		case UNKNOWN:
			senderr( "Unknown selector type", ip);
			break;
		default:
			senderr( "Unknown server error", ip);
	}
}


static char *
www_preparse( sel)
char	*sel;
{
	register char	*cp;
	char		errmsg[BUFSIZE];
	Inheader	*ih;

	ih = &inputheader;
	cp = sel;
	while ( *cp && !isspace( *cp))
		cp++;
	*cp++ = '\0';
	strncpy( ih->method, sel, SMALLLEN-1);
	sel = cp;
	while (  *sel && isspace( *sel))
		sel++;
	cp = sel;
	while (  *cp && !isspace( *cp))
		cp++;
	if ( *cp ) { /* There's more, check HTTP Version */
		*cp++ = '\0';
		while (  *cp && isspace( *cp))
			cp++;
		http = (streq( cp, "HTTP/0.9") ? HTTP0_9 : HTTP1_0);
	}
	else 
		http = HTTP0_9;

	if ( *sel == '/' )
		sel++;

	if ( streq( ih->method, "GET")) {
		if ( http & HTTP1_0 ) 
			get_header( ih);
		return sel;
	}
	if ( streq( ih->method, "POST") ) {
#ifdef FORBID_EXEC
		writelog( "", "SECURITY Post attempted", sel);
		exit( 2);
#else
		if ( http & HTTP1_0 ) {
			get_header( ih);
			if ( strncmp( sel, "CGI", 3) == 0)
				do_post( ih);
		}
		return sel;
#endif
	}

	if ( streq( ih->method, "HEAD") ) {
		http |= HTTP1_0HEAD;
		get_header( ih);
	}
	else {
		strcpy( errmsg, ih->method);
		strcat( errmsg, ": Method not implemented");
		www_err( "501", errmsg);
		sel = NULL;
	}
	return sel;
}



static void
get_header( ih)
Inheader	*ih;
{
	register char	*cp;
	char	headerline[BUFSIZE];
	int	acceptlen = 0,
		numlines = 0;

	ih->accept[0] = ih->content[0] = ih->length[0] = '\0';
	ih->encoding[0] = ih->tmpfile[0] = '\0';
	ih->referer[0] = ih->ua[0] = '\0';
	while ( get_input( headerline) != NULL) {
		if ( numlines++ > MAXNUMHEADERLINES) {
			writelog( "", "SECURITY", "Too many header lines");
			exit( 2);
		}
		if ( strncasecmp( headerline, "Accept:", 7) == 0 ) {
			cp = headerline + 7;

			while ( isspace( *cp))
				cp++;

			acceptlen += strlen( cp);
			if ( acceptlen > ACCEPTLEN - 20 )
				writelog( "", "Accept header overflow", "");
			else {
				strcat( ih->accept, cp);
				strcat( ih->accept, ",");
			}
			continue;
		}
		if ( strncasecmp( headerline, "Content-type:", 13) == 0 ) {
			cp = headerline + 13;
			while ( isspace( *cp))
				cp++;
			strcpy( ih->content, cp);
			continue;
		}
		if ( strncasecmp( headerline, "Content-length:", 15) == 0 ) {
			cp = headerline + 15;
			while ( isspace( *cp))
				cp++;
			strcpy( ih->length, cp);
			continue;
		}
		if ( strncasecmp( headerline, "Content-encoding:", 17) == 0 ) {
			cp =  headerline + 17;
			while ( isspace( *cp))
				cp++;
			strcpy( ih->encoding, cp);
			continue;
		}
		if ( strncasecmp( headerline, "Referer:", 8) == 0 ) {
			cp = headerline + 8;
			while ( isspace( *cp))
				cp++;
			strcpy( ih->referer,  cp);
			continue;
		}
		if ( strncasecmp( headerline, "User-Agent:", 11) == 0 ) {
			cp = headerline + 11;
			while ( isspace( *cp))
				cp++;
			strcpy( ih->ua, cp); 
			continue;
		}

		if ( *headerline == '\0') {
			if ( (cp = strrchr( ih->accept, ',')) != NULL)
				*cp = '\0';
			return;
		}
	}
}


static void
do_post( ih)
Inheader	*ih;
{
	long	len;
	int	c;
	char	tfile[PATHLEN];
	FILE	*fp;

	strcpy( tfile, TEMPDIR);
	strcat( tfile, "/gnpostXXXXXX");
	mktemp( tfile);
	strcpy( ih->tmpfile, tfile);

	if ( (fp = fopen( tfile, "w")) == (FILE *) NULL ) {
		senderr2( "Can't open post tempfile", tfile);
		exit( 2);
	}
	len = atol( ih->length);
	if ( len > MAXPOST || len < 0 ) {
		writelog( "", "SECURITY", 
			"Post input length too big or negative");
		fclose( fp);
		exit( 2);
	}

	while ( len && (c = fgetc( stdin )) != EOF) {
		len--;
		fputc( c, fp);
	}
	writelog( "", "Wrote post tempfile", tfile);
	fclose( fp);
}
