/********************************************************
 * CONFIGURATION FILE FOR THE GN PACKAGE (vers 2.08)
 ********************************************************/

/********************************************************
 * Compulsory items to fill in.
 ********************************************************/

#define SUN_OS4
/*
   Pick one of the following Operating System types which describes
   your system and replace the SUN_OS4 value above

   AIX
   AUX
   CONVEX_0S
   HPUX
   IRIX
   LINUX
   NEXT
   OSF1
   PYRAMID
   SCO
   SEQUENT
   SOLARIS2
   SUN_OS4
   SVR4
   ULTRIX
   OTHER

   I have no way to test all these, let me know if something doesn't work
   or is incomplete.  If you pick OTHER you must edit the last few lines
   of this file per the directions there.
*/


#define MAINTAINER	"mailto:john@hopf.math.nwu.edu"
/*
 * Enter "mailto:" followed by the e-mail address of the individual
 * responsible for maintaining your server.  This is a default and
 * can be changed on a per directory basis.  It is used only by WWW
 * clients.
 */


#define GN_HOSTNAME	"hopf.math.nwu.edu"
/*
 * Enter your fully qualified host name here
 */


#define ROOT_DIR	"/home/john/usr/gnupher"
/*
 * Enter the complete path of your root data directory here.
 */


#define ROOT_MENU_NAME	"GN --  A Gopher/HTTP Server"
/*
 * Enter a name for your root directory.  This is used by WWW only, 
 * there is no way for a gopher server to specify the title of the
 * root menu.
 */


#define MIME_TYPE_FILE  "/home/john/usr/gnupher/mkcache/gn_mime.types"
/*
 * This file contains information permitting mkcache to translate 
 * ascertain the MIME "Content-type" from the suffix of a file name
 * together with the gopher type of the file.  This information is
 * necessary for HTTP/1.0 clients to know how to display
 * files.  If this file is not present mkcache will issue a warning
 * but use internal default values.  The file exists so that you
 * can add to it if you wish to add new kinds of documents to your
 * server.  The format of the file is explained in the file.
 * The default version of the file is in mkcache/gn_mime.types.
 * The internal defaults are the same as what is currently in this
 * file.
 */


#define WAISGN  "/usr/local/etc/waisgn"
/*
 * This is the complete path name of the waisgn program which 
 * handles WAIS indexes.  If you do not use WAIS indexing use 
 * a value of "".
 * NOTE: THIS MUST BE THE SAME AS $(SERVBINDIR)/waisgn AS SERVBINDIR
 * IS DEFINED IN THE MAKEFILE IF YOU USE MAKE INSTALL TO INSTALL waisgn.
 */



/*
 ****************************************************************
 * This is the end of the compulsory fill out items (unless you
 * picked OTHER as your OS type above).  If you wish you can change
 * the following defaults; it is a good idea to at least look them
 * over.
 ****************************************************************
 */


#define USERID		(65534)
#define GROUPID		(65534)
/*
 * These are the group and user id you want the server to run as when
 * running as sgn (i.e. standalone).  They are also used by gn running
 * under inetd if SET_UID is defined.  This is for systems like Ultrix
 * which can't set these in inetd.conf file
 */


#define DEFAULTPORT	"70"
/*
 * If you wish to run at a different port than 70, edit this line.
 */

#define DECOMPRESS	"/usr/net/bin/zcat"
/*
 * This is the program which does "on the fly" decompression
 */


#define ACCESSFNAME	".access"

#define CACHEFNAME	".cache"

#define MENUFNAME	"menu"

#define TEMPDIR		"/tmp"

#define MAXDEPTH	(10)    /* maximum depth of menus to search */

#define TIMEOUT (600)		/* Time in seconds to wait before timeout */
				/* Ten minutes should be more than adequate */

#define CGI_EXT		".cgi"  /* File extension for CGI scripts	*/

#define SEARCHABLE_ROOT	TRUE
/*
 * Change to FALSE to prevent searching of the items in the root directory
 */



/*
 * #define GOPHERD_LOG_STYLE
 * #define OLDGN_LOG_STYLE
 * Uncomment one of these for log files like those of gopherd or gn 
 * in versions before 2.0.
 */

/*
 * #define ESCAPE_META
 *
 * Ucomment this at your peril.  Several people has asked for the 
 * capability to pass all characters to shell scripts (type exec0, etc.), 
 * with the dangerous ones escaped with a backslash.  The normal behavior
 * is replace all the characters which have a special meaning to the
 * shell like ';' or '|' with a space.  This is done as a security
 * measure.  Escaping these characters with a backslash, as near as I can
 * tell, is secure for the shell which gn invokes to run your script or
 * program.  But it does nothing to protect any scripts *you* write.  I
 * don't advise using this.  If you uncomment this keep in mind that if
 * your script contains the line "echo $1" that $1 might be equal to 
 * "Tough luck!; rm *" so your command is turned into "echo Tough luck!;
 * rm *".  (By the way, if you are running with the user properly set to
 * 'nobody' in inetd.conf, no damage should be done by this particular 
 * command.  Anyway the capability is there if you feel confident using
 * it.  I don't use it.
 * 
 */


/*
 * #define DO_LINGER
 *
 * Uncomment this if you have problems with truncated documents being
 * returned to requests from remote hosts.
 *
 */

/********************************************************
 * Edit the lines in this section if you chose OTHER as 
 * your OS type.
 ********************************************************/


#if defined(OTHER)   /* Don't change this line */


#define BSD
/*
 * This should be defined if your system is BSD-like, i.e. tends
 * to use BSD system calls rather than SysV system calls.
 */


/* #define NO_FLOCK */
/*
 * Uncomment this if your system does not have the flock() system call.
 * Doing this means that if more than one client is using your server 
 * at the same time, your logfile might be garbled.  There are no other
 * ill effects.
 *
 */


/*
 * #define SET_UID
 *
 *  Uncomment this if you are using an inetd without the capability 
 *  to set UID on startup (e.g., Ultrix). The user id and group id
 *  under which gn runs will then be set to the values of USERID and
 *  GROUPID set above.
 */

/*
 * #define NO_SYSLOG
 *
 * Uncomment this if your system does not have the openlog()/syslog()
 * system calls.  Doing this means that you won't be able to have your
 * log entries put in the system log ( the "-S" option to gn).  You
 * can still use the "-L" option to write the entries to a named log file.
 *
 */

/*
 * #define NO_VOID_PTR
 *
 * Uncomment this if your compiler does not support void pointers.
 *
 */

/*
 * #define NEED_PUTENV
 *
 * Uncomment this if your compiler library does not have the function
 * putenv().  
 *
 */

/*
 * #define NEED_STRFTIME
 *
 * Uncomment this if your compiler library does not have the function
 * strftime()
 *
 */

/*
 * #define NEED_STRNCASECMP
 *
 * Uncomment this if your compiler library does not have the function
 * strcasecmp()
 *
 */

#endif

/*************************************************************
 * Hopefully you shouldn't need to change things below here.
 *************************************************************/


#if defined(SUN_OS4)
#define BSD
#endif

#if defined(SOLARIS2)
#define bzero(A,B)   memset((void *)(A),0,(B))
#undef BSD
#endif

#if defined(AIX) || defined(IRIX)
#undef BSD
#endif

#if defined(BSD_386)
#define BSD
#endif

#if defined(HPUX)
#undef BSD
#define _HPUX_SOURCE
#endif

#if defined(ULTRIX)
#define BSD
#define SET_UID
#endif

#if defined(OSF1)
#define BSD
#define _BSD
#endif

#if defined(SEQUENT)
#define BSD
#define NO_SETSID
#endif

#if defined(NEXT)
#define BSD
#define NEED_PUTENV
#define NO_SETSID
#define _POSIX_SOURCE
typedef	int	pid_t;
#ifndef S_ISDIR
#define S_ISDIR(m)      (((m)&(S_IFMT)) == (S_IFDIR))
#endif
#endif

#if defined(LINUX) || defined(SCO) || defined(CONVEX_OS)
#undef BSD
#define DO_LINGER
#endif

#if defined(PYRAMID)
#define NEED_PUTENV
#define NEED_STRFTIME
#define NO_SETSID
#endif

#if defined(AUX)
#undef BSD
#define _POSIX_SOURCE
#endif

#if defined(SVR4)
#define bzero(A,B)   memset((void *)(A),0,(B))
#define DO_LINGER
#define NEED_STRNCASECMP
#endif
