/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/cgi.c
    Version 2.13
    
    Copyright (C) 1993  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/

#include <stdio.h>
#include <string.h>
#include "gn.h"

static void	dolocation();


/*
 * sendcgi( ip)  Open pipe from "ip->filepath" command
 * and send output using CGI standards
 */

void
sendcgi(  ip)
Item	*ip;
{
	FILE	*fp;
	register int	c;

	char	*cp,
		command[MAXLEN],
		location[MAXLEN],
		buf[MAXLEN];

	if ( ! (http & HTTP1_0) ) {
		senderr2( "CGI programs require HTTP/1.0", ip->filepath);
		exit( 2);
	}

	location[0] = '\0';
	cgi_env( ip);

	strcpy( command, ip->filepath);
	strcpy( buf, ip->filepath);
	cp = strrchr( buf, '/');
	*cp = '\0';
	if ( chdir( buf) != 0  )
		writelog( "", "Can't chdir for exec to", buf);

	if ( *inputheader.tmpfile != '\0') {
		strcat( command, " < ");
		strcat( command, inputheader.tmpfile);
	}

	if ( !*ip->extra || (strchr( ip->extra, '=') != NULL)) {
		if ((fp = popen( command, "r")) == (FILE *) NULL ) {
			senderr2( "Can't exec CGI program", ip->filepath);
			unlink( inputheader.tmpfile);
			exit( 2);
		}
	} else if ( (fp = safer_popen( ip->filepath, ip->extra, "cgi"))
				 == (FILE *) NULL ) {
		if ( (fp = popen( command, "r")) 
					== (FILE *) NULL ) {
			senderr2( "Can't exec CGI program", ip->filepath);
			unlink( inputheader.tmpfile);
			exit( 2);
		}
	}

	if ( ( cp = strrchr( ip->filepath, '/')) &&
					( strncmp( ++cp, "nph-", 4) == 0)) {
		while ( (c = fgetc( fp )) != EOF)
			fputc( c, stdout);
		pclose( fp);
		writelog( ip->relpath, "Sent CGI output [nph]", ip->selector);
		unlink( inputheader.tmpfile);
		exit(0);
	}

	while ( fgets( buf, BUFSIZE, fp)) {
		if ( *buf == '\n' )	/* blank line: end of header */
			break;

		if ( strncmp( "Content-type:", buf, 13) == 0) {
			chop( buf);
			cp = buf + 13;
			while ( isspace( *cp))
				cp++;
			strcpy( ip->content_type, cp);
		}
		else if ( (strncmp("Location:", buf, 9) == 0)) {
			chop( buf);
			cp = buf + 9;
			while ( isspace( *cp))
				cp++;
			strcpy( location, cp);
		}
		else if ( (strncmp("Status:", buf, 7) == 0)) {
			chop( buf);
			cp = buf + 7;
			while ( isspace( *cp))
				cp++;
			strcpy( outheader.status, cp);
		}
		else {
			if ( strlen(buf) + strlen(outheader.list) < BUFSIZE ) {
				chop( buf);
				strcat( outheader.list, buf);
				strcat( outheader.list, "\r\n");
			}
			else {
				www_err( "500", "CGI headers too big");
				unlink( inputheader.tmpfile);
				exit( 2);
			}

		}
	}

	if ( !*location) {
		http_prolog( ip);
		while ( (c = fgetc( fp )) != EOF)
			fputc( c, stdout);
		pclose( fp);
		writelog( ip->relpath, "Sent CGI output", ip->selector);
		unlink( inputheader.tmpfile);
		exit(0);
	}
	else {
		writelog( ip->relpath, "Sent CGI redirection", ip->selector);
		sprintf( ip->selector, "CGI redirect to %s", location);
		dolocation( location, ip);
		pclose( fp);
		unlink( inputheader.tmpfile);
		exit(0);
	}
}

void
cgi_env( ip)
Item	*ip;
{
	register char	*cp;
	static char	serv_protocol[SMALLLEN],
			servsoft[SMALLLEN],
			dataroot[MAXLEN],
			query[MAXLEN],
			pathinfo[MAXLEN],
			tpath[MAXLEN],
			scrname[MAXLEN],
			http_accept[ACCEPTLEN],
			http_referer[MIDLEN],
			http_ua[SMALLLEN],
			lochost[MIDLEN],
			lport[SMALLLEN],
			rhost[MIDLEN],
			raddr[SMALLLEN],
			method[SMALLLEN],
			content[MIDLEN],
			length[SMALLLEN];

	strcpy( serv_protocol, "SERVER_PROTOCOL=");

	switch ( http) {
	case HTTP0_9:
		strcat( serv_protocol, "HTTP/0.9");
		break;
	case HTTP1_0:
		strcat( serv_protocol, "HTTP/1.0");
		break;
	default:
		strcat( serv_protocol, "GOPHER");
	}

	putenv( serv_protocol);

	strcpy( dataroot, "GN_ROOT=");
	strcat( dataroot, rootdir);
	putenv( dataroot);

	strcpy( query, "QUERY_STRING=");
	strcat( query, ip->extra);
	putenv( query);

	strcpy( pathinfo, "PATH_INFO=");
	strcat( pathinfo, ip->args);
	putenv( pathinfo);

	strcpy( tpath, "PATH_TRANSLATED=");
	strcat( tpath, rootdir);
	strcat( tpath, ip->args);
	putenv( tpath);

	cp = ip->filepath + strlen( rootdir);
	if ( strncmp( ip->gtype, "exec", 4) == 0)
		sprintf( scrname, "SCRIPT_NAME=%s:%s:%s",
			ip->gtype, ip->args, cp);
	else
		sprintf( scrname, "SCRIPT_NAME=%s%s", ip->gtype, cp);
	putenv( scrname);

	strcpy( lochost, "SERVER_NAME=");
	strcat( lochost, myhost);
	putenv( lochost);

	strcpy( lport, "SERVER_PORT=");
	strcat( lport, myport);
	putenv( lport);

	putenv("GATEWAY_INTERFACE=CGI/1.1");
	
	strcpy( method, "REQUEST_METHOD=");
	strcat( method, inputheader.method);
	putenv( method);

	strcpy( content, "CONTENT_TYPE=");
	strcat( content, inputheader.content);
	putenv( content);

	strcpy( length, "CONTENT_LENGTH=");
	strcat( length, inputheader.length);
	putenv( length);

	strcpy( rhost, "REMOTE_HOST=");
	strcat( rhost, remotehost);
	putenv( rhost);

	strcpy( raddr, "REMOTE_ADDR=");
	strcat( raddr, remaddr);
	putenv( raddr);

	strcpy( servsoft, "SERVER_SOFTWARE=");
	strcat( servsoft, VERSION);
	putenv( servsoft);

	if ( *(inputheader.accept) ) {
		strcpy( http_accept, "HTTP_ACCEPT=");
		strcat( http_accept, inputheader.accept);
		putenv( http_accept);
	}
	if ( *(inputheader.referer) ) {
		strcpy( http_referer, "HTTP_REFERER=");
		strcat( http_referer, inputheader.referer);
		putenv( http_referer);
	}

	if ( *(inputheader.ua) ) {
		strcpy( http_ua, "HTTP_USER_AGENT=");
		strcat( http_ua, inputheader.ua);
		putenv( http_ua);
	}
}

static void
dolocation( path, ip)
char	*path;
Item	*ip;
{
	register char	*cp;
	char	buf[BUFSIZE];

	if ( (( cp = strchr( path, ':')) != NULL) && cp[1] == '/' 
		&& cp[2] == '/') { /* URL rediretion */

		sprintf( buf, "%s 302 Found\r", HTTPVERSION);
		send_text_line( buf);
		sprintf( buf, "Location: %s\r", path);
		send_text_line( buf);
		send_text_line( "");
		return;
	}
	/* It's a local path */
	if ( *path == '/')
		path++;
	process_url( path, ip);
}



		