	org	0100
	jmp	RealStart		; Leave some space!

	db	'DO was written by Christ van Willegen, on 94-08-30',0d,0a

	org	0140
RealStart:
	mov	si,0082			; First nybble
	mov	di,0100			; First image offset
	mov	es,cs			; Make all segs the same
	mov	ds,cs
	xor	cx,cx			; We start with 0 bytes read
DecodeLoop:
	lodsb				; Get nybble
	cmp	al,' '			; Are we done yet?
	jbe	Done

	sub	al,'0'			; Make it a hex digit
	cmp	al,0a			; Too big?
	jnae	SecondNybble
	sub	al,'A'-'9'-1		; Make it smaller...
SecondNybble:
        shl	al,1			; Upper nybble, shift 4 bits
        shl	al,1
        shl	al,1
        shl	al,1
	mov	bl,al			; And save for later...

	lodsb				; Get second nybble
	sub	al,'0'			; Do the same...
	cmp	al,0a
	jnae	StoreDone
	sub	al,'A'-'9'-1
StoreDone:
	or	al,bl			; Make it a whole byte
	stosb				; Store it in memory
	inc	cx			; Take a note
	jmp	DecodeLoop		; And do the rest

Done:
	mov	al,0cd			; 'INT'
	stosb
	mov	al,020			; 20 (INT 20 = stop program)
	stosb

	shl	cl,1			; Count all nybbles!
	inc	cl			; And the space at the start

	mov	bl,[080]		; How many bytes were there?
	sub	bl,cl		        ; How many arguments are left?

	mov	cl,bl			; For the loop counter...
	mov	di,082

	mov     [080],cl		; Fix number of arguments
	jcxz	StartImage
MoveArgs:
	lodsb				; Get argument byte
	stosb				; And store it
	dec	cx			; Next byte
	jcxz	StartImage		; Done?
	jmp	MoveArgs		; No
StartImage:
	jmp	0100			; Yes, execute the new-formaed image
