/*
 * Copyright (c) 1992, Brian Berliner and Jeff Polk
 * Copyright (c) 1989-1992, Brian Berliner
 * 
 * You may distribute under the terms of the GNU General Public License as
 * specified in the README file that comes with the CVS 1.3 kit.
 * 
 * Create Administration.
 * 
 * Creates a CVS administration directory based on the argument repository; the
 * "Entries" file is prefilled from the "initrecord" argument.
 */

#include "cvs.h"

#ifndef lint
static char rcsid[] = "@(#)create_adm.c 1.24 92/03/31";
#endif

void
Create_Admin (dir, repository, tag, date)
    char *dir;
    char *repository;
    char *tag;
    char *date;
{
    FILE *fout;
    char *cp;
    char tmp[PATH_MAX];

    if (noexec)
	return;

    if (!isdir (repository))
	error (1, 0, "there is no repository %s", repository);

    if (dir != NULL)
	(void) sprintf (tmp, "%s%c%s", dir, DIRSEP, CVSADM);
    else
	(void) strcpy (tmp, CVSADM);

    if (isfile (tmp))
	error (1, 0, "there is a version here already");
    else
    {
	if (dir != NULL)
	    (void) sprintf (tmp, "%s%c%s", dir, DIRSEP, OCVSADM);
	else
	    (void) strcpy (tmp, OCVSADM);

	if (isfile (tmp))
	    error (1, 0, "there is a version here already");
    }

    if (dir != NULL)
	(void) sprintf (tmp, "%s%c%s", dir, DIRSEP, CVSADM);
    else
	(void) strcpy (tmp, CVSADM);
    make_directory (tmp);

    if (dir != NULL)
	(void) sprintf (tmp, "%s%c%s", dir, DIRSEP, short_names ? CVSADM_REP_S : CVSADM_REP);
    else
	(void) strcpy (tmp, short_names ? CVSADM_REP_S : CVSADM_REP);
    fout = open_file (tmp, "w+");
    cp = repository;
    strip_path (cp);

#ifdef RELATIVE_REPOS
    /*
     * If the Repository file is to hold a relative path, try to strip off
     * the leading CVSroot argument.
     */
    if (CVSroot != NULL)
    {
	char path[PATH_MAX];

	(void) sprintf (path, "%s%c", CVSroot, DIRSEP);
	if (strncmp (repository, path, strlen (path)) == 0)
	    cp = repository + strlen (path);
    }
#endif

    if (fprintf (fout, "%s\n", cp) == EOF)
	error (1, errno, "write to %s failed", tmp);
    if (fclose (fout) == EOF)
	error (1, errno, "cannot close %s", tmp);

    /* now, do the Entries file */
    if (dir != NULL)
	(void) sprintf (tmp, "%s%c%s", dir, DIRSEP, CVSADM_ENT);
    else
	(void) strcpy (tmp, CVSADM_ENT);
    fout = open_file (tmp, "w+");
    if (fclose (fout) == EOF)
	error (1, errno, "cannot close %s", tmp);

    /* Create a new CVS/Tag file */
    WriteTag (dir, tag, date);
}
