{*************************************************************************

DEMO 2

Demonstrates the speed difference between compiled bitmap,  conventional
masked planar bitmap, and video bitmap blits.

**************************************************************************}


Program Demo2;

Uses
	Crt, Xlib;

const
	turtle : array[0..601] of byte =
	( 20,30,
		8,14, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		8, 2,14, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		8, 2, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		8, 0, 2,14, 0, 0,14,14,14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		8, 0, 2, 5, 0, 4, 4, 4, 4,14,14, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		8, 0, 2, 2, 4, 4, 0, 4, 4, 0, 4,14, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 2, 4, 4, 4, 0, 4, 4, 0, 4, 4,14, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 2, 4, 4, 4, 0, 0, 0, 0, 4, 4,14, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 4, 0, 4, 4, 4, 0, 0, 0, 4, 0, 0, 2, 2, 0, 0, 0,
		0, 0, 0, 4, 0, 4, 4, 4, 0, 4, 4, 4, 0,14, 0, 0, 2, 2, 0, 0,
		0, 0, 0, 4, 4, 0, 0, 0, 4, 4, 0, 4, 0, 4, 2, 2, 2, 2, 0, 0,
		0, 0, 0, 4, 4, 4, 0, 4, 4, 0, 4, 4, 0, 4,14, 2, 2, 2, 0, 0,
		0, 0, 0, 4, 4, 4, 0, 0, 0, 4, 4, 0, 4, 0, 0, 2, 2, 0, 0, 0,
		0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 0, 4, 4,14, 2, 0, 0, 0, 0,
		0, 0, 2, 2, 0, 4, 4, 4, 4, 0, 0, 4, 4, 4, 4, 0, 0, 0, 0, 0,
		2, 2, 2, 2, 4, 0, 0, 4, 4, 0, 4, 4, 0, 4,14, 0, 0, 0, 0, 0,
		0, 2, 2, 0, 4, 4, 4, 0, 0, 4, 4, 0, 4, 0, 2, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 4, 4, 0, 4, 4, 4, 0, 4, 4, 2,14, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 0, 4, 0, 2, 2,14,14, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 4, 4, 2, 2, 2, 2, 2,14, 0,
		0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 5,14, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 2, 2, 0, 0, 2, 2, 2, 0, 2,14,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2,14,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );


var
	newfnt, pbm, vbm : pointer;


Function AllocatedSprite( width, height, logicalwidth : integer; var bitmap ) : pointer;
var
	result : pointer;
	size : integer;
begin
	getmem(pbm,width * height + 2);
	xbmtopbm(bitmap,pbm^);
	size := XSizeOfCBitmap( logicalwidth, bitmap );
	getmem( result, size );
	XCompileBitmap( logicalwidth, bitmap, result^ );
	AllocatedSprite := result;
end;

Procedure loaduserfonts;
var
	f : file;
	i : integer;
begin
	assign(f,'d:\bp\xlib\smalthin.fnt');
	reset(f,1);
	getmem(newfnt,filesize(f));
	blockread(f,newfnt^,filesize(f));
	close(f);
	xtextinit;
	xregisteruserfont(newfnt^);
	xsetfont(2);
end;

procedure main;
var
	i,j,k : integer;
	ratio,ratio2 : real;
	pbmt0, pbmt1, vbmt0, vbmt1, cbmt0, cbmt1, vbmticks,pbmticks,cbmticks : longint;
	TurtleSprite : pointer;
	timer : longint absolute $0040:$006C;
begin
	xsetmode(XMODE320x240,360);
	TurtleSprite := AllocatedSprite(20, 30, 90,turtle);

	vbm := xmakevbm(turtle,NonVisualOffs);
	loaduserfonts;
	xprintf(0,0,0,14,'This is a demo to show the speed difference between');
	xprintf(0,8,0,14,'compiled, planar and video bitmaps.  The bitmap:');
	xputcbitmap(140, 18, 0, TurtleSprite^);
	xprintf(0,48,0,14,'This demo uses the NON CLIPPED, MASKED versions of');
	xprintf(0,56,0,14,'       ''PBM'' and ''VBM'' put functions');
	xprintf(0,78,0,14,'Press a key to start with PLANAR BITMAP demo');
	readkey;
	xrectfill(0,0,ScrnPhysicalPixelWidth,ScrnPhysicalHeight,0,0);
	pbmt0 := timer;
	for k:=0 to 10 do
		for j:=0 to (ScrnPhysicalHeight div 30)-1 do
			for i:=0 to (ScrnPhysicalPixelWidth div 20)-1 do
				xputmaskedpbm(i*20, j*30, 0, pbm^);
	pbmt1 := timer;
	pbmticks := abs(pbmt1-pbmt0);


	xprintf(0,0,0,14,'Press a key to start with the VIDEO BITMAP demo');

	readkey;
	xrectfill(0,0,ScrnPhysicalPixelWidth,ScrnPhysicalHeight,0,0);
	vbmt0 := timer;
	for k:=0 to 10 do
		for j:=0 to (ScrnPhysicalHeight div 30)-1 do
			for i:=0 to (ScrnPhysicalPixelWidth div 20)-1 do
				xputmaskedvbm(i*20, j*30, 0, vbm^);
	vbmt1 := timer;
	vbmticks := abs(vbmt1-vbmt0);
	xprintf(0,0,0,14,'Now Press a key to start with COMPILED BITMAP demo');
	readkey;
	xrectfill(0,0,ScrnPhysicalPixelWidth,ScrnPhysicalHeight,0,0);
	cbmt0 := timer;
	for k:=0 to 10 do
		for j:=0 to (ScrnPhysicalHeight div 30)-1 do
			for i:=0 to (ScrnPhysicalPixelWidth div 20)-1 do
				xputcbitmap(i*20, j*30, 0, TurtleSprite^);
	cbmt1 := timer;
	cbmticks := abs( cbmt1-cbmt0);
	ratio := pbmticks/cbmticks;
	ratio2 := vbmticks/cbmticks;
	{xsetfont(1);
	xprintf(0,ScrnPhysicalHeight-30,0,14,'s/100 PBM=%ld VBM=%ld CBM=%ld - %4.1lf:%4.1lf:1'
	,pbmticks,vbmticks,cbmticks,ratio,ratio2);}
	{xsetfont(2);
	xprintf(0,ScrnPhysicalHeight-16,0,14,'Timing is rough but still,  quite impressive ! ');
	xprintf(0,ScrnPhysicalHeight-8,0,14,'Clipping slows things down considerably. ');}
	xtextmode;
	writeln('Planar Bitmaps   = ',pbmticks);
	writeln('Video Bitmaps    = ',vbmticks);
	writeln('Compiled Bitmaps = ',cbmticks);
	writeln;
	writeln('PBM/CBM          = ',ratio:8:10);
	writeln('VBM/CBM          = ',ratio2:8:10);
	readkey;
end;

begin
	main;
end.
