Program Test2D;
{ E.Sorokin, 1996 }
{
  Demo program for LArrayS unit.
  Define a large 2D-array type.
  Define a NxN 2D-array (matrix), and transpose it.
}

uses LArrays
{$IFDEF WINDOWS}, WinCrt {$ENDIF}
;

const rows= $100 * 2;

type  P2D =^T2D;
      T2D = object (TAbstArray)
              RowSize : longint;
              constructor Alloc( cols, rows : longint; ESize : word);
              function IJth(i,j : longint) : pointer;
              function GetIJ(i,j : longint; var Value) : boolean;
              function PutIJ(i,j : longint; var Value) : boolean;
            end;

constructor T2D.Alloc;
begin
  If not inherited Alloc(longint(cols)*rows, ESize) then Fail;
  RowSize:=cols;
end;

function T2D.IJth;
begin
  IJth:=Nth( j-1 + (i-1)*RowSize );
end;

function T2D.GetIJ;
begin
  GetIJ:=Get( j-1 + (i-1)*RowSize, Value);
end;

function T2D.PutIJ;
begin
  PutIJ:=Put( j-1 + (i-1)*RowSize, Value);
end;

type  P2Matrix =^T2Matrix;
      T2Matrix = object (T2D)
              constructor Alloc( TheRank : word; ESize : word);
              procedure Transpose;
              function Rank : word;
            end;

constructor T2Matrix.Alloc;
begin
  If not inherited Alloc(TheRank, TheRank, ESize) then Fail;
end;

function T2Matrix.Rank;
begin
  Rank:=RowSize;
end;

procedure T2Matrix.Transpose;
var i,j : longint;
begin
  for i:=1 to Rank do begin
    for j:=1 to i-1 do begin
      Swap( j-1 + (i-1)*RowSize,  i-1 + (j-1)*RowSize);
    end;
  end;
end;


type LBrec = record B: bytebool; L : longint; end;
     PLB = ^LBRec;

var a,b : T2Matrix;
    lb : LBRec; p: PLB;
    i,j : longint;

begin
  if not a.alloc( rows, sizeof(LBrec) ) then exit;
  Writeln('Allocated a 2D Matrix, with altogether ',a.size, ' elements');
    Write(a.Pages,' pages, ', a.PageSize, ' elements per page');
  If a.LastPageSize <> 0 then
    Writeln(', except the last.')
  else
    Writeln ('.');

    {Using putIJ}
  for i:=1 to rows do begin
    for j:=1 to rows do begin
      lb.L:=i-j;
      lb.B:=True;
      a.PutIJ(i,j,lb);
    end;
  end;
    {Using copy constructor}
  if not b.Copy(@a) then exit;
  b.Transpose;

  writeln('Checking errors . .');
    {Using IJth}
  for i:=1 to rows do begin
    for j:=1 to i do begin
      If PLB(b.IJth( i, j ))^.L <> PLB(a.IJth( j, i ))^.L then
               {     ^^^^^                     ^^^^^   }
         Writeln(' Error at i=',i,', j=',j, ': ',PLB(b.IJth(i,j))^.L);
    end;
  end;

end.