{$S-,R-,V-,I-,B-,F-,O-,A-}

{*    E. Sorokin 1991-1996      *}

unit MinMaxS;

  {-Some useful arithmetic functions}

interface

function LCML(L1,L2 : longint) : longint;
function LCMW(W1,W2 : word) : longint;
  {-Least common multiple}

function GCDW(W1,W2 : word) : word;
function GCDL(L1,L2 : longint) : longint;
  {-Greatest common divisor}

function DivUp(What, By : longint) : longint;
	{-Divide and round up}

function MinWord(A, B : Word) : Word;
	{-Returns the lower of A and B}
	inline(
		$58/                     {pop ax}
		$5B/                     {pop bx}
		$39/$C3/                 {cmp bx,ax}
		$73/$02/                 {jae done}
		$89/$D8);                {mov ax,bx}
														 {done:}

function MaxWord(A, B : Word) : Word;
	{-Returns the higher of A and B}
  inline(
    $58/                     {pop ax}
    $5B/                     {pop bx}
    $39/$C3/                 {cmp bx,ax}
    $76/$02/                 {jbe done}
    $89/$D8);                {mov ax,bx}
														 {done:}

function MaxInteger(A, B : integer) : integer;
	{-Returns the greater of A and B}
	inline(
		$58/											{	POP	AX			}
		$5B/											{	POP	BX      }
		$3B/$C3/    							{	CMP	AX,BX		}
		$7D/$02/									{	JGE	done:		}
		$89/$D8);									{	MOV	AX,BX		}
															{done:				}

function MinInteger(A, B : integer) : integer;
	{-Returns the smaller of A and B}
	inline(
		$58/	                    { POP AX      }
		$5B/                      { POP BX      }
		$3B/$C3/                  { CMP AX,BX   }
		$7C/$02/                  { JGE done:   }
		$89/$D8);                 { MOV AX,BX   }
                              {done:        }

function MinLong(A, B : LongInt) : LongInt;
  {-Returns the smaller of A and B}
  inline(
    $5B/                     {pop bx       ;CX:BX = B}
    $59/                     {pop cx}
    $58/                     {pop ax       ;DX:AX = A}
    $5A/                     {pop dx}
    $39/$CA/                 {cmp dx,cx    ;compare high byte}
    $7C/$0A/                 {jl  done1    ;A < B?}
    $7F/$04/                 {jg  greater  ;A > B?}
    $39/$D8/                 {cmp ax,bx    ;compare low byte}
    $76/$04/                 {jbe done1    ;A <= B?}
                             {greater:}
    $89/$CA/                 {mov dx,cx    ;A is greater}
    $89/$D8);                {mov ax,bx}
                             {done1:}

function MaxLong(A, B : LongInt) : LongInt;
  {-Returns the greater of A and B}
  inline(
    $5B/                     {pop bx       ;CX:BX = B}
    $59/                     {pop cx}
    $58/                     {pop ax       ;DX:AX = A}
    $5A/                     {pop dx}
    $39/$CA/                 {cmp dx,cx    ;compare high byte}
    $7F/$0A/                 {jg  done2    ;A > B?}
    $7C/$04/                 {jl  less     ;A < B?}
    $39/$D8/                 {cmp ax,bx    ;compare low byte}
    $73/$04/                 {jae done2    ;A >= B?}
                             {less:}
    $89/$CA/                 {mov dx,cx    ;B is greater}
    $89/$D8);                {mov ax,bx}
                             {done2:}

procedure NegShort( var A : shortint);
Inline(
  $5F/                   {    pop di}
  $07/                   {    pop es}
  $26/$F6/$1D);          {    es: neg byte ptr [di]}

procedure NegInt( var A : integer);
Inline(
  $5F/                   {    pop di}
  $07/                   {    pop es}
  $26/$F7/$1D);          {    es: neg word ptr [di]}
   
procedure NegLong( var A : LongInt);
Inline(
  $5F/                   {    pop di}
  $07/                   {    pop es}
  $26/$8B/$55/$02/       {    es: mov dx, [di+2]}
  $F7/$D2/               {    not dx}
  $26/$F7/$1D/           {    es: neg word ptr [di]}
  $83/$DA/$FF/           {    sbb dx, $ffff}
  $26/$89/$55/$02);      {    es: mov [di+2],dx}


procedure NegSngl( var A : single);
Inline(
  $5F/                   {    pop di}
  $07/                   {    pop es}
  $26/$8A/$45/$03/       {    es: mov al, [di+3]}
  $D0/$E0/               {    shl al,1}
  $F5/                   {    cmc}
  $D0/$D8/               {    rcr al,1}
  $26/$88/$45/$03);      {    es: mov [di+3], al}

procedure NegDbl( var A : double);
Inline(
  $5F/                   {    pop di}
  $07/                   {    pop es}
  $26/$8A/$45/$07/       {    es: mov al, [di+7]}
  $D0/$E0/               {    shl al,1}
  $F5/                   {    cmc}
  $D0/$D8/               {    rcr al,1}
  $26/$88/$45/$07);      {    es: mov [di+7], al}





implementation

function DivUp(What, By : longint) : longint;
var WdB : longint;
    Sign : shortInt;
begin
  If (What=0) or (By=0) then DivUp:=0
  else begin
    WdB:=What div By;
    Sign:=1;
    If WdB < 0 then asm neg[sign] end;
    DivUp:=WdB + Ord( (What mod By) <> 0)*Sign;
  end;
end;

function LCMW(W1,W2 : word) : longint; assembler;
asm
		  mov dx,w2
      mov cx,w1
      cmp cx,dx
      ja  @loop
			xchg cx,dx
      jcxz @cxz
    @loop:
      mov ax,cx
      mov cx,dx
      xor dx,dx
      div cx
      cmp dx,0
      jnz @loop
                    {Now, CX = GCDW(W1,W2)}
      mov ax,w1     {Compute LCMW as  W2*(W1 div GCDW(W1,W2))}
      div cx
      mul w2
      jmp @ex
@cxz:
      xor ax,ax {generate 0}
      cwd
@ex:
end;

function GCDW(W1,W2 : word) : word; assembler;
{Using the Euclid's algorithm}
asm
		  mov dx,w2
      mov cx,w1
      cmp cx,dx
      jb  @loop
			xchg cx,dx     {Put smaller one in CX}
      jcxz @cxz
    @loop:
      mov ax,cx
      mov cx,dx
      xor dx,dx
      div cx
      cmp dx,0
      jnz @loop
@cxz:
      mov ax,cx
end;

function GCDL(L1,L2 : longint) : longint;
{Using the Euclid's algorithm}
var L : longint;
begin
  If L2=0 then begin GCDL:=0; Exit; end;
  If L1 < L2 then begin L:=L1; L1:=L2; L2:=L; end;
  repeat
    L:=L1 mod L2;
    L1:=L2;
    L2:=L;
  until L2=0;
  GCDL:=L1;
end;

function LCML(L1,L2 : longint) : longint;
var L : longint;
begin
  L:=GCDL(L1, L2);
  If L <> 0 then LCML := (L1 div L)*L2
  else LCML:=0;
end;


end.
