
{*    E. Sorokin 1991-1996      *}

unit MemS;
	{-Memory manipulation functions}

{This version is for BP 7 and higher}

{$DEFINE Assume386}
{Defining Assume386 disables processor check in XMove
 producing slightly faster code, but running only with 386+ CPU}

interface

type

  OS =
    record
      O, S : Word;
    end;

  LH =
    record
      L, H : Word;
    end;

procedure FastFillStruct(var Dest; Count : Word; var Filler; FillerSize : Word);
  {-Same as FillStruct of Turbo Power Software, but faster}
Inline(
  $58/                   {      POP     AX  ; AX = FillerSize}
  $5B/                   {      POP     BX}
  $5A/                   {      POP     DX}
  $59/                   {      POP     CX}
  $5F/                   {      POP     DI}
  $07/                   {      POP     ES}
  $E3/$16/               {      JCXZ    @End}
  $FC/                   {      CLD}
  $1E/                   {      PUSH    DS ; Save DS}
  $8E/$DA/               {      MOV     DS,DX}
  $89/$CA/               {@loop:  MOV     DX,CX ; Save loop count}
  $89/$DE/               {      MOV     SI,BX}
  $89/$C1/               {      MOV     CX,AX  ; CX=FillerSize}
  $D1/$E9/               {      shr cx,1            }
  $F2/$A5/               {      REP     MOVSW  ; Go!}
  $73/$01/               {      jnc @Even           }
  $A4/                   {      MovSB   ;Do not forget the odd byte}
                         {@Even:}
  $89/$D1/               {      MOV     CX,DX ; Restore loop count}
  $E2/$EF/               {      LOOP    @loop}
  $1F);                  {      POP     DS ; Restore DS}
                         {@End:    }

procedure FastFillChar(var X; Count : Word; Value : char);
  {-Reimplementation of System.FillChar}
Inline(
  $58/                   {  POP AX; AL=Value}
  $59/                   {  POP CX; CX=Count}
  $5F/                   {  POP DI}
  $07/                   {  POP ES; ES:DI => X}
  $FC/                   {  CLD}
  $88/$C4/               {  MOV AH,AL; Copy AL into AH}
  $D1/$E9/               {  SHR CX,1}
  $F2/$AB/               {  REP StoSW}
  $73/$01/               {  JNC @end}
  $AA);                  {  StoSB}
                         {@end:}

procedure NegStruct( var Struct; Count : word);
Inline(
  $59/                   {    pop cx}
  $5F/                   {    pop di}
  $30/$C0/               {    xor al,al}
  $07/                   {    pop es}
  $D1/$E9/               {    shr cx,1}
  $14/$00/               {    adc al,0; Store Carry in AL}
                         {@lop:}
  $26/$F7/$1D/           {    es: neg word ptr [di]}
  $47/                   {    inc di}
  $47/                   {    inc di}
  $E2/$F9/               {    loop @lop}
  $00/$C1/               {    add cl,al; Get Carry back}
  $E3/$03/               {    jcxz @ex}
  $26/$F6/$1D);          {    es: neg byte ptr [di]; Neg last byte}
                         {@ex:    }


function SegInc : word;
  {-Return $10000 div SelectorInc}
Inline(
  $31/$C0/               {  XOR AX,AX}
  $BA/$01/$00/           {  MOV	DX,1}
  $F7/$36/>SELECTORINC); {  DIV word ptr [>SelectorInc]  }


function Normalized(P : Pointer) : Pointer;
  {-Return P as a normalized pointer}
  {Warning: Normalized pointers may be invalid under DPMI or Windows}
Inline(
  $31/$C0/               { XOR AX,AX}
  $BA/$01/$00/           { MOV	DX,1}
  $F7/$36/>SELECTORINC/  { DIV word ptr [>SelectorInc]  ;AX=SegInc}
  $89/$C1/               { mov cx,ax ;store SegInc into CX}
  $58/                   { pop ax    ;pop offset into AX}
  $31/$D2/               { xor dx,dx ;DX:AX = Longint(Ofs(P))}
  $F7/$F1/               { div cx    ;DX is remainder, AX is quotient}
  $5B/                   { pop bx    ;pop segment into BX}
  $01/$C3/               { add bx,ax ;BX is new segment}
  $89/$D0/               { mov ax,dx ;AX is new offset}
  $89/$DA);              { mov dx,bx }

function AddWordToPtr(P : Pointer; W : Word) : Pointer;
  {-Add a Word to a pointer. No normalization or wrap checking performed}
  inline(
    $5B/                     {pop bx     ;bx = W}
    $58/                     {pop ax     ;ax = Ofs(P^)}
    $5A/                     {pop dx     ;dx = Seg(P^)}
    $01/$D8);                {add ax,bx  ;ax = Ofs(P^)+W}

function PtrToLong(P : Pointer) : LongInt;
  {-Convert pointer to LongInt}
Inline(
  $5B/                   {  POP BX   }
  $59/                   {  POP CX   ;CX is segment}
  $31/$C0/               {  XOR AX,AX}
  $BA/$01/$00/           {  MOV	DX,1}
  $F7/$36/>SELECTORINC/  {  DIV word ptr [>SelectorInc]  }
  $F7/$E1/               {  MUL CX}
  $01/$D8/               {  ADD AX,BX}
  $83/$D2/$00);          {  ADC DX,0 }

function LongToPtr(L : LongInt) : Pointer;
  {-Return LongInt L as a normalized pointer}
  {Warning: Normalized pointers may be invalid under DPMI or Windows}
Inline(
  $31/$C0/               {  XOR AX,AX}
  $BA/$01/$00/           {  MOV	DX,1}
  $F7/$36/>SELECTORINC/  {  DIV word ptr [>SelectorInc] }
  $89/$C3/               {  MOV BX,AX  ;BX = SegInc}
  $58/                   {  POP AX}
  $5A/                   {  POP DX}
  $F7/$F3/               {  DIV BX ;DX is new Offset, AX is new Segment. Exchange them.}
  $92);                  {  XCHG AX,DX }

function PtrDiff(P1, P2 : Pointer) : LongInt;
  {-Return the number of bytes between P1^ and P2^}

function AddLongToPtr(P : Pointer; L : LongInt) : Pointer;
  {-Add a LongInt to a pointer. MSDOS version returns normalized pointer.}

function SPtrDiff( PH,PL : pointer) : longint;
  {-Return signed number of bytes between PH^ ("high") and PL^ ("low")}

procedure IncPtr( var P : pointer; Shift : longint);
  {-Add a signed longint to pointer}
  {Warning: Normalized pointers may be invalid under DPMI or Windows}

procedure DecPtr( var P : pointer; Shift : longint);
  {-Subtract a signed longint from pointer}
  {Warning: Normalized pointers may be invalid under DPMI or Windows}

procedure FastMove( var Source, Dest; Count : word);
  {-Reimplementation of System.Move}

procedure XMove   ( var Source, Dest; Count : word);
  {-FastMove using 386 MOVSD instructions. }

procedure SwapStruct( var X1, X2; Size : word);
  {-Swap two structures of size Size}

procedure CutHeapBlock( P : Pointer; OldSize, NewSize : word);
  {-Given a correct heap block of length Oldsize,
	  cut it to the NewSize length. Under DPMI or Windows,
    the caller must be sure that P^ is within conventional heap.}

{$IFDEF MSDOS}
function ReallocHeapBlock( var P : Pointer; OldSize, NewSize : word) : boolean;
  {-Given a heap block of length OldSize, change its size
    to NewSize. It is attempted to use adjacent free blocks as
    much as possible to prevent unnecessary moving of data.
    P=NIL, OldSize=0 and NewSize=0 are valid inputs.
		If there is no possibility to allocate more memory, no
		actions are taken and False is returned,
    otherwise P is set to the new value.}
{$ENDIF}

function DivUp(What, By : longint) : longint;
	{-Divide and round up}

implementation

function PtrDiff(P1, P2 : Pointer) : LongInt;
  {-Return the number of bytes between P1^ and P2^}
begin
  PtrDiff := Abs( PtrToLong(P1)-PtrToLong(P2));
end;

function AddLongToPtr(P : Pointer; L : LongInt) : Pointer;
  {-Add LongInt to a pointer.}
begin
{$IFDEF MSDOS}
  AddLongToPtr := LongToPtr(L+PtrToLong(P));
{$ELSE}
  Inc(L, OS(P).O);
  AddLongToPtr:=Ptr( OS(P).S + SelectorInc*LH(L).H, LH(L).L);
{$ENDIF}
end;

function SPtrDiff( PH,PL : pointer) : longint;
begin
	SPtrDiff:= PtrToLong( PH) - PtrToLong( PL);
end;

procedure IncPtr( var P : pointer; Shift : longint);
begin
	P:=LongToPtr( PtrToLong( P) + Shift);
end;

procedure DecPtr( var P : pointer; Shift : longint);
begin
	P:=LongToPtr( PtrToLong( P) - Shift);
end;

procedure CutHeapBlock( P : Pointer; OldSize, NewSize : word);
begin
  {NewSize must be a multiple of 8!}
  NewSize:=(NewSize+7) and $fff8; {is the same as 8*divup(NewSize, 8)}
                                  {will fail at NewSize >$fff8, which is illegal anyway}
  If OldSize > NewSize then {Only normalized pointers allowed!}
	  FreeMem(Normalized(AddWordToPtr(P, NewSize)), OldSize-NewSize);
end;


{$IFDEF MSDOS}

type PFreeRec = ^TFreeRec;
     TFreeRec = record
                  Next : PFreeRec;
                  Size : pointer;
                end;

function ReallocHeapBlock( var P : Pointer; OldSize, NewSize : word) : boolean;
var NewP : pointer; FSize, NSize, OSize : word;
    FP : PFreeRec;
Label NewAlloc, Ex;
begin
  {Convert OldSize and NewSize to real values for heap manager}
  NSize:=(longint(NewSize+7)) and $fffffff8; {is the same as 8*divup(NewSize, 8)}
  OSize:=(longint(OldSize+7)) and $fffffff8;
  If OSize=NSize then goto Ex;

  If OSize > NSize then begin {Only normalized pointers allowed!}
    FreeMem(Normalized(AddWordToPtr(P, NSize)), OldSize-NSize);
    If NSize=0 then P:=NIL;
  end else begin
{$IFDEF VER70} {Sorry, it is not possible to check VER60 simultaneously}
    ReallocHeapBlock:=False;
    If (P <> NIL) and (OldSize > 0) then begin
      {Only works with TP6 and TP/BP7 heap managers!}
      {Check if it is possible to increase bloc 'in situ'}
      {Scan the FreeList to see if the block adjacent to P^ is free.
       FreeList pointers are assumed to be always normalized by the heap manager}
      FP:=FreeList;
      If FP <> HeapPtr then
        While OS(FP^.Next).S <= OS(P).S do  FP:=FP^.Next;
      NewP:=Normalized(AddWordToPtr(P,OSize));
      If NewP <> HeapPtr then begin
        If NewP <> FP^.Next then goto NewAlloc {Adjacent block is in use}
        else
          FSize:=PtrToLong(FP^.Size);
          If FSize < NSize-OSize {Free block too small}
          then goto NewAlloc;
          If FSize > NSize-OSize then begin {OK, mimick heap manager}
            IncPtr(Pointer(FP^.Next), NSize-OSize);
            FP:=FP^.Next;
            FP^.Size:=AddLongToPtr(PFreeRec(NewP)^.Size, Longint(OSize)-NSize);
            FP^.Next:=PFreeRec(NewP)^.Next;
          end else begin {The block fits exactly, just forget next free block}
            FP^.Next:=Fp^.Next^.Next;
          end;
      end else {Reached HeapPtr: just enlarge block into the empty heap}
        If MaxAvail >= NewSize-OSize then GetMem(NewP, NewSize-OSize)
        else Exit;
      end
    else
{$ENDIF}
    begin
NewAlloc:    {Must allocate new block}
      If MaxAvail < NewSize then Exit;
      GetMem(NewP, NewSize);
      If (P <> NIL) then begin {Move data}
        XMove(P^,NewP^,OSize);
        FreeMem(P, OldSize);
      end;
      P:=NewP;
    end;
  end;
Ex:
  ReallocHeapBlock:=True;
end;

{$ENDIF}

function DivUp(What, By : longint) : longint;
begin
  DivUp:=(What div By) + Ord( What mod By <> 0);
end;

procedure FastMove( var Source, Dest; Count : word);
assembler;
asm
        PUSH    DS
        MOV     CX, Count
        LDS     SI, source
        CLD
        LES     DI, Dest
        CMP     SI, DI
        JAE     @Forw

        ADD     SI, CX
        ADD     DI, CX
        DEC     SI
        DEC     DI
        STD
        SHR     CX, 1
        JAE     @Even
        MOVSB
@Even:
        DEC     SI;  DEC     DI
        JMP     @Go
@Forw:
        SHR     CX, 1
        JNC     @Go
        MOVSB
@Go:
        REP     MOVSW
        POP     DS
end;

procedure XMove( var Source, Dest; Count : word);
assembler;
asm
      MOV     DX,DS
{$IFNDEF ASSUME386}      MOV     AL,Test8086  {$ENDIF}
      LES     DI,DEST
      CLD
      LDS     SI,SOURCE
      MOV     CX,Count
      XOR     BL,BL
      CMP     SI,DI  {This check assumes no normalization of pointers!}
      JAE     @@Forward
      STD
      ADD SI,CX; ADD DI,CX
      DEC SI;    DEC DI
      SHR     CX,1
      JNC     @@Even
      MOVSB         {Move odd byte, if needed}
@@Even:
      DEC SI; DEC DI; {Update SI,DI and reset Carry}
{$IFNDEF ASSUME386}      CMP  AL,2
                         JC   @@Go2
{$ENDIF}
      SHR  CX,1
      JNC  @@Go4
      MOVSW
@@Go4:
      SUB SI,2; SUB DI,2
      db      0f3h, 066h, 0a5h  { REP MOVSD  with 386}
      JMP  @@End
@@Forward:
      SHR  CX,1
      ADC  BL,0 {Save last bit of CX in BL}
{$IFNDEF ASSUME386}      CMP  AL,2
                         JC   @@Go2
{$ENDIF}
      SHR  CX,1
      db      0f3h, 066h, 0a5h  { REP MOVSD  with 386}
      ADC  CL,0  {restore Carry into CX}
@@Go2:
      REP     MOVSW
      SUB     BL,1
      JC     @@End
      MOVSB          {Move odd byte, if needed}
@@End:
      MOV     DS,DX
end;


procedure SwapStruct( var X1, X2; Size : word);
assembler;
asm
      mov cx,Size
      jcxz @@End
      push ds
      les di, X1
      lds si, X2
      cld             {go forward}
      shr cx,1        {move by words}
      jcxz  @1byte
      pushf

@Go:
    mov bx,si
    mov ax,es:[di]  {exchange words}
    movsw
    mov [bx],ax
    loop @Go        {repeat CX times}

      popf
      jnc @@Stop
@1Byte:
      mov al,[si]     {exchange the last byte}
      xchg al,es:[di]
      mov [si],al

@@Stop:
      pop ds
@@End:
end;

end.
