{ *** E. V. Sorokin, Version 1.0  of 8.96   *** }

{$D+,L+,Y+} {Include full debug info, does not change EXE-size}
{$X+} {Necessary}
{$I-}

{Warning: Option $R- also disables all of the TAbstArray range checks.}
{$R+}

Unit LArrayS;
{

 Target:
 Windows, Real, Protected.

 Unit for handling of large arrays of equal fixed-size elements.
 Array elements have subscript of type Longint and Array size is limited
 only by the memory available.

 Array is stored 0-based (i.e. first element has the number 0).

}

interface

uses objects
{$IFNDEF MSDOS}, WinApi {$ENDIF}
;

const MaxBlock = $fff8;

type  PPage = Pointer;
      TContents = array [0..(MaxBlock div SizeOf(PPage))] of PPage;
      PContents = ^TContents;

type
    PAbstArray = ^TAbstArray;
    TAbstArray =  object(TObject) {Putting VMT table at the ultimate top. Important!}
                 {Constructors/destructors}
                    constructor Alloc(Pts : longint; Esize : word); {Version 0.9 compatibility}
                    constructor Init(Pts : longint; Esize : word; MinBlk : word);
                    constructor SubArray( From : PAbstArray; Index, Count : longint);
                    constructor Copy( From : PAbstArray);
                    procedure InitTo(var Value);
                    destructor  Done; virtual;
                    procedure CopyOther( From : PAbstArray); virtual;
                    procedure CopyFields( From : PAbstArray);
                    procedure SetOther( Value : byte); virtual;
                    function  Read(var F : file) : longint; virtual;
                    function  Write(var F : file) : longint; virtual;
                 {Interface to array elements}
                    function Get(Num : Longint; var Value) : boolean; virtual;
                    function Put(Num : Longint; var Value) : boolean; virtual;
                    function Nth(N : longint) : pointer; virtual;
                    function Swap(N1, N2 : longint) : boolean; virtual;
                    function PageOf(N : longint) : pointer; virtual;
                    function Page(N : word) : pointer; virtual;
                 {Interface to private fields}
                    function Size : longint; virtual; {Number of elements allocated}
                    function ElemSize : word; virtual; {Size of one element in bytes}
                    function SetElemSize(Bytes : word) : word; {Returns new size, which MUST be checked!}
                    function PageSize : word; virtual; {Number of elements in page}
                    function Pages : word; {How many pages used}
                    function PageSizeOf( N : longint) : word; virtual; {Page size of N-th element}
                    function LastPageSize : word; virtual;
                 {Allocation/deallocation}
                    function  Increase( By : longint) : boolean; virtual;
                    function  Insert(From : PAbstArray; Index, Count : longint) : boolean; virtual;
                       {From=NIL is valid for inserting empty space}
                    procedure Delete( Index, Count : longint); virtual;
                 {Block operations}
                    procedure Fill(var Value; Index, Count : longint); virtual;
                    function CopyData( Start : longint; From : PAbstArray; Index, Count : longint) : longint; virtual;
                       {ElementSize's must be equal. Start in "Self"; Index and Count in "From"}
                    function FLoad(var F : file; Index, Count : longint) : longint; virtual;
                    function FDump(var F : File; Index, Count : longint) : longint; virtual;
                    function Dump( var Dest; Index : longint; Count : word) : boolean; virtual;
                    function Load( var Srce; Index : longint; Count : word) : boolean; virtual;
                private 
                {Internal data fields and most dangerous functions are hidden}
                    Points : longint;
                    Book : PContents;
                    ElementSize : word; {In principle, 0 is allowed}
                    PageLength : word; {Number of elements per page}
                public  
                    MinBlock : word;
                private 
                     {Warning: no input validity checks performed here}
                    procedure BlockFill( var Block; Index, Count : longint);
                    procedure BlockMove( var Block; Index : longint; Count : word; Input : boolean);
                    function  MakeSpace( Index, Count : longint) : boolean;
                    procedure RemoveSpace( Index, Count : longint);
                  end;

const  OffsetPoints       = SizeOf(TObject);
       OffsetBook         = OffsetPoints  + SizeOf(longint);
       OffsetElementSize  = OffsetBook    + SizeOf(PContents);
       OffsetPageLength   = OffsetElementSize + SizeOf(Word);


function NthOf(var Arr : TAbstArray; N : longint) : pointer;
Inline(
  $58/                   {      pop ax}
  $5A/                   {      pop dx}
  $5F/                   {      pop di}
  $07/                   {      pop es}
                         {$IFOPT R+}
  $83/$FA/$00/           {      cmp dx,0 	;If N < 0 }
  $7C/$0E/               {      jl  Nil}
  $26/$3B/$55/<2+OFFSETPOINTS/ {      es: cmp dx,<2+OffsetPoints [di]; Check high word}
  $7F/$08/               {      jg  Nil}
  $7C/$0D/               {      jl  OK}
  $26/$3B/$45/<OFFSETPOINTS/ {      es: cmp ax,<OffsetPoints [di]; Check low word}
  $72/$07/               {      jb  OK}
                         {Nil:}
  $31/$C0/               {      xor ax,ax;   Generate NIL }
  $31/$D2/               {      xor dx,dx}
  $E9/$20/$00/           {      jmp End}
                         {OK:}
                         {$ENDIF}
  $26/$8B/$4D/<OFFSETELEMENTSIZE/ {      es: mov cx,<OffsetElementSize[di];     cx=ElementSize}
  $E3/$11/               {      jcxz CXZ}
  $26/$8B/$5D/<OFFSETPAGELENGTH/ {      es: mov bx,<OffsetPageLength[di];     bx=PageLength}
  $F7/$F3/               {      div bx}
  $26/$C4/$7D/<OFFSETBOOK/ {      es: les di,<OffsetBook[di];         es:[di] = Book}
  $92/                   {      xchg ax,dx}
  $D1/$E2/               {      shl dx,1}
  $D1/$E2/               {      shl dx,1;        dx=Page*4}
  $01/$D7/               {      add di,dx;       es:di => Book^[Page]}
                         {CXZ:}
  $F7/$E1/               {      mul cx;           ax = N*ElementSize}
  $26/$C4/$3D/           {      es: les di,[di];  es:[di] = Book^[Page]}
  $01/$F8/               {      add ax,di}
  $8C/$C2);              {      mov dx,es;       dx:ax = Addwordtoptr(Book^[page], N*ElementSize)}
                         {End:}


const MaxFraction : word = 2; {For fragmented heap; may be adjusted anytime}
{$IFNDEF MSDOS}
const gFlag : word = 0;
{$ENDIF}


implementation

uses
{$IFNDEF WINDOWS}
     Memory,   {MemAlloc}
     Dos,      {type FileRec}
{$ELSE}
     OMemory,   {MemAlloc}
     WinDos,    {type TFileRec}
{$ENDIF}
     MemS,      {AddWordToPtr, XMove, FastFillChar, CutHeapBlock, etc.}
     MinMaxS;   {Min/max, DivUp and LCMW}

{$IFDEF WINDOWS}
type FileRec = TFileRec;
{$ENDIF}


(* TAbstArray *)

constructor TAbstArray.Init;
begin
{$IFOPT R+}  If (pts < 0) or (esize < 0) then Fail; {$ENDIF}
  inherited Init;
	ElementSize:=ESize;
  MinBlock:=MinBlk;
  if not MakeSpace(0,Pts) then begin ElementSize:=0; Fail; end;
end;

constructor TAbstArray.Alloc(Pts : longint; Esize : word);
begin
{$IFOPT R+}  If (pts < 0) or (esize < 0) then Fail; {$ENDIF}
  inherited Init;
	ElementSize:=ESize;
  MinBlock:=1;
  if not MakeSpace(0,Pts) then begin ElementSize:=0; Fail; end;
end;

destructor TAbstArray.Done;
begin
  RemoveSpace(0, Points);
end;

procedure TAbstArray.CopyOther;
begin
  XMove(  AddWordToPtr(From, SizeOf(TAbstArray))^,
          AddWordToPtr(@Self, SizeOf(TAbstArray))^,
  	      SizeOf(Self) - SizeOf(TAbstArray));
end;

procedure TAbstArray.CopyFields;
begin
  XMove(  AddWordToPtr(From, SizeOf(TObject))^,
          AddWordToPtr(@Self, SizeOf(TObject))^,
  	      SizeOf(TAbstArray) - SizeOf(TObject));
end;

procedure TAbstArray.SetOther;
begin
  FastFillChar( AddWordToPtr(@Self, SizeOf(TAbstArray))^,
	              SizeOf(Self) - SizeOf(TAbstArray),
                Chr(Value));
end;

constructor TAbstArray.SubArray;
begin
{$IFOPT R+}  If (Index < 0) or (Count < 0) then Fail;
  Count:=MaxLong(minlong(From^.points-Index, Count),0);
{$ENDIF}
  inherited Init;
	ElementSize:=From^.ElementSize;
  if not Increase(Count) then begin ElementSize:=0; Fail; end;
  CopyData(0, From, Index, Count);
  CopyOther( From);
end;

constructor TAbstArray.Copy;
begin
  inherited Init;
	ElementSize:=From^.ElementSize;
  MinBlock:=From^.MinBlock;
  if not Increase(From^.Points) then begin ElementSize:=0; Fail; end;
  CopyData(0, From,  0, Points);
  CopyOther( From);
end;

procedure TAbstArray.InitTo;
begin
  If @Value <> NIL then Fill( Value, 0, Size);
end;

function TAbstArray.Read;
begin
  Read:=FLoad(F, 0, Size);
end;

function TAbstArray.Write;
begin
  Write:=FDump(F, 0, Size);
end;

function TAbstArray.Size;
assembler;
asm
  les di,Self
  mov ax,es:[di+offset TAbstArray.Points] {Low word}
  mov dx,es:[di+2+offset TAbstArray.Points] {High word}
end;

function TAbstArray.ElemSize;
assembler;
asm
  les di,Self
  mov ax,es:[di+offset TAbstArray.ElementSize]
end;

function TAbstArray.SetElemSize;
var FullBytes : longint;
begin
  FullBytes:=Points*ElementSize;
  If ((FullBytes mod Bytes)=0) and (((PageLength * ElementSize) mod Bytes)=0)
  then begin
    Points:=FullBytes div Bytes;
    PageLength:=(PageLength * ElemSize) div Bytes;
    ElementSize:=Bytes;
  end;
  SetElemSize:=ElementSize;
end;

function TAbstArray.PageSize;
assembler;
asm
  les di,Self
  mov ax,es:[di+offset TAbstArray.PageLength]
end;

function TAbstArray.Pages;
begin
  If PageLength > 0 then Pages:=DivUp(Points, PageLength)
  else Pages:=0;
end;

function TAbstArray.LastPageSize;
(* Prototype:
begin
  If Points <> PageLength then
    LastPageSize:=Points mod PageLength
  else
    LastPageSize:=PageLength
end; *)
assembler;
    asm
      les di, Self
      mov bx,es:[di+offset TAbstArray.PageLength]
      mov dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      mov ax,es:[di+offset TAbstArray.Points]
      cmp dx,0
      jne @@Div
      cmp ax,bx
      je  @@End
@@Div:
      div bx
      mov ax,dx
@@End:
end;

function TAbstArray.PageSizeOf;
(* Prototype:
begin
  {$IFOPT R+}
	  If (N < 0) or (N => Points) then begin PageSizeOf:=0; Exit; end;
	{$ENDIF}
  If  (Points - N) <= LastPageSize then PageSizeOf:=LastPageSize
  else PageSizeOf=PageLength;
end; *)
assembler;
    asm
      mov dx, word ptr [N]+2
      mov ax, word ptr N
      les di, Self
      mov cx,es:[di+2+offset TAbstArray.Points] {Check high word}
      mov bx,es:[di+offset TAbstArray.Points]
{$IFOPT R+}
      cmp dx,0   {If N < 0 }
      jl  @@Nil
      cmp dx,cx {Check high word}
      jg  @@Nil
      jl  @@OK
      cmp ax,bx {Check low word}
      jb @@OK
@@Nil:
      xor ax,ax  {Generate 0 }
      jmp @@End
@@OK:
{$ENDIF}
      sub cx,dx
      sbb bx,ax                                {cx:bx = Points - N}
      mov si,es:[DI].TAbstArray.PageLength     {si=PageLength}
      cmp cx,0
      jne @@PL
      div si                                   {dx=LastPageSize}
      cmp dx,bx
      jb  @@PL
      mov si,dx
@@PL:
      mov ax,si
@@End:
end;

procedure TAbstArray.Delete;
begin
{$IFOPT R+}
  If (Points*ElementSize = 0) or (Index >= Points) or (Index < 0) then Exit;
{$ENDIF}
  Count:=minlong(Points-Index, Count);
  If Count > 0 then RemoveSpace( Index, Count);
end;

function TAbstArray.Insert;
begin
  Insert:=False;
{$IFOPT R+}
  If ElementSize <> From^.ElementSize then Exit;
  If (Points*ElementSize = 0) or (Index >= Points) or (Index < 0) then
	begin Insert:=True; Exit; end;
{$ENDIF}
  If MakeSpace(Index, Count) then begin
    Insert:=True;
    If From <> NIL then CopyData(Index, From, 0, Count);
  end;
end;

procedure TAbstArray.Fill;
begin
{$IFOPT R+}
  If (Points*ElementSize = 0) or (Index >= Points) or (Index < 0) then Exit;
{$ENDIF}
  Count:=MinLong(Count, Points-Index); {Allow Count=MaxLongint}
  BlockFill(Value, Index, Count);
end;

function TAbstArray.Increase;
begin
  Increase:=MakeSpace(Points, By );
end;

function TAbstArray.FLoad;
var Res : longint; aPage, BlockSize, RSize, W : word;
begin
  FLoad:=0;
  If
{$IFOPT R+}
    (Index >= Points) or (Index < 0) or (Count < 0) or
{$ENDIF}
	  (ElementSize*Count = 0)
	then Exit;
  RSize:=FileRec(F).RecSize;
  FileRec(F).RecSize:=1;
  Res:=0;
{$IFOPT R+}  Count:=minlong(count, Points-Index); {$ENDIF}
  aPage:=Index div PageLength;
  Index:=Index mod PageLength;
  BlockSize:=minlong(Count, PageLength-Index);
  BlockRead( F, AddWordToPtr( Book^[aPage], ElementSize*Index)^, BlockSize*ElementSize, W);
  Inc(aPage);  Dec(Count, BlockSize); Inc(Res,W);
  while Count > 0 do begin
    BlockSize:=minlong(Count, PageLength);
    BlockRead( F, Book^[aPage]^, BlockSize*ElementSize, W);
    Inc(aPage);
    Dec(Count, BlockSize);
    Inc(Res,W);
  end;
  FileRec(F).RecSize:=RSize;
  FLoad:= Res div ElementSize;
end;

function TAbstArray.FDump;
var Res : longint; aPage, BlockSize, RSize, W : word;
begin
  FDump:=0;
  If
{$IFOPT R+}
    (Index >= Points) or (Index < 0) or (Count < 0) or
{$ENDIF}
	  (ElementSize*Count = 0)
	then Exit;
  RSize:=FileRec(F).RecSize;
  FileRec(F).RecSize:=1;
  Res:=0;
  Count:=minlong(count, Points-Index);
  aPage:=Index div PageLength;
  Index:=Index mod PageLength;
  BlockSize:=minlong(Count, PageLength-Index);
  BlockWrite( F, AddWordToPtr( Book^[aPage], ElementSize*Index)^, BlockSize*ElementSize, W);
  Inc(aPage);  Dec(Count, BlockSize); Inc(Res,W);
  while Count > 0 do begin
    BlockSize:=minlong(Count, PageLength);
    BlockWrite( F, Book^[aPage]^, BlockSize*ElementSize, W);
    Inc(aPage);
    Dec(Count, BlockSize);
    Inc(Res,W);
  end;
  FileRec(F).RecSize:=RSize;
  FDump:= Res div ElementSize;
end;

function TAbstArray.Dump;
begin
{$IFOPT R+}
  If (Index >= Points) or (Index < 0) or (Count < 0) then begin
    Dump:=False; Exit;
  end;
  Count:=minlong(count, Points-Index);
{$ENDIF}
  BlockMove( Dest, Index, Count, False);
  Dump:=True;
end;

function TAbstArray.Load;
begin
{$IFOPT R+}
  If (Index >= Points) or (Index < 0) or (Count < 0) then begin
    Load:=False; Exit;
  end;
  Count:=minlong(count, Points-Index);
{$ENDIF}
  BlockMove( Srce, Index, Count, True);
  Load:=True;
end;

{Since ElementSize is assumed to be relatively small,
 no 386 commands are used in Put and Get}

function TAbstArray.Put;
(* {Slow prototype}
 var Page : word; N : word absolute Num;
 begin
{$IFOPT R+}
  If (Num >= Points) or (Num < 0) then begin Put:=false; Exit; end;
{$ENDIF}
    Put:=True;
    Page:=Num div PageLength;
    N:=Num mod PageLength;
    Move( Value, AddWordToPtr(Book^[page], ElementSize*N)^, ElementSize);
end;	*)
assembler;
    asm
      push ds
      mov dx, word ptr [Num]+2
      les di, Self
      mov ax, word ptr Num
{$IFOPT R+}
      cmp dx,0   {If Num < 0 }
      jl  @@False
      cmp dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      jg  @@False
      jl  @@OK
      cmp ax,es:[di + offset TAbstArray.Points] {Check low word}
      jb @@OK
@@False:
      xor ax,ax  {Generate "False" result}
      jmp @@End
@@OK:
{$ENDIF}
      mov cx,es:[di].TAbstArray.ElementSize {cx=ElementSize}
      jcxz @@Ex   {ElementSize=0, do nothing}
      mov bx,es:[DI].TAbstArray.PageLength
      div bx
      xchg ax,dx
      les di,es:[di].TAbstArray.Book         {es:[di] = Book}
      shl dx,1
      shl dx,1        {dx=Page*4}
      add di,dx
      lds si,Value
      mul cx          {ax = ax*cx = N*ElementSize}
      les di,es:[di]  {es:[di] = Book^[Page]}
      cld             {No check against overlapping!}
      add di,ax       {es:[di] = Addwordtoptr(Book^[page], N*ElementSize}
      shr cx,1        {And set Carry Flag!}
      rep movsw
      jnc @@Ex
      movsb           {The last odd byte}
@@Ex: {Generate "True"}
      mov ax,1
      or ax,ax
@@End:
      pop ds
end;

function TAbstArray.Get;
(* {Slow prototype}
var Page : word; N : word absolute Num;
begin
{$IFOPT R+}
  If (Num >= Points) or (Num < 0) then begin Get:=false; Exit; end;
{$ENDIF}
    Get:=True;
    Page:=Num div PageLength;
    N:=Num mod PageLength;
    Move( AddWordtoPtr(Book^[page], ElementSize*N)^, Value, ElementSize);
    end;
end; *)
assembler;
    asm
      push ds
      mov dx, word ptr [Num]+2
      les di,Self
      mov ax, word ptr Num
{$IFOPT R+}
      cmp dx,0   {If Num < 0 }
      jl  @@False
      cmp dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      jg  @@False
      jl  @@OK
      cmp ax,es:[di + offset TAbstArray.Points] {Check low word}
      jb @@OK
@@False:
      xor ax,ax  {Generate "False" result}
      jmp @@End
@@OK:
{$ENDIF}
      mov cx,es:[di].TAbstArray.ElementSize {cx=ElementSize}
      jcxz @@Ex   {ElementSize=0, do nothing}
      mov bx,es:[DI].TAbstArray.PageLength
      div bx
{$IFOPT A+}      mov bx,cx {$ENDIF}
      xchg ax,dx
      les di,es:[di].TAbstArray.Book         {es:[di] = Book}
      shl dx,1
      shl dx,1        {dx=Page*4}
      add di,dx
      lds si,es:[di]  {es:[di] = Book^[Page]}
      mul cx          {ax = ax*cx = N*ElementSize}
      les di,dword ptr Value
      cld             {No checks against overlapping!}
      add si,ax       {ds:[si] = Addwordtoptr(Book^[page], N*ESize}
      shr cx,1        {And set Carry Flag!}
      rep movsw
      jnc @@Ex
      movsb           {Odd byte, if needed}
@@Ex: {Generate "True"}
      mov ax,1
      or ax,ax
@@End:
      pop ds
end;

function TAbstArray.Nth;
(*  {Slow prototype}
 var Page : word;
 begin
{$IFOPT R+}
  If (N >= Points) or (N < 0) then begin Nth:=Nil; Exit; end;
{$ENDIF}
    Nth:=AddWordToPtr(Book^[N div PageLength], ElementSize*(N mod PageLength));
end;	*)
assembler;
    asm
      mov dx, word ptr [N]+2
      mov ax, word ptr N
      les di, Self
{$IFOPT R+}
      cmp dx,0   {If N < 0 }
      jl  @@Nil
      cmp dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      jg  @@Nil
      jl  @@OK
      cmp ax,es:[di + offset TAbstArray.Points] {Check low word}
      jb @@OK
@@Nil:
      xor ax,ax  {Generate NIL }
      xor dx,dx
      jmp @@End
@@OK:
{$ENDIF}
      mov cx,es:[di].TAbstArray.ElementSize     {cx=ElementSize}
      jcxz @@CXZ
      mov bx,es:[DI].TAbstArray.PageLength     {bx=PageLength}
      div bx
      les di,es:[di].TAbstArray.Book         {es:[di] = Book}
      xchg ax,dx
      shl dx,1
      shl dx,1        {dx=Page*4}
      add di,dx       {es:di => Book^[Page]}
@@CXZ:
      mul cx          {ax = N*ElementSize}
      les di,es:[di]  {es:[di] = Book^[Page]}
      add ax,di
      mov dx,es       {dx:ax = Addwordtoptr(Book^[page], N*ElementSize}
@@End:
end;

function TAbstArray.Swap;
assembler;
    asm
      push ds
      les di, Self
      mov dx, word ptr [N1]+2
      mov ax, word ptr N1
{$IFOPT R+}
      xor cx,cx  {Generate False}
      cmp dx,0   {N2 < 0 ?}
      jl  @@End
      cmp dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      jg  @@End
      jl  @@OK1
      cmp ax,es:[di + offset TAbstArray.Points] {Check low word}
      jae @@End
@@OK1:
      mov dx, word ptr [N2]+2
      mov ax, word ptr N2
      cmp dx,0   {N2 < 0 ?}
      jl  @@End
      cmp dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      jg  @@End
      jl  @@OK2
      cmp ax,es:[di + offset TAbstArray.Points] {Check low word}
      jae @@End
@@OK2:
      mov dx, word ptr [N1]+2
      mov ax, word ptr N1
{$ENDIF}

      mov cx,es:[di].TAbstArray.ElementSize     {cx=ElementSize}
      jcxz @@End     {No problem, just nothing to do}
      mov bx, es:[DI].TAbstArray.PageLength     {bx=PageLength}
      div bx
      les di,es:[di].TAbstArray.Book         {es:di => Book}
      push es
      mov si, di
      pop ds                                 {ds:si => Book}

      xchg ax,dx
      shl dx,1
      shl dx,1        {dx=Page*4}
      add di,dx       {es:di => Book^[Page1]}
      mul cx          {ax = N1*ElementSize}
      les di,es:[di]  {es:[di] = Book^[Page1]}
      add di,ax       {es:di = Nth(N1) }

      mov dx, word ptr [N2]+2
      mov ax, word ptr N2
      div bx
      xchg ax,dx
      shl dx,1
      shl dx,1        {dx=Page*4}
      add si,dx       {ds:si => Book^[Page2]}
      mul cx          {ax = N2*ElementSize}
      lds si,ds:[si]  {ds:[si] = Book^[Page2]}
      add si,ax       {ds:si = Nth(N2) }

{Now CX=ElementSize; ES:DI => Nth(N1); DS:SI => Nth(N2) }

    cld             {go forward}
    xor dl,dl
    shr cx,1        {move by words}
    jcxz  @1byte
    adc dl,0        {Store Carry in DL}

@Go:
    mov bx,si
    mov ax,es:[di]  {exchange words}
    movsw           {ds:si --> es:di}
    mov ds:[bx],ax
    loop @Go        {repeat CX times}

    sub dl,1
    jc @@True
@1Byte:
    mov al,[si]     {exchange the last byte}
    xchg al,es:[di]
    mov [si],al
@@True:
    mov cx,1        {Generate True}
@@End:
    mov ax,cx       {Make boolean result}
    cmp ax,0
    pop ds
end;

function TAbstArray.PageOf;
(* Prototype:
begin
  {$IFOPT R+}
	  If (N < 0) or (N => Points) then begin PageOf:=NIL; Exit; end;
	{$ENDIF}
  PageOf:=Book^[N div PageLength];
end; *)
assembler;
    asm
      mov dx, word ptr [N]+2
      mov ax, word ptr N
      les di, Self
{$IFOPT R+}
      cmp dx,0   {If N < 0 }
      jl  @@Nil
      cmp dx,es:[di+2+offset TAbstArray.Points] {Check high word}
      jg  @@Nil
      jl  @@OK
      cmp ax,es:[di + offset TAbstArray.Points] {Check low word}
      jb @@OK
@@Nil:
      xor ax,ax  {Generate NIL }
      xor dx,dx
      jmp @@End
@@OK:
{$ENDIF}
      mov bx,es:[DI].TAbstArray.PageLength     {bx=PageLength}
      div bx
      shl ax,1
      shl ax,1        {ax=Page*4}
      mov dx,es:[di+2+Offset TAbstArray.Book]
      add ax,es:[di+Offset TAbstArray.Book]    {dx:ax => Book^[Page]}
@@End:
end;

function TAbstArray.Page;
begin
  {$IFOPT R+}
  If N > DivUp(Points, PageSize) then Page:=NIL
  else
  {$ENDIF}
  Page:=Book^[N];
end;

function TAbstArray.CopyData( Start : longint; From : PAbstArray; Index, Count : longint) : longint;
var I : longint; PCount, MoveSize : word;
begin
  {$IFOPT R+}
  CopyData:=0;
  If (Index > From^.Points) or (Start > Points)
	   or (Start < 0) or (Index < 0) or (Count < 0) or (ElementSize=0)
		 or (ElementSize <> From^.ElementSize) then Exit;
  Count:=minlong(Count, Points - Start);
  {$ENDIF}
  PCount:=Start div PageLength; I:=0;
  MoveSize:=minlong(PageLength - (Start mod PageLength), Count); {First copy small chunk}
  From^.Dump( Nth(Start)^, Index, MoveSize);
  Inc(I, MoveSize);
  While I < Count do begin
    Inc(PCount); {Next page}
    MoveSize:=minlong(PageLength, From^.Points - I - Index);
    if MoveSize=0 then Break;
    From^.Dump( Book^[PCount]^, I+Index, MoveSize);
    Inc(I, MoveSize);
  end;
  CopyData:=I;
end;


{Private methods of TAbstArray}

procedure TAbstArray.BlockMove(var Block; Index : longint; Count : word; Input : boolean);
var aPage, ESize, MoveSize : word; BP : Pointer;
begin
  ESize:=ElementSize;
  If ESize*Count = 0 then Exit;
  aPage:=Index div PageLength;
  MoveSize:=minword( Count, PageLength-(Index mod PageLength) );
  If Input then XMove( Block, AddWordToPtr(Book^[aPage],(Index mod PageLength)*ElementSize)^, MoveSize*ESize)
	else  XMove( AddWordToPtr(Book^[aPage],(Index mod PageLength)*ElementSize)^, Block, MoveSize*ESize);
  Inc(aPage);  Dec(Count, MoveSize);
  BP:=AddWordToPtr( @Block, MoveSize*ESize);
  while Count > 0 do begin
    MoveSize:=minWord(Count, PageLength);
    If Input then XMove( BP^, Book^[aPage]^, MoveSize*ESize)
    else XMove( Book^[aPage]^, BP^, MoveSize*ESize);
    Inc(aPage);
    BP:=AddWordToPtr( BP, MoveSize*ESize);
    Dec(Count, MoveSize);
  end;
end;

procedure TAbstArray.BlockFill(var Block; Index, Count : longint);
var aPage, ESize, BlockSize : word;
begin
  ESize:=ElemSize;
  If ESize*Count = 0 then Exit;
  aPage:=Index div PageLength;
  BlockSize:=minlong( Count, PageLength-(Index mod PageLength) );
  FastFillStruct( AddWordToPtr(Book^[aPage], (Index mod PageLength)*ESize)^, BlockSize, Block, ESize);
  Inc(aPage);  Dec(Count, BlockSize);
  while Count > 0 do begin
    BlockSize:=minlong(Count, PageLength);
    FastFillStruct( Book^[aPage]^, BlockSize, Block, ESize);
    Inc(aPage);
    Dec(Count, BlockSize);
  end;
end;


function HeapAlert (Size: Word): Integer; far;
begin
  HeapAlert:=1;
end;

function TAbstArray.MakeSpace( Index, Count : longint) : boolean;
var I, NumPages, NewPages, BlockSize, NewPageSize, ESize : word;
    Pts, NewPts : longint;
    LastPage : PPage; NewBook : PContents;
    HAlert : pointer;
Label Ex;
begin {All Pages of equal size, except probably last}
  If (ElementSize*Count=0) then begin MakeSpace:=true; exit; end;
  MakeSpace:=False;
  HAlert:=HeapError;
  HeapError:=@HeapAlert;
  If Points > 0 then begin
	  NumPages:=Pages; {Already allocated pages}
    If (Points <> PageLength) and ((Points mod PageLength)=0) then LastPage:=NIL
	  else LastPage:=Book^[NumPages-1]; {Last Page deserves special treatment}
  end else begin NumPages:=0; LastPage:=NIL; end;
  NewPts:=Count+Points;
  ESize:=ElementSize;
  If NumPages <= 1 then begin {Define block sizes if there is no or single page}
    If MinBlock=0 then MinBlock:=1;
	  BlockSize:=minlong( MaxAvail div MaxFraction, MaxBlock); {For fragmented heap}
      {Align at block borders to save space}
{$IFDEF MSDOS}
    Pts:=LCML(ESize*MinBlock,8); {Least common multiple of 8 and ElementSize}
{$ELSE}
    Pts:=LCML(ESize*MinBlock,HeapBlock); {Least common multiple of HeapBlock and ElementSize}
{$ENDIF}
    if BlockSize > Pts then BlockSize:=(BlockSize div Word(Pts))*Word(Pts);
		BlockSize:=BlockSize div ESize;
    NewPageSize:=minlong(BlockSize, NewPts);
  end else NewPageSize:= PageLength;

  NewPages := DivUp(NewPts, NewPageSize); {New number of pages}
{$IFNDEF MSDOS}
  I:=HeapLimit;
  HeapLimit:=$ffff; {Guarantee that Book is within conventional heap}
{$ENDIF}
  NewBook:=MemAlloc(NewPages*SizeOf(PPage)); {Allocate new book}
{$IFNDEF MSDOS}  HeapLimit:=I; {Restore HeapLimit} {$ENDIF}
  If NewBook = NIL then goto Ex; {Could not allocate new Book}
  I:=0; Pts:=NewPts;
  while I < NumPages - Ord(LastPage <> NIL) do begin {First copy full page pointers}
	  NewBook^[I]:=Book^[I];
    Inc(I);
    Dec(Pts, NewPageSize);
  end; {If LastPage was NIL then we copied all old page pointers}
  {Now make space for new points, including last short page}
  while Pts > 0 do begin
    BlockSize:=minlong(NewPageSize, Pts);
{$IFDEF MSDOS}   NewBook^[I]:=MemAlloc(BlockSize*ESize);
{$ELSE}          NewBook^[I]:=GlobalAllocPtr(gFlag, BlockSize*ESize);
{$ENDIF}
    If NewBook^[I]=NIL then Break;
    Dec(Pts, BlockSize);
    Inc(I);
  end;
  If Pts > 0 then begin {Failed to allocate, forget everything}
    BlockSize:=NewPageSize*ESize;
    for I:=I-1 downto NumPages - Ord(LastPage <> NIL) do
{$IFDEF MSDOS}			FreeMem(NewBook^[I], BlockSize);
{$ELSE}             GlobalFreePtr( NewBook^[I]);
{$ENDIF}
    FreeMem(NewBook, NewPages*SizeOf(PPage));
    Exit;
  end; {So far not a single bit in Self has been changed!}
   {Success, relocate previous last page and update Self}
  FreeMem(Book, NumPages*SizeOf(PPage));
  Book:=NewBook; {Must be done before relocating, for BlockMove}
  If (LastPage <> NIL) then begin
    {Now it is tricky. It would be nice to use last page relocating in
     conjunction with making Count free slots starting with Index, in order
		 to avoid moving some blocks twice. The problem arises, when Index
		 is within the last page. Then last page should be split in two chunks.
		 Besides, since Points is still not updated, BlockMove function is used,
		 which does not perform range checks.}
    BlockSize:=Points mod PageLength; {Old last page size}
    If BlockSize=0 then BlockSize := Points; {It was only one page}
    Pts:=Index - Points + BlockSize;
    If Pts > 0 then begin {Index >= Points-BlockSize}
      BlockMove(LastPage^, Points-BlockSize, Pts, True);
      BlockMove(AddWordToPtr(LastPage,Pts*ESize)^, Index+Count, BlockSize-Pts, True);
      Pts:=0; {No further relocation needed}
    end else begin {Move last page as a whole, putting it at the very end.}
  	  BlockMove(LastPage^, NewPts - BlockSize, BlockSize, True);
      Pts:=-Pts; {This much should be still relocated}
    end;
    {Deallocate old last page}
{$IFDEF MSDOS}	  FreeMem(LastPage, BlockSize*ESize);
{$ELSE}           GlobalFreePtr( LastPage);
{$ENDIF}
  end else Pts:=Points-Index;
  PageLength:=NewPageSize;
  Points:=NewPts;
  MakeSpace:=True;
  {Now relocate everything except last page, if needed.
	 It is possible now to use CopyData, since Self is updated.}
  If Pts > 0 then
    CopyData( Index, @Self, Count+Index, Pts);
Ex:
  HeapError:=HAlert;
end;

procedure TAbstArray.RemoveSpace( Index, Count : longint);
var I, BlockSize, NumPages, Pgs, ESize : word;
    Pts : longint;
begin
  ESize:=ElementSize;
  If (Pages=0) or (ESize=0) then Exit;
  Pts:=Points-Count; {This will be new Points value}
  If (Pts > 0) and (Index < Pts) then {Relocate data}
    CopyData( Index, @Self, Count+Index, Pts-Index);
   {Now actually deallocate memory}
  Pgs:=DivUp(Pts, PageLength); {New number of pages}
  NumPages:=Pages; {Old number of pages}
  BlockSize:= Points mod PageLength ; {Last short page}
  If (NumPages=Pgs) then begin {Just cut last page}
    If BlockSize=0 then BlockSize:=PageLength;
{$IFDEF MSDOS}    CutHeapBlock(Book^[NumPages-1],
                               BlockSize*ESize, {Old size}
		                           (Pts mod PageLength)*ESize); {New size}
{$ELSE}       GlobalReallocPtr(Book^[NumPages-1],
                               (Pts mod PageLength)*ESize,  {New size}
                               gFlag);
{$ENDIF}
  end else begin
    I:=NumPages;
	  If (BlockSize > 0) then begin {deallocate last short page completely}
{$IFDEF MSDOS}      FreeMem(Book^[I-1], BlockSize*ESize);
{$ELSE}             GlobalFreePtr( Book^[I-1]);
{$ENDIF}
      Dec(I);
	  end;
    While I > Pgs do begin {deallocate full pages}
{$IFDEF MSDOS}      FreeMem(Book^[I-1], PageLength*ESize);
{$ELSE}             GlobalFreePtr( Book^[I-1]);
{$ENDIF}
      Dec(I);
    end;
    BlockSize:=Pts mod PageLength;
	  If BlockSize > 0 then begin {cut last page}
{$IFDEF MSDOS}      CutHeapBlock(Book^[I-1], PageLength*ESize, BlockSize*ESize);
{$ELSE}         GlobalReallocPtr(Book^[I-1], BlockSize*ESize, gFlag);
{$ENDIF}
    CutHeapBlock(Pointer(Book), NumPages*SizeOf(PPage), Pgs*SizeOf(PPage) );
    end;
    PageLength:=MinLong(Pts,PageLength); {If only one page left}
  end;
  Points:=Pts;
end;

{$IFNDEF MSDOS}
begin
  {Make gFlag equal to HeapAllocFlags as a good first approximation.}
  gFlag := HeapAllocFlags;
{$ENDIF}
end.