{$A-}
{$B-}
{$D-}
{$E-}
{$F+}
{$I-}
{$L-}
{$N-}
{$O+}
{$R-}  {Range checking off}
{$S-}
{$V-}

UNIT Ksim_Str;
{+H
---------------------------------------------------------------------------
  File        - Ksim_Str.PAS
  Copyright (c) Klingon Software Services 1987..1992 except where noted.
                All rights reserved.
  Author      - Klingon Software Services (except where otherwise noted).
                2437 Bay Area Blvd #20, Houston, TX 77058
  Purpose     - String and character manipulation routines.
  Revised     - 1993.0804 (KSB) Subsetted KSTRING for KSIM.
---------------------------------------------------------------------------}
INTERFACE
USES
  TPstring;   {from TurboPower Professional V:5.07}

              {------------------------------}
              {Trimming & padding}

              {------------------------------}
              {Parsing, splitting, etc}

{01}FUNCTION  Before(source,target:STRING):STRING;
{02}FUNCTION  After(source,target:STRING):STRING;
{05}FUNCTION  Replace(s,substr,newstr:STRING):STRING;
{06}FUNCTION  ReplaceAll(s,substr,newstr:STRING):STRING;

              {------------------------------}
              {formatting}

{06}FUNCTION  Long2LStr(L:LongINT; width:BYTE):STRING;

              {------------------------------}
              {type conversion}

              {------------------------------}
              {Pattern matching}

              {------------------------------}
              {character tests}

              {------------------------------}
              {other}

     {====================================================================}

IMPLEMENTATION

              {------------------------------}
              {Trimming & Padding}


              {------------------------------}
              {Parsing, splitting, etc.}


{}FUNCTION Before(source,target:STRING):STRING;
{+H
---------------------------------------------------------------------------
  Purpose     - Returns all of the source string up to but not including
                the first occurance of the target string.
  Declaration - Before(source,target:STRING)
  Result type - string.
  Author      - Dick Pountain. Byte; Dec 1988; Pp.307-314
---------------------------------------------------------------------------}
  BEGIN
    IF Pos(target,source) = 0 THEN
      Before := source
    ELSE
      Before := Copy(source,1,Pred(Pos(target,source)));
{}END {Before};



{}FUNCTION After(source,target:STRING):STRING;
{+H
---------------------------------------------------------------------------
  Purpose     - Returns all of the source string that follows (but does not
                include) the first occurance of the target string.
  Declaration - After(source,target:STRING)
  Result type - string.
  Author      - Dick Pountain. Byte; Dec 1988; Pp.307-314
---------------------------------------------------------------------------}
  BEGIN
    IF Pos(target,source) = 0 THEN
      After := ''
    ELSE
      After := Copy(source,Pos(target,source)+Length(target),Length(source));
{}END {After};



{}FUNCTION  Replace(s,substr,newstr:STRING):STRING;
{+H
---------------------------------------------------------------------------
  Purpose     - Replace the first occurance of SUBSTR found in S with NEWSTR
  Declaration - Replace(s,substr,newstr:STRING)
  Result type - string.
---------------------------------------------------------------------------}
  BEGIN
    IF Pos(subStr,s)>0 THEN
      Replace := Before(s,substr)+newStr+After(s,subStr)
    ELSE
      Replace := s;
{}END {Replace};



{}FUNCTION  ReplaceAll(s,substr,newstr:STRING):STRING;
{+H
---------------------------------------------------------------------------
  Purpose     - Replace all occurances of SUBSTR found in S with NEWSTR.
  Declaration - ReplaceAll(s,substr,newstr:STRING)
  Result type - string.
---------------------------------------------------------------------------}
  BEGIN
    WHILE Pos(subStr,s)>0 DO
      s := Replace(s,substr,newstr);
    ReplaceAll := s;
{}END {ReplaceAll};


              {------------------------------}
              {Formatting}



{}FUNCTION Long2LStr(L:LongINT; width:BYTE):STRING;
{+H
---------------------------------------------------------------------------
  Purpose     - Convert a LongINT/Word/Integer/Byte/ShortInt to a string of
                at least WIDTH character, left padded with blanks if required.
  Declaration - Long2LStr(L:LongINT; width:BYTE)
  Result type - string.
  Revised     - 1992.0423 (KSB) Used Str to convert L to S.
---------------------------------------------------------------------------}
  VAR
    s    : STRING;
  BEGIN
    Str(L,s);
    Long2LStr := LeftPad(s,width);
{}END {Long2LStr};


              {------------------------------}
              {Type Conversion}


              {------------------------------}
              {Pattern Matching}


              {------------------------------}
              {Character testing}


              {------------------------------}
              {Other}

BEGIN
END {Ksim_Str}.
