{$A+}
{$B-}
{$D-}
{$E-}
{$F+}  {Must be +}
{$I-}
{$L-}
{$N-}
{$O-}
{$R-}
{$S-}
{$V-}

UNIT KSIM_com;
{+H
-------------------------------------------------------------------------
  Version     - 5.01

  File        - KSIM_COM.PAS

  Copyright   - None. Public Domain.

  Author      - Keith S. Brown (except where otherwise noted)
                713-483-8952
                Surface mail:              Email:(brown@smd4.jsc.nasa.gov)
                  K.Brown                     or (brownk@samnet.jsc.nasa.gov)
                  Code:NASA/JSC/ES64
                  Houston, TX 77058 (USA)  Voice:(713)483-8952

  Purpose     - Common declarations for KSIM simulation library.

  References  -
       "Introduction to Simulation and SLAM"
       by A. Alan B. Pritsker and Claude Dennis Pegden
       A Halsted Press Book, John Wiley & Sons
       Systems Publishing Corporation

  Remarks     -
  o  For a minimal model that integrates differental equations, the
     following modules will be required:
     1)  a main program  (sets output files array sizes, calls KSIM)
     2)  a STATE subroutine which has all differental equations
         written in canonical form as state equations, ie. given the
         second order differental equation in X:

            Xdd(t) = A Xd(t) + B X(t) + C
                                              then
            ss(1) = X(t)
            dd(1) = Xd(t) = ss(2)
            dd(2) = Xdd(t)
                                              which would be coded in
                                              subroutine STATE as:
            dd(1) = ss(2)
            dd(2) = A * ss(2) + B * ss(1) + C
                                              where dd(.) and ss(.)
                                              are variables provided
                                              by KSIM.

     3) an initial conditions routine which can either be UINPUT or
        INTLC.  Normally values are initialized in INTLC and UINPUT
        is written as a menu to change the defaults established in
        INTLC.

     This unit should be "USED" in any program or unit that references
     KSIM variables, types, records or constants.
---------------------------------------------------------------------------}
INTERFACE

CONST
  CRLF   = #13#10;
  FormFeed    = #12;
  MaxStore    = 100;
  version= '5.01';

TYPE
{ REAL        = EXTENDED;}
  VarType= (_dd, _ss, _xx, _const);
  DirectnType = (_either,_neg,_pos);
  Priorities  = ({ ranking for simultaneous calendar event executions.}
  _FIFO,   { first-in first-out }
  _LIFO,   { last-in first-out  }
  _LEF,    { low-event-first    }
  _HEF);   { high-event-first   }


CONST
  RankImage   : ARRAY[Priorities] OF STRING[4]   = ('FIFO','LIFO','LEF ','HEF ');
  VarImage    : ARRAY[VarType]    OF STRING[2]   = ('DD','SS','XX','C=');
  DirImage    : ARRAY[DirectnType]OF STRING[3]   = ('+/-',' - ',' + ');
  YesNo  : ARRAY[BOOLEAN]    OF STRING[3]   = ('NO ','YES');

TYPE
  EventType   = RECORD
    eventNo   : INTEGER;     {svent[i,1]}
    crossVar  : VarType;     {svent[i,2]}
    varIndex  : WORD;        {svent[i,3]}
    directn   : DirectnType; {svent[i,4]}
    thresVar  : VarType;     {svent[i,5]}
    tolerance : REAL;        {svent[i,7]}
    CASE VarType OF
      _const  : (value     : REAL);      {svent[i,6]}
      _dd,_ss,
      _xx     : (thresIndex: WORD);
  END {RECORD};

  RecordType  = RECORD
    variable   : VarType;
    INDEX      : WORD;
    description: STRING[15];
  END {RECORD};

TYPE
  StoreReal   = ARRAY[1..MaxStore]OF REAL;
  StoreByte   = ARRAY[1..MaxStore]OF BYTE;

  KSIM0_Type  = RECORD
    count     : WORD;        { temporary var }
    nnrns     : INTEGER;     { Current run number }
    maxruns   : WORD;        { maximum number of runs to make }
  END {RECORD};

  KSIM1_Type  = RECORD
    nname     : STRING[15];  {*User name}
    nprjct    : STRING[15];  {*Project name, title or id}
    ilist     : BOOLEAN;     {*'YES' or 'NO'; request for input listing. default :: 'YES'}
    ixqt      : BOOLEAN;     {*'YES' or 'NO'; request for execution. default :: 'YES'}
    isimrep   : BOOLEAN;     {*'YES' or 'NO'; request for simulation summary report. default :: 'YES'}
    reInit    : BOOLEAN;     {*'YES' or 'NO'; reinitialize after 1st simulation. default :: 'YES'}
    cdate     : LongINT;     { Current date }
    lpsym     : Priorities;  {*'FIFO', 'LIFO', 'LEF', or 'HEF';  default :: 'FIFO'}
    stop      : BOOLEAN;     { Immediate stop flag. }
  END {RECORD};

  KSIM2_type  = RECORD    {Overall Control...}
    tstart    : REAL;        {*Initial simulation time, default :: 0.00}
    tfin      : REAL;        {*Ending simulation time default :: 1.E20}
    tstep     : REAL;        {*Delta time step default :: 0.05}
    tlast     : REAL;        { Previous time value }
    tnow      : REAL;        { Current simulation time }
    tnext     : REAL;        { Next event time default :: 1.E20}
    ttsave    : REAL;        { Time at which to save DD & SS variables.}
    dtnow     : REAL;        { Current delta time step }
  END {RECORD};


  KSIM3_Type  = RECORD    {Discrete Event Stuff...}
    matrib    : WORD;        {*Max allowed attributes }
    atrib     : StoreReal;   { Attribute buffer }
    nxqt      : INTEGER;     { No.of executed events }
    nsim      : INTEGER;     { No.of current simultaneous events on calendar queue. }
    nsched    : LongINT;     { No.of scheduled events }
    krank     : ARRAY[1..100]OF POINTER;{ Simultaneous event cell pointers. }
    calendar  : POINTER;     { Linked list Event calendar }
  END {RECORD};


  KSIM4_Type  = RECORD    {Integration controls...}
    dtsave    : REAL;        {*Delta time between recorded values. default :: 1.E20}
    dtmax     : REAL;        {*Max integration step size default :: dtsave }
    dtmin     : REAL;        {*Min integration step size default :: 0.01 * dtmax}
    dtfull    : REAL;        { Full time step during integration. default :: 1.E20}
    neqdt     : INTEGER;     {*No.of differential equations default :: 0}
    neqst     : INTEGER;     {*No.of state equations default :: 0}
    neqtt     : INTEGER;     { Total number of equations. }
    aerr      : REAL;        {*Absolute error limit }
    rerr      : REAL;        {*Relative error limit }
    depf      : BOOLEAN;     {*Discrete_event_print_flag.
                             {  If true then prints message on the release of a discrete event.}
  END {RECORD};


  KSIM5_Type  = RECORD    {D()/DT variables...}
    dd        : StoreReal;   { Current value of derivative }
    ddl       : StoreReal;   { Previous value of derivative }
    ss        : StoreReal;   { Current value of state var. }
    ssl       : StoreReal;   { Previous value of state var. }
    xx        : StoreReal;   { User buffer }
    xxl       : StoreReal;   { Previous values of user buffer  1992.0129}
  END {RECORD};


  KSIM6_Type  = RECORD    {STATE EVENTS...}
    svent     : ARRAY[1..MaxStore]OF EventType; { State event discriptions }
    nthres    : INTEGER;     {*No.of threshold crossings to look for }
    sepf      : BOOLEAN;     {*State_event_print_flag.
                             {  If true then prints message on a threshold crossing that triggers a state event.}
    nsvent    : INTEGER;     { No.of state events executed, default :: 0}
  END {RECORD};

  KSIM7_Type  = RECORD    {RECORDING...}
    nvar      : INTEGER;     {*No.of variables to be 'saved' to the data file}
    kkvent    : BOOLEAN;     {*Save values at (discrete or state) event times flag.}
    vvar      : ARRAY[1..50]OF RecordType;  { Saved variable discriptions}
  END {RECORD};



CONST
  RprtFileName: STRING[79]   = 'KSIM.RPT';
  DataFileName: STRING[79]   = 'KSIM.DAT';

{+D
file name constants
---------------------------------------------------------------------------
  Purpose     - Establishes the default name and path for the report and
                output data files.

  Remarks     - These names should not be wildcarded (no error checking is
                done to ensure the absence of '*' and '?').  If the named
                files exist, they are erased and reopened for output.  If
                the do not exist, they are created.

                Constant          Default value
                --------          -------------
                RprtFileName      'KSIM.RPT'
                DataFileName      'KSIM.DAT'
}

CONST
  EventPtr    : POINTER = NIL;  {Proc rqrd for discrete & state events}
  IntlcPtr    : POINTER = NIL;  {Proc to initialize user values & Ksim vars.}
  UinputPtr   : POINTER = NIL;  {Proc for user defined menus}
  UprntInPtr  : POINTER = NIL;  {Proc to print user values at start of sim}
  UreportPtr  : POINTER = NIL;  {Proc to print user values at end of sim}
  StatePtr    : POINTER = NIL;  {Proc rqrd for continuous, difference or differential}
  DfltPtr: POINTER = NIL;  {If menus required: "DfltPtr := @Ksim_B.Dflt;"}

{+D
procedure pointer constants
---------------------------------------------------------------------------
  Purpose     - Links in non local procedures that handle initialization
                reporting, event handling, and that define the state
                equations.

  Remarks     - All procedures that are linked in must be compiled using
                $F+ compiler option to ensure that the simulation does
                not crash.

  Constant    RQD?  Definition/declaration/suggested value
  --------    ----  --------------------------------------
  EventPtr    YES   Procedure to handle state & discrete events
                    Declaration: PROCEDURE Event(n:INTEGER);

  IntlcPtr    YES   Procedure to initialize user & selected KSIM variables
                    Declaration: PROCEDURE Intlc;

  UinputPtr   NO    User defined auxiliary menu system
                    Declaration: PROCEDURE Uinput;

  UprntInPtr  NO    Procedure to "echo" user variables before simulation
                    starts
                    Declaration: PROCEDURE UprntIn;

  UreportPtr  NO    Procedure to report user variables after simulation
                    completes
                    Declaration: PROCEDURE Ureport;

  StatePtr    YES   Procedure containing state equations.
                    Declaration: PROCEDURE State;

  DfltPtr     NO    KSim default menu system.
                    Declaration: PROCEDURE Dflt;
                    @KSIM_B.Dflt;
}

VAR
  Ksim0  : Ksim0_Type;
  Ksim1  : Ksim1_Type;
  Ksim2  : Ksim2_Type;
  Ksim3  : Ksim3_Type;
  Ksim4  : Ksim4_Type;
  Ksim5  : Ksim5_Type;
  Ksim6  : Ksim6_Type;
  Ksim7  : Ksim7_Type;

  nprnt  : TEXT;        { Report file logical file no. }
  iplot  : TEXT;        { Data file variable.}

     {====================================================================}

IMPLEMENTATION

BEGIN
END {BEGIN}.
