{$A+}
{$B-}
{$D+}
{$E-}
{$F+}
{$I+}
{$L+}
{$N-}
{$O-}
{$R+}
{$S+}
{$V-}

UNIT Ksim_B;
{+H
-------------------------------------------------------------------------
  Version     - 5.01

  File        - KSIM_B.PAS

  Copyright   - None. Public Domain.

  Author      - Keith S. Brown (except where otherwise noted)
                713-483-8952
                Surface mail:              Email:(brown@smd4.jsc.nasa.gov)
                  K.Brown                     or (brownk@samnet.jsc.nasa.gov)
                  Code:NASA/JSC/ES64
                  Houston, TX 77058 (USA)  Voice:(713)483-8952

  Purpose     - Menu interface to KSIM simulation package.

  Remarks     - This unit is optional as it merely provides a menu based
                interface to the simulation.

  Requires    - TPCMD.PAS     - Turbo Power Software v:5.x or later
                TPCRT.PAS     - Turbo Power Software v:5.x or later
                TPDIR.PAS     - Turbo Power Software v:5.x or later
                TPDOS.PAS     - Turbo Power Software v:5.x or later
                TPDATE.PAS    - Turbo Power Software v:5.x or later
                TPEDIT.PAS    - Turbo Power Software v:5.x or later
                TPENTRY.PAS   - Turbo Power Software v:5.x or later
                TPMENU.PAS    - Turbo Power Software v:5.x or later
                TPPICK.PAS    - Turbo Power Software v:5.x or later
                TPWINDOW.PAS  - Turbo Power Software v:5.x or later
                TPSTRING.PAS  - Turbo Power Software v:5.x or later

                KSIM_COM.PAS  - (part of KSIM package)
                KSIM_STR.PAS  - (part of KSIM package)
                KSIMDATE.PAS  - (part of KSIM package)

                DOS.TPU       - Borland International

  Language    - Borland International's Turbo Pascal 5.5 or later.

  Revised     - 1991.1107 (KSB) Converted version 4.30 from Harris Fortran
                to Borland International's Turbo Pascal 5.5.
              - 1993.0804 (KSB) Reformatted with KPPF.
---------------------------------------------------------------------------}
INTERFACE
CONST
  cfgName: STRING[79]   = '*.CFG';

{+D
cfgName constant
---------------------------------------------------------------------------
  Purpose     - Establishes the default name and path for the configuration
                file.

  Remarks     - If the menus from KSIM_B are linked in, then cfgName sets
                the wildcarded or full path name for the simulation's
                configuration file.
}

{}PROCEDURE Dflt;

     {====================================================================}

IMPLEMENTATION
USES
  DOS,

  TPstring, TPcrt,    TPcmd,    TPdir,    TPdos,
  TPedit,   TPentry,  TPwindow, TPmenu,   TPpick,
  Ksim_str,
  Ksim_Com;

CONST
  FRAMED = TRUE;
  CLEARED= TRUE;
  UNSAVED= FALSE;

  Bdy    = $1B;
  Dis    = $17;
  Hdr    = $4F;
  Frm    = $14;
  Hlp    = $1F;

  AltX   = #173;
                               {Frm  Hdr  Bdy  Sel  Hi   Hlp  Dis  Shdw}
  Mcolor : MenuColorArray    = ($1E, $6F, $17, $61, $1E, $17, $17, $07);
                               {Bdy  Frm  Hdr  Sel  aBdy aSel Dis}
  Pcolor : PickColorArray    = ($17,$1E, $6F, $61, $17, $61, $18);


{}PROCEDURE About;
{---------------------------------------------------------------------------}
  CONST
    x0   = 10;
    y0   = 10;
    hite = 9;
    width= 61;
  VAR
    W    : WindowPtr;
  BEGIN
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;
                                                                 {Bdy Frm Hdr}
    IF MakeWindow(W,x0,y0,x0+width,y0+hite,FRAMED,CLEARED,UNSAVED,Bdy,Frm,Hdr,' KSIM ') AND
    DisplayWindow(W) THEN BEGIN
                     {....^....1....^....2....^....3....^....4....^....5....^....6}
      FastTextWindow(Center(#26'Version:'+version+#27,width-1),1,1);
      FastTextWindow('Ksim provides for continuous & discrete event simulations' , 2,2);
      FastTextWindow('by processing upto 100 difference or differential equations',3,2);
      FastTextWindow('An event calendar is maintained for discrete simulations.',  4,2);
      FastTextWindow('Threshold crossing (with release of "state" events) is done',5,2);
      FastTextWindow('for continuous simulations. Combined simulations are also',  6,2);
      FastTextWindow('possible.',7,2);
      FastWriteWindow('[ANY KEY]',8,50,Hdr);
      IF ReadKeyWord = 0 THEN;
    END {IF};
    DisposeWindow(EraseTopWindow);
{}END {About};




{}FUNCTION EditWindowBool(
       row,col   : BYTE;
       Yes,No    : CHAR;
       B:BOOLEAN;
       Title,Msg : STRING):BOOLEAN;
{---------------------------------------------------------------------------
  Parameters
      row,col - screen location of upper left corner of entry box.
      min,max - lower & upper bounds permitted for value.
      B       - original value, returned as function result if [ESC] pressed.
      title   - Title of entry box.
      msg     - Edit prompt.

  Revised     - 1991.1107 (KSB) Wrote initial version.
---------------------------------------------------------------------------}
  VAR
    WP   : WindowPtr;
    maxSize   : LongINT;
    X0, X1    : BYTE;
    MaxLen    : BYTE;
    Bsave: BOOLEAN;
    escaped   : BOOLEAN;
    c    : CHAR;
  BEGIN
    msg     := msg + ' ('+Yes+'/'+No+') ';
    Bsave   := B;
    maxLen  := 1;

    IF col + Length(Msg) + MaxLen + 2 > 78 THEN
      MaxSize := 78 - 2 - col
    ELSE
      MaxSize := Length(Msg) + MaxLen + 2;

    X0 := col;
    X1 := X0 + MaxSize + 2;
    CASE B OF
      TRUE : c := Yes;
      ELSE
        c := No;
    END {CASE};

    Escaped          := FALSE;
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;
    TPEdit.WindowRelative := TRUE;

    IF MakeWindow(WP,x0,row,x1,row+2,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) THEN
      IF DisplayWindow(WP) THEN BEGIN
        FastTextWindow(Msg,1,1);
        ReadCharacter('['+c+']',1,Length(Msg),frm,[Yes,No,#27,#13],c);
        CASE c OF
         #13,
         #27 : escaped := TRUE;
          ELSE
          IF c = Yes THEN
            B := TRUE
          ELSE
            B := FALSE;
        END {CASE};
        DisposeWindow(EraseTopWindow);
      END {IF};

    EditSize := 0;
    IF escaped THEN
      EditWindowBool := Bsave
    ELSE
      EditWindowBool := B;
{}END {EditWindowBool};




{}FUNCTION EditWindowLong(
       row,col   : BYTE;
       Min,Max,L : LongINT;
       Title,Msg : STRING):LongINT;
{---------------------------------------------------------------------------
  Parameters
      row,col - screen location of upper left corner of entry box.
      min,max - lower & upper bounds permitted for value.
      L       - original value, returned as function result if [ESC] pressed.
      title   - Title of entry box.
      msg     - Edit prompt.

  Revised     - 1991.0918 (KSB) Wrote initial version.
---------------------------------------------------------------------------}
  VAR
    WP   : WindowPtr;
    maxSize   : LongINT;
    X0, X1    : BYTE;
    MaxLen    : BYTE;
    Lsave: LongINT;
    escaped   : BOOLEAN;
  BEGIN
    Lsave   := L;
    maxLen  := 0;
    maxSize := Max;
    WHILE maxSize > 1 DO BEGIN
      Inc(maxLen);
      maxSize := maxSize DIV 10;
    END {WHILE};
    Inc(maxLen);

    IF col + Length(Msg) + MaxLen + 2 > 78 THEN
      MaxSize := 78 - 2 - col
    ELSE
      MaxSize := Length(Msg) + MaxLen + 2;

    X0 := col;
    X1 := X0 + MaxSize + 2;

    Escaped          := TRUE;
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;
    TPEdit.WindowRelative := TRUE;

    IF MakeWindow(WP,x0,row,x1,row+2,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) THEN
      IF DisplayWindow(WP) THEN BEGIN
        ReadLongInt(Msg,1,1,MaxLen,bdy,frm,Min,Max,Escaped,L);
        DisposeWindow(EraseTopWindow);
      END {IF};

    EditSize := 0;
    IF escaped THEN
      EditWindowLong := Lsave
    ELSE
      EditWindowLong := L;
{}END {EditWindowLong};




{}FUNCTION Real2Str(R : Float; Width, Places : ShortINT) : STRING;
{---------------------------------------------------------------------------
  Purpose     - Convert a real to a string
---------------------------------------------------------------------------}
  VAR
    S    : STRING;
  BEGIN
    IF Places < 0 THEN
      Str(R:Abs(Width),S)
    ELSE
      Str(R:Abs(Width):Places, S);

    Real2Str := S;
{}END {Real2Str};




{}FUNCTION EditWindowReal(
       row,col   : BYTE;
       Min,Max,R : REAL;
       Title,Msg : STRING):REAL;
{---------------------------------------------------------------------------
   Parameters
      row,col - screen location of upper left corner of entry box.
      min,max - lower & upper bounds permitted for value.
      R       - original value, returned as function result if [ESC] pressed.
      title   - Title of entry box.
      msg     - Edit prompt.

  Revised     - 1991.0918 (KSB) Wrote initial version.
---------------------------------------------------------------------------}
  LABEL         ExitPt;
  VAR
    WP   : WindowPtr;
    maxSize   : BYTE;
    X0, X1    : BYTE;
    MaxLen    : INTEGER;
    Rsave: REAL;
    escaped   : BOOLEAN;
    decimals  : ShortINT;
    s    : STRING;
    ok   : BOOLEAN;
  BEGIN
    Rsave   := R;
    maxLen  := 14;

    IF (R > 999999.0) OR (r < 0.00001) THEN
      decimals := -1
    ELSE
      decimals :=  6;

    IF col + Length(Msg) + MaxLen + 2 > 78 THEN
      MaxSize := 78 - 2 - col
    ELSE
      MaxSize := Length(Msg) + MaxLen + 2;

    X0 := col;
    X1 := X0 + MaxSize + 2;

    Escaped          := TRUE;
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;
    TPEdit.WindowRelative := TRUE;

    IF MakeWindow(WP,x0,row,x1,row+2,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) THEN
      IF DisplayWindow(WP) THEN BEGIN
        s := Real2Str(R,maxLen,decimals);
        REPEAT
          ReadString(Msg,1,1,MaxLen,bdy,frm,frm,Escaped,s);
          IF escaped THEN BEGIN
            s := Real2Str(R,maxLen,decimals);
            FastWriteWindow(Pad(s,maxLen), 1,1+Length(msg),frm);
            GOTO ExitPt;
          END {IF};

          ok := TRUE;
          IF NOT Str2Real(s,R) THEN
            ok := FALSE
          ELSE
          IF NOT (min = max) THEN
            IF (R < min) OR (R > max) THEN
              ok := FALSE;

          IF NOT ok THEN BEGIN
            FastWriteWindow('Invalid number',1,1+Length(msg),frm);
            Write(^G);
          END {IF};
        UNTIL ok;

        ExitPt:
        DisposeWindow(EraseTopWindow);
      END {IF};

    EditSize := 0;
    IF escaped THEN
      EditWindowReal := Rsave
    ELSE
      EditWindowReal := R;
{}END {EditWindowReal};




{}FUNCTION EditWindowStr(
       row,col   : BYTE;
       maxLen:BYTE;
       S:STRING;
       Title,Msg : STRING):STRING;
{---------------------------------------------------------------------------
   Parameters
      row,col - screen location of upper left corner of entry box.
      maxLen  - maximum number of characters permitted in resulting string.
      S       - original value, returned as function result if [ESC] pressed.
      title   - Title of entry box.
      msg     - Edit prompt.

  Revised     - 1991.1107 (KSB) Wrote initial version.
---------------------------------------------------------------------------}
  VAR
    WP   : WindowPtr;
    X0, X1    : BYTE;
    MaxSize   : BYTE;
    Ssave: STRING;
    escaped   : BOOLEAN;
  BEGIN
    Ssave   := S;
    maxSize := 0;

    IF col + Length(Msg) + MaxLen + 2 > 78 THEN
      MaxSize := 78 - 2 - col
    ELSE
      MaxSize := Length(Msg) + MaxLen + 2;

    X0 := col;
    X1 := X0 + MaxSize + 2;

    Escaped          := TRUE;
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;
    TPEdit.WindowRelative := TRUE;
    TPedit.EditSize       := MaxSize - Length(Msg) - 2;

    IF MakeWindow(WP,x0,row,x1,row+2,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) THEN
      IF DisplayWindow(WP) THEN BEGIN
        ReadString(Msg,1,1,MaxLen,bdy,frm,frm,Escaped,S);
        DisposeWindow(EraseTopWindow);
      END {IF};

    EditSize := 0;
    IF escaped THEN
      EditWindowStr := Ssave
    ELSE
      EditWindowStr := S;
{}END {EditWindowStr};




{}FUNCTION PriorityName(i:WORD):STRING;
{---------------------------------------------------------------------------}
  BEGIN
    IF (i>0) AND (i<5) THEN
      PriorityName := RankImage[Priorities(i-1)]
    ELSE
      PriorityName := '';
{}END {PriorityName};




{}FUNCTION PickRanking(row,col:BYTE; P:Priorities):Priorities;
{---------------------------------------------------------------------------}
  VAR
    i    : WORD;
  BEGIN
    i := Succ(Ord(P));
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;

    PickSrch := CharPickSrch;
    IF PickWindow(@PriorityName,4,col,row,col+6,row+6,FRAMED,Pcolor,'',i) THEN;
    CASE PickCmdNum OF
      PKSselect : PickRanking := Priorities(Pred(i));
      ELSE
        PickRanking := P;
    END {CASE};
{}END {PickRanking};




CONST
  d_about= 001;

  d_file = 002;
  d_fload= 003;
  d_fsave= 004;
  d_fdoit= 005;

  d_gen  = 006;
  d_guser= 007;
  d_gtitle    = 008;
  d_gecho= 009;
  d_gprint    = 010;
  d_gdoSim    = 011;
  d_greinit   = 012;
  d_gReport   = 013;
  d_gData= 014;

  d_cont = 015;
  d_cStart    = 016;
  d_cStop= 017;
  d_cStep= 018;
  d_cMinStep  = 019;
  d_cMaxStep  = 020;
  d_cRecStep  = 021;
  d_cRelErr   = 022;
  d_cAbsErr   = 023;
  d_cdbydt    = 024;
  d_cState    = 025;

  d_intlc= 026;

  d_record    = 027;
  d_rRecVar   = 028;
  d_rSave= 029;
  d_rEditVar  = 030;

  d_state= 031;
  d_sEvents   = 032;
  d_sPrint    = 033;
  d_sEdit= 034;

  d_discrete  = 035;
  d_dAttrib   = 036;
  d_dRank= 037;
  d_dPrint    = 038;

  d_quit = 039;


{}FUNCTION Display(s:STRING; k:MenuKey):STRING;
{---------------------------------------------------------------------------}
{}{}FUNCTION RealToStr(r:REAL):STRING;
    VAR
      s  : STRING;
    BEGIN
      IF r <  0.1 THEN
        Str(r:13:11,s)
      ELSE
      IF r >= 1000000.0 THEN
        Str(r:13,s)
      ELSE
        Str(r:13:6,s);

      RealToStr := s;
{}{}END {RealToStr};


  BEGIN
    CASE k OF
      d_gUser    : s := Copy(s,1,12)+Ksim1.nname;
      d_gTitle   : s := Copy(s,1,12)+Ksim1.nprjct;
      d_gEcho    : s := Copy(s,1,19)+YesNo[Ksim1.iList];
      d_gPrint   : s := Copy(s,1,19)+YesNo[Ksim1.isimRep];
      d_gDoSim   : s := Copy(s,1,19)+YesNo[Ksim1.ixqt];
      d_gReinit  : s := Copy(s,1,19)+YesNo[Ksim1.reInit];
      d_gReport  : s := Copy(s,1,13)+JustFileName(RprtFileName);
      d_gData    : s := Copy(s,1,13)+JustFileName(DataFileName);

      d_cStart   : s := Copy(s,1,17)+RealToStr(Ksim2.tStart);
      d_cStop    : s := Copy(s,1,17)+RealToStr(Ksim2.tfin);
      d_cStep    : s := Copy(s,1,17)+RealToStr(Ksim2.tStep);
      d_cMinStep : s := Copy(s,1,17)+RealToStr(Ksim4.dtMin);
      d_cMaxStep : s := Copy(s,1,17)+RealToStr(Ksim4.dtMax);
      d_cRecStep : s := Copy(s,1,17)+RealToStr(Ksim4.dtSave);
      d_cRelErr  : s := Copy(s,1,17)+RealToStr(Ksim4.rErr);
      d_cAbsErr  : s := Copy(s,1,17)+RealToStr(Ksim4.aErr);
      d_cDbyDT   : s := Copy(s,1,26)+Long2LStr(Ksim4.neqdt,3);
      d_cState   : s := Copy(s,1,26)+Long2LStr(Ksim4.neqst,3);

      d_rRecVar  : s := Copy(s,1,28)+Long2LStr(Ksim7.nvar,3);
      d_rSave    : s := Copy(s,1,28)+YesNo[Ksim7.kkvent];

      d_sPrint   : s := Copy(s,1,39)+YesNo[Ksim6.sepf];
      d_sEvents  : s := Copy(s,1,22)+Long2LStr(Ksim6.nthres,3);

      d_dAttrib  : s := Copy(s,1,41)+Long2Lstr(Ksim3.matrib,3);
      d_dRank    : s := Copy(s,1,40)+RankImage[Ksim1.lpSym];
      d_dPrint   : s := Copy(s,1,42)+YesNo[Ksim4.depf];
    END {CASE};
    Display := s;
{}END {Display};




{}PROCEDURE InitMenu(VAR M : Menu);
{---------------------------------------------------------------------------}
  CONST
    HelpLn    = 25;
    FrstLn    = 1;
    ScndLn    = 2;
    EXPLODED  = TRUE;
    SHADOWED  = TRUE;
    NOISY= TRUE;
    Frame1    : FrameArray   = 'ĳ';

  BEGIN
    {Customize this call for special exit characters and custom item displays}
    M := NewMenu([AltX], @Display);

    SubMenu(1,FrstLn,HelpLn,Horizontal,NoFrame,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('-?-',        1,2,d_about,'About Ksim');
    MenuItem('File',       7,1,d_file, '');
    SubMenu(6,ScndLn,HelpLn,Vertical,Frame1,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('Save',   1,1,d_fsave,'Save a set of initial conditions to a file.');
    MenuItem('Load',   2,1,d_fload,'Load a set of initial conditions from a file.');
    MenuItem('.......',3,1,101,'');
    MenuItem('Execute',4,1,d_fdoit,'Execute simulation.');
    MenuItem('.......',5,1,102,'');
    MenuItem('Quit',   6,1,d_quit, 'Return to DOS without executing the simulation.');
    PopSublevel;

    MenuItem('Generator', 14,1,d_gen,'Set user name, simulation title, file names & control switches.');
    SubMenu(14,ScndLn,HelpLn,Vertical,Frame1,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('User name: ...............', 1,1,d_gUser,  'Name of person running simulation.');
    MenuItem('Title:     ...............', 2,1,d_gTitle, 'Name of simulation.');
    MenuItem('..........................', 3,1,103,'');
    MenuItem('Echo input:       Yes',      4,1,d_gEcho,  'Print initial conditions on report.');
    MenuItem('Print Summary:    Yes',      5,1,d_gPrint, 'Print a summary report.');
    MenuItem('Run simulation:   Yes',      6,1,d_gdoSim, 'Must be Yes to run simulation.  No, tests input conditions.');
    MenuItem('Reinitialize:     Yes',      7,1,d_gReinit,
            'Reinitialize initial conditions before running subsequent simulations.');
    MenuItem('..........................', 8,1,104,'');
    MenuItem('Report file:..............', 9,1,d_gReport,'Name of file to write report.');
    MenuItem('Data file:  ..............',10,1,d_gData,  'Name of file to write data.');
    PopSublevel;

    MenuItem('Continuous',27,1,d_cont,'Set starting & stopping times, time steps, integration controls.');
    SubMenu(27,ScndLn,HelpLn,Vertical,Frame1,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('Start time:     999999.999999',1,1,d_cStart,  'Simulation starts at this point along time-line.');
    MenuItem('End time:       999999.999999',2,1,d_cStop,   'Stop the simulation at this point along the time-line.');
    MenuItem('1st time step:  999999.999999',3,1,d_cStep,   'Initial time step.');
    MenuItem('Min. time step: 999999.999999',4,1,d_cMinStep,'Minimum allowable time step.');
    MenuItem('Max. time step: 999999.999999',5,1,d_cMaxStep,'Maximum allowable time step.');
    MenuItem('Recording delta:999999.999999',6,1,d_cRecStep,'Time between recording variables.');
    MenuItem('Absolute error: 999999.999999',7,1,d_cRelErr, 'Allowable absolute error during integration.');
    MenuItem('Relative error: 999999.999999',8,1,d_cAbsErr, 'Allowable relative error during integration.');
    MenuItem('.............................',9,1,105,'');
    MenuItem('No. of d()/dt equations: 999',10,1,d_cDbyDT,  'Number of specified differential equations.');
    MenuItem('No. of state equations:  999',11,1,d_cState,  'Number of specified state equations.');
    PopSublevel;

    MenuItem('Intlc',     41,1,d_intlc,'Set initial values for user values (XX) and d()/dt equations.');

    MenuItem('Record',    50,1,d_record,'Select and title values to be recorded.');
    SubMenu(45,ScndLn,HelpLn,Vertical,Frame1,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('No. of recorded variables: 999',1,1,d_rRecVar, 'Number of recorded variables.');
    MenuItem('Save values @ event times: Yes',2,1,d_rSave,   'Record values if an event is released.');
    MenuItem('..............................',3,1,106,'');
    MenuItem('Edit record variables',         4,1,d_rEditVar,'Edit the variables and labels to be recorded.');
    PopSublevel;

    MenuItem('State Event',60,1,d_state,'Set thresholds for d()/dt equations.');
    SubMenu(34,ScndLn,HelpLn,Vertical,Frame1,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('No. of state events: 999',                 1,1,d_sEvents,
            'Number of events triggered because a value crossed a threshold.');
    MenuItem('Print message at state event release: Yes',2,1,d_sPrint, '');
    MenuItem('.........................................',3,1,107,'');
    MenuItem('Edit state event list',                    4,1,d_sEdit,'');
    PopSublevel;

    MenuItem('Discrete',   73,1,d_discrete,'Set parameters for discrete event simualations.');
    SubMenu(28,ScndLn,HelpLn,Vertical,Frame1,Mcolor,'');
    MenuMode(EXPLODED, SHADOWED, NOISY);
    MenuItem('No. of attributes per calendar event:   999 ',1,1,d_dAttrib,'');
    MenuItem('Simultaneous event priority ranking:   xxxx ',2,1,d_dRank,  '');
    MenuItem('............................................',3,1,108,'');
    MenuItem('Print message at discrete event release: Yes',4,1,d_dPrint, '');
    PopSublevel;

    PopSublevel;

    ResetMenu(M);
    SetMenuDelay(M, 10);

    DisableMenuItem(M,101);
    DisableMenuItem(M,102);
    DisableMenuItem(M,103);
    DisableMenuItem(M,104);
    DisableMenuItem(M,105);
    DisableMenuItem(M,106);
    DisableMenuItem(M,107);
    DisableMenuItem(M,108);
{}END {InitMenu};




CONST
  cfgLabel    : STRING[20]   = 'KSIM '+version+' Common'+^Z;


{}FUNCTION  LoadFileName(
       row:BYTE;
       mask:STRING;
       fAttr:BYTE;
   VAR fName  : STRING;
   VAR NewFile: BOOLEAN):BOOLEAN;
{---------------------------------------------------------------------------
  Purpose     - Puts up a popup window with default file.  If entered
                file is complete, an attempt is made to load that file.
                If the entered file is incomplete then the entered value
                is used as a template for a directory listing.
---------------------------------------------------------------------------}
  CONST
    x0   = 10;
    x1   = 72;
    Title: STRING[17]   = ' Load File Name ';
  VAR
    status    : WORD;
    Escaped   : BOOLEAN;
  BEGIN
    LoadFileName := FALSE;
    NewFile      := FALSE;

    IF mask = '' THEN
      mask := '*.CFG';

    mask := EditWindowStr(row,5,66,mask,Title,'');

    IF RScommand <> RSenter THEN
      Exit;

    UseFileFrame := TRUE;
    ShadowAttr   := $07;
    Shadow       := TRUE;
    pickStick    := FALSE;
    PickSrch     := CharPickSrch;
    status       := GetFileName(mask,FAttr,x0,row,x1,4,Pcolor,fName);
    PickStick    := TRUE;
    PickSrch     := NoPickSrch;

    IF (fName='') OR ((PickCmdNum<>PKSselect) AND NOT(status IN [0,3])) THEN
      Exit;

    CASE status OF
      0 : LoadFileName := TRUE;

      1,2 : {ErrWindow(' Error ','Invalid drive or directory.')};

      3 :
      BEGIN
        NewFile      := TRUE;
        LoadFileName := TRUE;
      END {BEGIN};
    END {CASE};
{}END {LoadFileName};




{}PROCEDURE LoadCommon;
{---------------------------------------------------------------------------}
  VAR
    CFV  : FILE;
    s    : STRING;
    i    : WORD;
    newFile   : BOOLEAN;
  BEGIN
    IF NOT LoadFileName(5,cfgName,AnyFile,s,newFile) OR newFile OR (NOT ExistFile(s)) THEN
      Exit;

    cfgName := s;
    Assign(CFV,s);
    Reset(CFV,1);

    BlockRead(CFV,s[1],Length(cfgLabel),i);
    s[0] := Chr(Length(cfgLabel));

    IF s = cfgLabel THEN BEGIN
      BlockRead(CFV,Ksim0,SizeOf(Ksim0),i);
      BlockRead(CFV,Ksim1,SizeOf(Ksim1),i);
      BlockRead(CFV,Ksim2,SizeOf(Ksim2),i);
      BlockRead(CFV,Ksim3.matrib,SizeOf(Ksim3.matrib),i);
      BlockRead(CFV,Ksim4,SizeOf(Ksim4),i);
      BlockRead(CFV,Ksim5,SizeOf(Ksim5),i);
      BlockRead(CFV,Ksim6,SizeOf(Ksim6),i);
      BlockRead(CFV,Ksim7,SizeOf(Ksim7),i);
    END {IF};
    Close(CFV);
{}END {LoadCommon};




{}PROCEDURE SaveCommon;
{---------------------------------------------------------------------------}
  VAR
    CFV  : FILE;
    s    : STRING;
    i    : WORD;
    newFile   : BOOLEAN;
  BEGIN
    IF NOT LoadFileName(5,cfgName,AnyFile,s,newFile) THEN
      Exit;

    s := ForceExtension(s,'CFG');
    Assign(CFV,s);
    Rewrite(CFV,1);

    BlockWrite(CFV,cfgLabel[1],Length(cfgLabel),i);
    BlockWrite(CFV,Ksim0,SizeOf(Ksim0),i);
    BlockWrite(CFV,Ksim1,SizeOf(Ksim1),i);
    BlockWrite(CFV,Ksim2,SizeOf(Ksim2),i);
    BlockWrite(CFV,Ksim3.matrib,SizeOf(Ksim3.matrib),i);
    BlockWrite(CFV,Ksim4,SizeOf(Ksim4),i);
    BlockWrite(CFV,Ksim5,SizeOf(Ksim5),i);
    BlockWrite(CFV,Ksim6,SizeOf(Ksim6),i);
    BlockWrite(CFV,Ksim7,SizeOf(Ksim7),i);

    Close(CFV);
{}END {SaveCommon};




{}PROCEDURE EditIntlc;
{---------------------------------------------------------------------------
   index         SS()                 DD()                 XX()
   -----  -------------------   -------------------   -------------------
    999)  9999999999.99999999   9999999999.99999999   9999999999.99999999
---------------------------------------------------------------------------}
  CONST
    hNo  = 0;
    x0   = 5;
    y0   = 5;
    hite = 5;
    width= 71;
    title= ' Initialize SS(), DD(), and XX() ';
  VAR
    WP   : WindowPtr;
    ESR  : ESrecord;
    INDEX: WORD;
    done : BOOLEAN;
    ExitCmd   : EStype;
    ss,dd,xx  : REAL;

{}{}PROCEDURE SetVar;
    BEGIN
      ss := Ksim5.ss[INDEX];
      dd := Ksim5.dd[INDEX];
      xx := Ksim5.xx[INDEX];
{}{}END {SetVar};


{}{}PROCEDURE Update;
    BEGIN
      Ksim5.ss[INDEX] := ss;
      Ksim5.dd[INDEX] := dd;
      Ksim5.xx[INDEX] := xx;
{}{}END {Update};


  BEGIN
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;

    IF MakeWindow(WP,x0,y0,x0+width,y0+hite,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) AND
    DisplayWindow(WP) THEN BEGIN
      InitESrecord(ESR);
      SetWrapMode(ESR,WrapAtEdges);
      SetEntryWindow(ESR,x0,y0,x0+width,y0+hite,FALSE,Bdy,Frm);

      SetPromptAttr(Bdy);
      SetFieldAttr(Bdy);
      SetStringAttr(Hdr);
      SetCtrlAttr(Frm);
      SetProtectAttrs(Dis,Dis);

      FastWriteWindow('index         SS()                 DD()                 XX()',1,1,Bdy);
      FastWriteWindow('-----  -------------------   -------------------   -------------------',2,1,Bdy);
      INDEX := 1;
      SetVar;

      SetPadChar(' ');
      SetProtection(On);
      SetRightJustify(On);
{00}    AddWordField(ESR,')',4, 6,'999', 4, 3,hNo, 0,100,INDEX);

      SetPadChar('_');
      SetProtection(Off);
{01}    AddRealField(ESR,'', 4, 8,CharStr('#',19), 4, 9,hNo, 0,0, 8, ss);
{02}    AddRealField(ESR,'', 4,30,CharStr('#',19), 4,31,hNo, 0,0, 8, dd);
{03}    AddRealField(ESR,'', 4,52,CharStr('#',19), 4,53,hNo, 0,0, 8, xx);
      SetRightJustify(Off);

      done := FALSE;
      ESR.CurrentId := 0;
      REPEAT
        exitCmd := EditScreen(ESR,ESR.CurrentID,FALSE);
        CASE exitCmd OF
          ESdone,
          ESquit :
          done := TRUE;

          ESprevRec :
          IF INDEX > 1 THEN BEGIN
            Update;
            Dec(INDEX);
            SetVar;
          END {IF};

          ESnextRec :
          IF INDEX < 100 THEN BEGIN
            Update;
            Inc(INDEX);
            SetVar;
          END {IF};

        END {CASE};
      UNTIL done;
      DisposeEditScreen(ESR);
      DisposeWindow(EraseTopWindow);
    END {IF};
{}END {EditIntlc};




{}FUNCTION VariableName(i:WORD):STRING;
  BEGIN
    IF (i>0) AND (i<5) THEN
      VariableName := VarImage[VarType(Pred(i))]
    ELSE
      VariableName := '';
{}END {VariableName};




{}FUNCTION PickVar(row,col:BYTE; v:VarType; allowed:BYTE):VarType;
  VAR
    i    : WORD;
  BEGIN
    i := Succ(Ord(v));
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;

    PickSrch := CharPickSrch;
    IF PickWindow(@VariableName,allowed,col,row,col+6,row+6,FRAMED,Pcolor,'',i) THEN;
    CASE PickCmdNum OF
      PKSselect : PickVar := VarType(Pred(i));
      ELSE
        PickVar := v;
    END {CASE};
{}END {PickVar};




{}FUNCTION DirectionName(i:WORD):STRING;
  BEGIN
    IF (i>0) AND (i<4) THEN
      DirectionName := DirImage[DirectnType(Pred(i))]
    ELSE
      DirectionName := '';
{}END {DirectionName};




{}FUNCTION PickDir(row,col:BYTE; d:DirectnType):DirectnType;
  VAR
    i    : WORD;
  BEGIN
    i := Succ(Ord(d));
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;

    PickSrch := CharPickSrch;
    IF PickWindow(@DirectionName,3,col,row,col+6,row+6,FRAMED,Pcolor,'',i) THEN;
    CASE PickCmdNum OF
      PKSselect : PickDir := DirectnType(Pred(i));
      ELSE
        PickDir := d;
    END {CASE};
{}END {PickDir};




{}PROCEDURE EditRecord;
{---------------------------------------------------------------------------
   index  Variable   Description
   -----  --------   ---------------
    999)   SS(999)   xxxxxxxxxxxxxxx
---------------------------------------------------------------------------}
  CONST
    hNo  = 0;
    x0   = 5;
    y0   = 5;
    hite = 5;
    width= 37;
    title= ' Variables to Record ';
  TYPE
    RecType   = RECORD
      r : RecordType;
      s : STRING[2];
    END {RECORD};
  VAR
    WP   : WindowPtr;
    ESR  : ESrecord;
    INDEX: WORD;
    done : BOOLEAN;
    ExitCmd   : EStype;
    recVar    : RecType;

  BEGIN
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;

    IF MakeWindow(WP,x0,y0,x0+width,y0+hite,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) AND
    DisplayWindow(WP) THEN BEGIN
      InitESrecord(ESR);
      SetWrapMode(ESR,WrapAtEdges);
      SetEntryWindow(ESR,x0,y0,x0+width,y0+hite,FALSE,Bdy,Frm);

      SetPromptAttr(Bdy);
      SetFieldAttr(Bdy);
      SetStringAttr(Hdr);
      SetCtrlAttr(Frm);
      SetProtectAttrs(Dis,Dis);

      FastWriteWindow('index  Variable   Description    ',1,1,Bdy);
      FastWriteWindow('-----  --------   ---------------',2,1,Bdy);
      FastWriteWindow('   1)  TNOW       Simulated Time ',3,1,Bdy);

      IF Ksim7.nvar <= 1 THEN BEGIN
        FastWriteWindow('[ESC]',4,20,$4F);
        FastTextWindow('exits', 4,25);
        IF ReadKeyWord = 0 THEN;
        DisposeEditScreen(ESR);
        DisposeWindow(EraseTopWindow);
        Exit;
      END {IF};

      INDEX := 2;
      recVar.r := Ksim7.vvar[INDEX];
      recVar.s := VarImage[recVar.r.variable];

      SetPadChar(' ');
      SetProtection(On);
      SetRightJustify(On);
{00}    AddWordField  (ESR,')', 5, 6,'999', 5, 3,   hNo, 0,100,INDEX);
{01}    AddStringField(ESR,'(', 5,12,'XX' , 5,10, 2,hNo,NIL, recVar.s);

      SetProtection(Off);
{02}    AddNestedField(ESR,')', 5,16,'!',   5, 9,1,hNo);
{03}    AddWordField  (ESR,'',  5,11,'999', 5,13,hNo, 0,100,recVar.r.INDEX);

      SetPadChar('_');
      SetRightJustify(Off);
{04}    AddStringField(ESR,'',  5,19,CharStr('X',15), 5,20,15,hNo, NIL,recVar.r.description);

      done := FALSE;
      ESR.CurrentId := 0;
      REPEAT
        exitCmd := EditScreen(ESR,ESR.CurrentID,FALSE);
        CASE exitCmd OF
          ESdone,
          ESquit :
          BEGIN
            done := TRUE;
            Ksim7.vvar[INDEX] := recVar.r;
          END {BEGIN};

          ESprevRec :
          IF INDEX > 2 THEN BEGIN
            Ksim7.vvar[INDEX] := recVar.r;
            Dec(INDEX);
            recVar.r := Ksim7.vvar[INDEX];
            recVar.s := VarImage[recVar.r.variable];
          END {IF};

          ESnextRec :
          IF INDEX < Ksim7.nvar THEN BEGIN
            Ksim7.vvar[INDEX] := recVar.r;
            Inc(INDEX);
            recVar.r := Ksim7.vvar[INDEX];
            recVar.s := VarImage[recVar.r.variable];
          END {IF};

          ESnested :
          WITH recVar DO BEGIN
            r.variable := PickVar(5,5,r.variable,3);
            s := VarImage[r.variable];
          END {WITH};

        END {CASE};
      UNTIL done;
      DisposeEditScreen(ESR);
      DisposeWindow(EraseTopWindow);
    END {IF};
{}END {EditRecord};




{}PROCEDURE EditState;
{---------------------------------------------------------------------------
   index  Variable   Direction   Tolerance       Threshold
   -----  --------   ---------   -------------   -------------------
    999)   SS(999)      xxx      xxxxxx.xxxxxx   xxxxxxxxx.xxxxxxxxx
---------------------------------------------------------------------------}
  CONST
    hNo  = 0;
    x0   = 5;
    y0   = 5;
    hite = 5;
    width= 71;
    title= ' d()/dT threshold crossings ';
  TYPE
    EvntType  = RECORD
      e : EventType;
      v : STRING[2];
      d : STRING[3];
      t : STRING[19];
      s : STRING[25];
    END {RECORD};
  VAR
    WP   : WindowPtr;
    ESR  : ESrecord;
    INDEX: WORD;
    done : BOOLEAN;
    ExitCmd   : EStype;
    stateVar  : EvntType;

{}{}PROCEDURE SetTemp;
    BEGIN
      WITH StateVar DO BEGIN
        v := VarImage[stateVar.e.crossVar];
        d := DirImage[stateVar.e.directn];

        IF (e.tolerance > 0.000001) AND (e.tolerance < 99.0) THEN
          t := Trim(Real2Str(e.tolerance,13,9))
        ELSE
        IF (e.tolerance > 98.9) AND (e.tolerance < 999999.0) THEN
          t := Trim(Real2Str(e.tolerance,13,5))
        ELSE
          t := Trim(Real2Str(e.tolerance,13,-1));

        CASE e.ThresVar OF
          _const :
          IF (Abs(e.value) > 0.0001) AND (Abs(e.value) < 999999.0) THEN
            s := Trim(Real2Str(e.value,19, 9))
          ELSE
            s := Trim(Real2Str(e.value,19,-1));
          ELSE
            s := VarImage[e.thresVar]+'('+Long2LStr(e.ThresIndex,3)+')';
        END {CASE};
      END {WITH};
{}{}END {SetTemp};


  BEGIN
    TPwindow.Explode := TRUE;
    TPwindow.Shadow  := TRUE;
    TPwindow.ShadowAttr   := $08;
    TPwindow.ExplodeDelay := 10;

    IF MakeWindow(WP,x0,y0,x0+width,y0+hite,FRAMED,CLEARED,UNSAVED,bdy,frm,hdr,Title) AND
    DisplayWindow(WP) THEN BEGIN
      InitESrecord(ESR);
      SetWrapMode(ESR,WrapAtEdges);
      SetEntryWindow(ESR,x0,y0,x0+width,y0+hite,FALSE,Bdy,Frm);

      SetPromptAttr(Bdy);
      SetFieldAttr(Bdy);
      SetStringAttr(Hdr);
      SetCtrlAttr(Frm);
      SetProtectAttrs(Dis,Dis);

      FastWriteWindow('index  Variable   Direction   Tolerance       Threshold    ',1,1,Bdy);
      FastWriteWindow('-----  --------   ---------   -------------   -------------',2,1,Bdy);

      INDEX := 1;
      StateVar.e := Ksim6.svent[INDEX];
      SetTemp;

      SetPadChar(' ');
      SetProtection(On);
      SetRightJustify(On);

{00}    AddWordField  (ESR,')', 4, 6,'999', 4, 3,   hNo, 0,100,INDEX);
{01}    AddStringField(ESR,'(', 4,12,'XX' , 4,10, 2,hNo,NIL, stateVar.v);
{02}    AddStringField(ESR,'',  4,19,CharStr('X', 3), 4,23, 3,hNo, NIL,stateVar.d);
{03}    AddStringField(ESR,'',  4,31,CharStr('X',13), 4,32,13,hNo, NIL,stateVar.t);

      SetRightJustify(Off);
{04}    AddStringField(ESR,'',  4,47,CharStr('X',19), 4,48,19,hNo, NIL,stateVar.s);

      SetRightJustify(On);
      SetProtection(Off);

{05}    AddNestedField(ESR,')', 4,16,'!',   4, 9,1,hNo);
{06}    AddWordField  (ESR,'',  4,11,'999', 4,13,hNo, 0,100,stateVar.e.varIndex);
{07}    AddNestedField(ESR,'',  4,19,'!',   4,19,1,hNo);
{08}    AddNestedField(ESR,'',  4,31,'!',   4,31,1,hNo);
{09}    AddNestedField(ESR,'',  4,47,'!',   4,47,1,hNo);

      SetPadChar('_');
      SetRightJustify(Off);

      done := FALSE;
      ESR.CurrentId := 0;
      REPEAT
        exitCmd := EditScreen(ESR,ESR.CurrentID,FALSE);
        CASE exitCmd OF
          ESdone,
          ESquit :
          BEGIN
            done := TRUE;
            Ksim6.svent[INDEX] := stateVar.e;
          END {BEGIN};

          ESprevRec :
          IF INDEX > 1 THEN BEGIN
            Ksim6.svent[INDEX] := stateVar.e;
            Dec(INDEX);
            StateVar.e := Ksim6.svent[INDEX];
            SetTemp;
          END {IF};

          ESnextRec :
          IF INDEX < Ksim6.nthres THEN BEGIN
            Ksim6.svent[INDEX] := stateVar.e;
            Inc(INDEX);
            StateVar.e := Ksim6.svent[INDEX];
            SetTemp;
          END {IF};

          ESnested :
          WITH stateVar DO BEGIN
            CASE ESR.currentID OF
              5 : e.crossVar := PickVar(5,5,e.crossVar,2);
              7 : e.directn  := PickDir(5,5,e.directn);
              8 : e.tolerance:= EditWindowReal(5,5,0,0,e.tolerance,' Threshold Tolerance ','value: ');
              9 :
              BEGIN
                e.thresVar := PickVar(5,5,e.thresVar,4);
                CASE e.thresVar OF
                  _const : e.value := EditWindowReal(5,5,0,0,e.value,' Constant ','value: ');
                  ELSE
                    e.thresIndex := EditWindowLong(5,5,1,100,e.thresIndex,' '+VarImage[e.thresVar]+'(n) ','n = ');
                END {CASE};
              END {BEGIN};
            END {CASE};
            SetTemp;
          END {WITH};

        END {CASE};
      UNTIL done;
      DisposeEditScreen(ESR);
      DisposeWindow(EraseTopWindow);
    END {IF};
{}END {EditState};




{}PROCEDURE Dflt;
{+H
---------------------------------------------------------------------------
  Purpose     - Establish default (initial) values for the simulation run.

  Declaration - procedure Dflt;

  Remarks     - If this unit is not used, then there probably should be a
                DFLT procedure somewhere to do essentially this same task
                whether it be reading initial values from a file, another
                type of menu system, etc.
---------------------------------------------------------------------------}
  VAR
    M    : Menu;
    Ch   : CHAR;
    Key  : MenuKey;
    save : BYTE;
  BEGIN
    save     := textAttr;
    TextChar := '';
    textAttr := $70;
    ClrScr;
    InitMenu(M);

    WITH Ksim1,Ksim2,Ksim3,Ksim4,Ksim6,Ksim7 DO
      REPEAT
        Key := MenuChoice(M, Ch);
        IF ch = AltX THEN BEGIN
          ch  := #13;
          key := d_quit;
        END {IF};

        IF ch = ^M THEN
          CASE key OF
            d_about: About;

            d_quit :
            BEGIN
              EraseMenu(M, FALSE);
              Window(1,1,ScreenWidth,ScreenHeight);
              textAttr := save;
              ClrScr;
              Halt;
            END {BEGIN};

            d_fdoIt    :
            BEGIN
              EraseMenu(M, FALSE);
              Window(1,1,ScreenWidth,ScreenHeight);
              textAttr := save;
              ClrScr;
              Exit;
            END {BEGIN};

            d_gUser    : nname  := EditWindowStr(5,5,15,nname, ' Your Name ','');
            d_fLoad    : LoadCommon;
            d_fSave    : SaveCommon;
            d_gTitle   : nprjct := EditWindowStr(5,5,15,nprjct,' Project Title ','');
            d_gEcho    : iList  := EditWindowBool(5,5,'Y','N',iList,'','');
            d_gPrint   : iSimRep:= EditWindowBool(5,5,'Y','N',isimRep,'','');
            d_gDoSim   : iXqt   := EditWindowBool(5,5,'Y','N',ixqt,'','');
            d_gReinit  : reInit := EditWindowBool(5,5,'Y','N',reInit,'','');
            d_gReport  : RprtFileName := EditWindowStr(5,5,79,RprtFileName,'','');
            d_gData    : DataFileName := EditWindowStr(5,5,79,DataFileName,'','');

            d_cStart   : tStart := EditWindowReal(5,5,0.,999999.,tStart,'','');
            d_cStop    : tFin   := EditWindowReal(5,5,0.,999999.,tfin,  '','');
            d_cStep    : tStep  := EditWindowReal(5,5,0.,999999.,tStep, '','');
            d_cMinStep : dtMin  := EditWindowReal(5,5,0.,999999.,dtMin, '','');
            d_cMaxStep : dtMax  := EditWindowReal(5,5,0.,999999.,dtMax, '','');
            d_cRecStep : dtSave := EditWindowReal(5,5,0.,999999.,dtSave,'','');
            d_cRelErr  : rErr   := EditWindowReal(5,5,0.,1.,     rErr,  '','');
            d_cAbsErr  : aErr   := EditWindowReal(5,5,0.,1.,     aErr,  '','');
            d_cDbyDT   : neqdt  := EditWindowLong(5,5,0,100,neqdt,'','');
            d_cState   : neqst  := EditWindowLong(5,5,0,100,neqst,'','');

            d_rRecVar  : nvar   := EditWindowLong(5,5,0, 50,nvar, '','');
            d_rSave    : kkvent := EditWindowBool(5,5,'Y','N',kkvent,'','');

            d_sPrint   : sepf   := EditWindowBool(5,5,'Y','N',sepf,'','');
            d_sEvents  : nthres := EditWindowLong(5,5,0,100,nthres,'','');

            d_dAttrib  : matrib := EditWindowLong(5,5,0,100,matrib,'','');
            d_dRank    : lpSym  := PickRanking(5,5,lpSym);
            d_dPrint   : depf   := EditWindowBool(5,5,'Y','N',depf,'','');

            d_intlc    : EditIntlc;
            d_rEditVar : EditRecord;
            d_sEdit    : EditState;
          END {CASE};
      UNTIL FALSE;
{}END {Dflt};




BEGIN
END {BEGIN}.
