UNIT KsimDate;
{+H
---------------------------------------------------------------------------
  File        - KSIMDate.PAS
  Author      - Keith S. Brown
  Purpose     - KSB enhancements to TPdate.
  Revised     - 1991.0128 (KSB) Added HMStoTimeString & FileDateToDateTime.
              - 1992.0421 (KSB) Revamped format. Made BdRec visible.
              - 1992.0423 (KSB) Added FirstOf* and LastOf* functions.
              - 1993.0420 (KSB) Added KdateStringToDate function.
              - 1993.0804 (KSB) Reformatted with KPPF.
---------------------------------------------------------------------------}
INTERFACE
USES
  TPdate;

              {Date functions}
{}FUNCTION  DayOfYear(Julian : Date): INTEGER;
{}FUNCTION  FirstDayOfMonth(Julian : Date):DayType;
{}FUNCTION  JulianYear(Julian : Date):WORD;
{}FUNCTION  JulianMonth(Julian: Date):WORD;
{}FUNCTION  JulianDay( Julian : Date):WORD;
{}FUNCTION  NextDayOfWeek(Day : DayType) : DayType;
{}FUNCTION  PrevDayOfWeek(Day : DayType) : DayType;
{}FUNCTION  IncDayOfWeek(Day : DayType; DaysLater : INTEGER) : DayType;
{}FUNCTION  GoodJulianDate(Julian:Date):BOOLEAN;
{}FUNCTION  JulianIsLeapYear(Julian : Date):BOOLEAN;
{}FUNCTION  JulianDaysInMonth(Julian : Date):INTEGER;

{}FUNCTION  FirstOfYear(julian:Date):Date;
{}FUNCTION  LastOfYear(julian:Date):Date;
{}FUNCTION  FirstOfMonth(julian:Date):Date;
{}FUNCTION  LastOfMonth(julian:Date):Date;
{}FUNCTION  FirstOfWeek(julian:Date):Date;
{}FUNCTION  LastOfWeek(julian:Date):Date;

              {Time functions}
{}FUNCTION  ReturnHours(T:Time):BYTE;
{}FUNCTION  ReturnMinutes(T:Time):BYTE;

              {Time/Date formatting}
{}FUNCTION  DateStr(Julian:Date):DateString;
{}FUNCTION  FullDateStr(Julian:Date):DateString;
{}FUNCTION  TimeStr(T:Time):DateString;
{}FUNCTION  AmPmStr(T:Time):DateString;
{}FUNCTION  HMStoTimeString(Picture:DateString; Hours,Minutes,Seconds:BYTE):DateString;
{}FUNCTION  FileDateToDateTime(DatePicture,TimePicture:DateString; fDate:LongINT):STRING;
{}FUNCTION  KDateStringToDate(picture,s:STRING):Date;


     {====================================================================}

IMPLEMENTATION
USES
  DOS,
  TPstring, Ksim_Str;


               {--------------- Date Functions ------------------}


{}FUNCTION DayOfYear(Julian : Date): INTEGER;
{---------------------------------------------------------------------------
  Purpose     - Returns the number of days since Jan 1st (Jan 1st = 1)
---------------------------------------------------------------------------}
  VAR
    NewYears  : Date;
    d,m,y: INTEGER;
  BEGIN
    DateToDMY(julian,d,m,y);
    NewYears  := DMYtoDate(1,1,y);
    DayOfYear := Julian - NewYears + 1;
{}END {DayOfYear};




{}FUNCTION FirstDayOfMonth(Julian : Date):DayType;
{---------------------------------------------------------------------------
  Purpose     - Return the day of the week for the first day of the month
---------------------------------------------------------------------------}
  VAR
    FirstOfMonth   : Date;
    d,m,y: INTEGER;
  BEGIN
    DateToDMY(julian,d,m,y);
    FirstOfMonth    := DMYtoDate(1,m,y);
    FirstDayOfMonth := DayOfWeek(FirstOfMonth);
{}END {FirstDayOfMonth};




{}FUNCTION JulianYear(Julian : Date):WORD;
{---------------------------------------------------------------------------}
  VAR
    d,m,y: INTEGER;
  BEGIN
    DateToDMY(Julian,d,m,y);
    JulianYear := y;
{}END {JulianYear};




{}FUNCTION JulianMonth(Julian: Date):WORD;
{---------------------------------------------------------------------------}
  VAR
    d,m,y: INTEGER;
  BEGIN
    DateToDMY(Julian,d,m,y);
    JulianMonth := m;
{}END {JulianMonth};




{}FUNCTION JulianDay( Julian : Date):WORD;
{---------------------------------------------------------------------------}
  VAR
    d,m,y: INTEGER;
  BEGIN
    DateToDMY(Julian,d,m,y);
    JulianDay := d;
{}END {JulianDay};




{}FUNCTION NextDayOfWeek(Day : DayType) : DayType;
{---------------------------------------------------------------------------}
  BEGIN
    IF Ord(Day) < 6 THEN
      NextDayOfWeek := Succ(Day)
    ELSE
      NextDayOfWeek := Sunday;
{}END {NextDayOfWeek};




{}FUNCTION PrevDayOfWeek(Day : DayType) : DayType;
{---------------------------------------------------------------------------}
  BEGIN
    IF Ord(Day) > 0 THEN
      PrevDayOfWeek := Pred(Day)
    ELSE
      PrevDayOfWeek := Saturday;
{}END {PrevDayOfWeek};




{}FUNCTION IncDayOfWeek(Day : DayType; DaysLater : INTEGER) : DayType;
{---------------------------------------------------------------------------}
  VAR
    DayNum    : INTEGER;
  BEGIN
    DayNum := (Ord(Day) + DaysLater) MOD 7;
    IF DayNum < 0 THEN
      DayNum := DayNum + 7;
    IncDayOfWeek := DayType(DayNum);
{}END {IncDayOfWeek};




{}FUNCTION GoodJulianDate(Julian:Date):BOOLEAN;
{---------------------------------------------------------------------------}
  VAR
    d,m,y: INTEGER;
  BEGIN
    DateToDMY(Julian,d,m,y);
    GoodJulianDate := ValidDate(d,m,y);
{}END {GoodJulianDate};




{}FUNCTION JulianIsLeapYear(Julian : Date):BOOLEAN;
{---------------------------------------------------------------------------}
  BEGIN
    JulianIsLeapYear := IsLeapYear(JulianYear(Julian));
{}END {JulianIsLeapYear};




{}FUNCTION JulianDaysInMonth(Julian : Date):INTEGER;
{---------------------------------------------------------------------------}
  BEGIN
    JulianDaysInMonth := DaysInMonth(JulianMonth(Julian),JulianYear(Julian));
{}END {JulianDaysInMonth};




{}FUNCTION  FirstOfYear(julian:Date):Date;
{---------------------------------------------------------------------------
  Purpose     - Return the Julian date for 1 Jan of the specified year.
---------------------------------------------------------------------------}
  BEGIN
    FirstOfYear := DMYtoDate(1,1,JulianYear(julian));
{}END {FirstOfYear};




{}FUNCTION  LastOfYear(julian:Date):Date;
{---------------------------------------------------------------------------
  Purpose     - Return the Julian date for 31 Dec of the specified year.
---------------------------------------------------------------------------}
  BEGIN
    LastOfYear := DMYtoDate(31,12,JulianYear(julian));
{}END {LastOfYear};




{}FUNCTION  FirstOfMonth(julian:Date):Date;
{---------------------------------------------------------------------------
  Purpose     - Return the Julian date for the first of the specified month.
---------------------------------------------------------------------------}
  BEGIN
    FirstOfMonth := DMYtoDate(1,JulianMonth(julian),JulianYear(julian));
{}END {FirstOfMonth};




{}FUNCTION  LastOfMonth(julian:Date):Date;
{---------------------------------------------------------------------------
  Purpose     - Return the Julian date for the last day of the specified month.
---------------------------------------------------------------------------}
  VAR
    m,y  : WORD;
  BEGIN
    m := JulianMonth(julian);
    y := JulianYear(julian);
    CASE m OF
      1,3,5,7,8,10,12 : julian := DMYtoDate(31,m,y);
      4,6,9,11        : julian := DMYtoDate(30,m,y);
      ELSE
      IF IsLeapYear(y) THEN
        julian := DMYtoDate(29,m,y)
      ELSE
        julian := DMYtoDate(28,m,y);
    END {CASE};
    LastOfMonth := julian;
{}END {LastOfMonth};




{}FUNCTION  FirstOfWeek(julian:Date):Date;
{---------------------------------------------------------------------------
  Purpose     - Return the Julian date for Sunday of the specified week.
---------------------------------------------------------------------------}
  VAR
    dow  : DayType;
  BEGIN
    dow := DayOfWeek(julian);
    WHILE dow > Sunday DO BEGIN
      Dec(dow);
      Dec(julian);
    END {WHILE};

    FirstOfWeek := julian;
{}END {FirstOfWeek};




{}FUNCTION  LastOfWeek(julian:Date):Date;
{---------------------------------------------------------------------------
  Purpose     - Return the Julian date for Saturday of the specified week.
---------------------------------------------------------------------------}
  VAR
    dow  : DayType;
  BEGIN
    dow := DayOfWeek(julian);
    WHILE dow < Saturday DO BEGIN
      Inc(dow);
      Inc(julian);
    END {WHILE};

    LastOfWeek := julian;
{}END {LastOfWeek};




               {--------------- Time Functions ------------------}


{}FUNCTION ReturnHours(T:Time):BYTE;
{---------------------------------------------------------------------------}
  VAR
    h,m,s: BYTE;
  BEGIN
    TimeToHMS(T,h,m,s);
    ReturnHours := h;
{}END {ReturnHours};




{}FUNCTION ReturnMinutes(T:Time):BYTE;
{---------------------------------------------------------------------------}
  VAR
    h,m,s: BYTE;
  BEGIN
    TimeToHMS(T,h,m,s);
    ReturnMinutes := m;
{}END {ReturnMinutes};




               {------------ Time/Date Formatting ---------------}


{}FUNCTION DateStr(Julian:Date):DateString;
{---------------------------------------------------------------------------}
  BEGIN
    DateStr := DateToDateString('mm/dd/yy',Julian);
{}END {DateStr};




{}FUNCTION FullDateStr(Julian:Date):DateString;
{---------------------------------------------------------------------------}
  BEGIN
    FullDateStr := DateToDateString('mm/dd/yyyy',Julian);
{}END {FullDateStr};




{}FUNCTION TimeStr(T:Time):DateString;
{---------------------------------------------------------------------------}
  BEGIN
    TimeStr := TimeToTimeString('hh:mm',T);
{}END {TimeStr};




{}FUNCTION AmPmStr(T:Time):DateString;
{---------------------------------------------------------------------------}
  BEGIN
    AmPmStr := TimeToAmPmString('hh:mm te',T);
{}END {AmPmStr};




{}FUNCTION HMStoTimeString(Picture:DateString; Hours,Minutes,Seconds:BYTE):DateString;
{---------------------------------------------------------------------------}
  BEGIN
    HMStoTimeString := TimeToTimeString(Picture,HMStoTime(hours,minutes,seconds));
{}END {HMStoTimeString};




{}FUNCTION FileDateToDateTime(DatePicture,TimePicture:DateString; fDate:LongINT):STRING;
{---------------------------------------------------------------------------}
  VAR
    DT   : DateTime;
    s    : STRING;
  BEGIN
    DOS.UnpackTime(fDate,DT);

    IF DatePicture <> '' THEN
      s := DMYtoDateString(DatePicture,DT.day,DT.month,DT.year)
    ELSE
      s := '';

    IF TimePicture <> '' THEN
      s := s + HMStoTimeString(TimePicture,DT.hour,DT.min,DT.sec);

    FileDateToDateTime := s;
{}END {FileDateToDateTime};




{}FUNCTION KDateStringToDate(picture,s:STRING):Date;
{+H
---------------------------------------------------------------------------
  Purpose     - Convert a date string with an embedded 3-char alpha month
                name to a Julian date.
  Comments    - Given a string representation of a date (S) convert it to a
                Julian date, returned as the function result. S must be a
                string of the same length and form as PICTURE.  If the date
                represented by S is invalid, BADDATE is returned.
  Examples    - KDateStringToDate('dd-AAA-yyyy','26-MAR-1992') or
                KDateStringToDate('DD/aaa/yyyy',' 3-aug/1994')
  Revised     - 1993.0405 (KSB) Wrote initial version.
---------------------------------------------------------------------------}
  VAR
    mStr : DateString;
    mn   : DateString;
    L    : BYTE ABSOLUTE s;
    M    : BYTE ABSOLUTE picture;
    i,j  : WORD;
  BEGIN
    mStr := '';

    IF (L=M) THEN BEGIN
      i := Pos('AAA',StUpCase(picture));
      IF (i > 0) THEN BEGIN
        FOR j := 1 TO 3 DO BEGIN
          picture[j+i-1] := 'A';        {capitalize month name mask}
          s[j+i-1] := UpCase(s[j+i-1]); {capitalize 3-char month name}
        END {FOR};

        mStr := StUpCase(Copy(s,i,3));
        j := 1;
        WHILE j < 13 DO BEGIN           {cycle through the months}
          IF mStr = StUpCase(Copy(MonthString[j],1,3)) THEN BEGIN
            picture := Before(picture,'AAA') + 'mm' + After(picture,'AAA');
            mn := Long2Str(j);
            IF Length(mn) < 2 THEN
              mn := '0' + mn;
            s := Replace(s,mStr,mn);

            KDateStringToDate := DateStringToDate(picture,s);
            Exit;
          END ELSE
            Inc(j);
        END {WHILE};
        KDateStringToDate := BadDate;
      END ELSE
      IF (i = 0) THEN BEGIN
        KDateStringToDate := DateStringToDate(picture,s);
      END {IF};
    END ELSE
      KDateStringToDate := BadDate;
{}END {KDateStringToDate};




BEGIN
END {BEGIN}.
