{$A+,B-,D+,E+,F+,G+,I+,L+,N-,O-,P-,Q-,R+,S+,T-,V-,X-,Y-}
{$M 16384,0,655360}

PROGRAM CedarBogLake;
{+H
  Reference   - (SLAM) 10.6 An Illustration of continuous modeling; p.358

  Remarks     - (paraphrased from SLAM)

     Cedar Bog Lake [model developed by R.B. Williams "Computer
     Simulation of Energy Flow in Cedar Bog Lake, Minnesota Based
     on the Classical Studies of Lindeman".]

     The model consists of three species (Plants, Herbivores, and
     Carnivores), a SOLAR energy input, the Organic matter that settles
     on the bottom of the lake and the various losses to the Environment.
     All of the above factors are modeled in terms of their energy content,
     energy transfers and energy losses in calories/square centimeter.

     The lake energy input/transfer/loss is described via differential
     equations as:

      d(P)
      ----  = Solar - 4.03 x P
       dt

      d(H)
      ----  = 0.48 x P - 17.87 x H
       dt

      d(C)
      ----  = 4.85 x H -  4.65 x C
       dt

      d(O)
      ----  = 2.55 x P +  6.12 x H + 1.95 x C
       dt

      d(E)
      ----  = 1.00 x P +  6.90 x H + 2.70 x C
       dt


      With the initial conditions at time zero:

      P(o) = 0.83
      H(o) = 0.003
      C(o) = 0.0001
      O(o) = 0.0
      E(o) = 0.0

      and the annual solar radiation is modeled as

      Solar = 95.9 x (1.0 + 0.635 x Sin(2 x Pi x t))

      where t is in years.

      The above equations represent such processes as plant
      photosynthesis, predation of one species by another, and
      the decaying of dead species.  Environmental losses are
      due to respiration and migration.



  Revised     - 1993.0804 (KSB) Reformatted with KPPF.
}
USES
 Ksim_Com,
 Ksim_A,
 Ksim_B;


{}PROCEDURE Event(n:INTEGER);
  BEGIN
{}END {Event};




{}PROCEDURE Intlc;
  VAR
    atb  : StoreReal;
  BEGIN
    FillChar(atb,SizeOf(atb),0);

    {set initial values}
    WITH Ksim5 DO BEGIN
      ss[1] := 0.83;
      ss[2] := 0.003;
      ss[3] := 0.0001;
      ss[4] := 0.0;
      ss[5] := 0.0;
    END {WITH};

    {set start and ending times}
    WITH Ksim2 DO BEGIN
      tStart := 0.0;
      tFin   := 2.0;
    END {WITH};

    {set integration controls}
    WITH Ksim4 DO BEGIN
      dtSave := 0.025;       {frequency at which data is recorded}
      dtMax  := 0.025;       {max allowable step size}
      dtMin  := 0.0025;      {min allowable step size}
      neqdt  := 5;           {number of derivative equations}
      neqst  := 1;           {number of state equations}
      aerr   := 0.0;         {absolute error limit}
    END;

    {set up variables to record}
    WITH Ksim7 DO BEGIN
      nvar := 7;
      {vvar[1] is automatically <TNOW>}
      WITH vvar[2] DO BEGIN variable := _ss;  index := 1;  description := 'Plants';      END;
      WITH vvar[3] DO BEGIN variable := _ss;  index := 2;  description := 'Herbivores';  END;
      WITH vvar[4] DO BEGIN variable := _ss;  index := 3;  description := 'Carnovores';  END;
      WITH vvar[5] DO BEGIN variable := _ss;  index := 4;  description := 'Organic';     END;
      WITH vvar[6] DO BEGIN variable := _ss;  index := 5;  description := 'Environment'; END;
      WITH vvar[7] DO BEGIN variable := _ss;  index := 6;  description := 'Solar Energy';END;
    END {WITH};
{}END {Intlc};


{}PROCEDURE State;
{
  Purpose     - Compute the current value of each state variable or its
                derivative.
}
  BEGIN
    WITH Ksim5 DO BEGIN
      ss[6] := 95.9*(1.+0.635*Sin(2.*Pi*Ksim2.Tnow));

      dd[1] :=      ss[6] -  4.03*ss[1];
      dd[2] := 0.48*ss[1] - 17.87*ss[2];
      dd[3] := 4.85*ss[2] -  4.65*ss[3];
      dd[4] := 2.55*ss[1] +  6.12*ss[2];
      dd[5] :=      ss[1] +  6.90*ss[2] + 2.70*ss[3];
    END {WITH};
{}END {State};


BEGIN
  EventPtr := @Event;        {link in Event handler}
  IntlcPtr := @Intlc;        {  and initialization}
  StatePtr := @State;        {  and state, differential equations}
  DfltPtr  := @Ksim_B.Dflt;  {  and menu system}

  WriteLn(MemAvail);

  cfgName      := 'CBL.CFG';
  RprtFileName := 'CBL.RPT';
  DataFileName := 'CBL.DAT';
  Ksim;                      {execute the simulation}

  WriteLn(MemAvail);
END {CedarBogLake}.